/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import ome.io.nio.AbstractBuffer;

public class FileBuffer
extends AbstractBuffer {
    FileChannel channel;
    private final String mode;

    public FileBuffer(String path, String mode) {
        super(path);
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public void flush(boolean includeMetadata) throws IOException {
        if (this.channel != null) {
            this.channel.force(includeMetadata);
        }
    }

    private FileChannel getFileChannel() throws FileNotFoundException {
        if (this.channel == null) {
            RandomAccessFile file = new RandomAccessFile(this.getPath(), this.mode);
            this.channel = file.getChannel();
        }
        return this.channel;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.getFileChannel().read(dst);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        return this.getFileChannel().read(dst, position);
    }

    public int write(ByteBuffer src, long position) throws IOException {
        return this.getFileChannel().write(src, position);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.getFileChannel().write(src);
    }

    public long size() throws IOException {
        return this.getFileChannel().size();
    }

    public void truncate(long size) throws IOException {
        this.getFileChannel().truncate(size);
    }

    public boolean truncateIfSmaller(long size) throws IOException {
        FileChannel fc = this.getFileChannel();
        if (fc.size() < size) {
            return false;
        }
        fc.truncate(size);
        return true;
    }
}

