/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import ome.conditions.ResourceError;
import ome.io.nio.AbstractFileSystemService;
import ome.model.display.Thumbnail;
import ome.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailService
extends AbstractFileSystemService {
    private static transient Logger log = LoggerFactory.getLogger(ThumbnailService.class);

    @Deprecated
    public ThumbnailService(String path) {
        super(path);
    }

    public ThumbnailService(String path, boolean isReadOnlyRepo) {
        super(path, isReadOnlyRepo);
    }

    public void createThumbnail(Thumbnail thumbnail, byte[] buf) throws IOException {
        String path = this.getThumbnailPath(thumbnail.getId());
        this.createSubpath(path);
        FileOutputStream stream = new FileOutputStream(path);
        stream.write(buf);
        stream.close();
    }

    public long getThumbnailLength(Thumbnail thumbnail) {
        File f = new File(this.getThumbnailPath(thumbnail.getId()));
        return f.length();
    }

    public byte[] getThumbnail(Thumbnail thumbnail) throws IOException {
        byte[] buf = new byte[(int)this.getThumbnailLength(thumbnail)];
        return this.getThumbnail(thumbnail, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getThumbnail(Thumbnail thumbnail, byte[] buf) throws IOException {
        String path = this.getThumbnailPath(thumbnail.getId());
        FileInputStream stream = new FileInputStream(path);
        try {
            stream.read(buf, 0, buf.length);
        }
        finally {
            Utils.closeQuietly((Closeable)stream);
        }
        return buf;
    }

    public FileOutputStream getThumbnailOutputStream(Thumbnail thumbnail) throws IOException {
        String path = this.getThumbnailPath(thumbnail.getId());
        this.createSubpath(path);
        return new FileOutputStream(path);
    }

    public boolean getThumbnailExists(Thumbnail thumbnail) throws IOException {
        String path = this.getThumbnailPath(thumbnail.getId());
        return new File(path).exists();
    }

    public void removeThumbnails(List<Long> thumbnailIds) {
        boolean success = false;
        for (Long id : thumbnailIds) {
            String thumbnailPath = this.getThumbnailPath(id);
            File file = new File(thumbnailPath);
            if (!file.exists()) continue;
            success = file.delete();
            if (!success) {
                throw new ResourceError("Thumbnail " + file.getName() + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info("INFO: Thumbnail " + file.getName() + " deleted.");
        }
    }
}

