/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.TokenFilterDefMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerDefMapping {
    private SearchMapping mapping;
    private Map<String, Object> analyzerDef;
    private Map<String, Object> tokenizer;

    AnalyzerDefMapping(String name, Class<? extends TokenizerFactory> tokenizerFactory, SearchMapping mapping) {
        this.mapping = mapping;
        this.analyzerDef = new HashMap<String, Object>();
        mapping.addAnalyzerDef(this.analyzerDef);
        this.analyzerDef.put("name", name);
        this.tokenizer = new HashMap<String, Object>();
        this.tokenizer.put("factory", tokenizerFactory);
        this.analyzerDef.put("tokenizer", this.tokenizer);
    }

    public AnalyzerDefMapping tokenizerParam(String name, String value) {
        Map<String, Object> param = SearchMapping.addElementToAnnotationArray(this.tokenizer, "params");
        param.put("name", name);
        param.put("value", value);
        return this;
    }

    public TokenFilterDefMapping filter(Class<? extends TokenFilterFactory> factory) {
        return new TokenFilterDefMapping(factory, this.analyzerDef, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

