/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import omero.LockTimeout;
import omero.RLong;
import omero.RType;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.IRoiPrx;
import omero.api.IUpdatePrx;
import omero.api.RoiOptions;
import omero.api.RoiResult;
import omero.cmd.CmdCallbackI;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.GraphQuery;
import omero.cmd.Request;
import omero.cmd.Response;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.facility.Facility;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROICoordinate;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.ShapeData;
import omero.gateway.util.ModelMapper;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Pojos;
import omero.gateway.util.PyTablesUtils;
import omero.gateway.util.Requests;
import omero.model.FolderRoiLink;
import omero.model.FolderRoiLinkI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Line;
import omero.model.Polyline;
import omero.model.Roi;
import omero.model.Shape;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;

public class ROIFacility
extends Facility {
    private DataManagerFacility dm;
    private BrowseFacility browse;

    ROIFacility(Gateway gateway) throws ExecutionException {
        super(gateway);
        this.dm = gateway.getFacility(DataManagerFacility.class);
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    public int getROICount(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        if (imageId < 0L) {
            return -1;
        }
        try {
            ParametersI p = new ParametersI();
            p.addId(imageId);
            String query = "select count(*) from Roi roi where roi.image.id = :id";
            IQueryPrx service = this.gateway.getQueryService(ctx);
            List tmp1 = service.projection(query, (Parameters)p);
            if (CollectionUtils.isEmpty((Collection)tmp1)) {
                throw new Exception("Unexpected HQL result");
            }
            List tmp2 = (List)tmp1.iterator().next();
            if (CollectionUtils.isEmpty((Collection)tmp2)) {
                throw new Exception("Unexpected HQL result");
            }
            RType result = (RType)tmp2.iterator().next();
            if (!(result instanceof RLong)) {
                throw new Exception("Unexpected HQL result");
            }
            return (int)((RLong)result).getValue();
        }
        catch (Exception e) {
            this.handleException(this, e, "Can't load ROI count for image " + imageId);
            return -1;
        }
    }

    public ROIResult loadROI(SecurityContext ctx, long roiId) throws DSOutOfServiceException, DSAccessException {
        if (roiId < 0L) {
            return null;
        }
        try {
            IRoiPrx svc = this.gateway.getROIService(ctx);
            RoiOptions options = new RoiOptions();
            RoiResult rr = svc.findByRoi(roiId, options);
            ROIResult result = new ROIResult(PojoMapper.asCastedDataObjects(rr.rois));
            return result;
        }
        catch (ServerError e) {
            this.handleException(this, e, "Couldn't get ROIs by plane.");
            return null;
        }
    }

    public List<ROIResult> loadROIsByPlane(SecurityContext ctx, long imageID, int z, int t) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ROIResult> results = new ArrayList<ROIResult>();
        if (imageID < 0L) {
            return results;
        }
        try {
            IRoiPrx svc = this.gateway.getROIService(ctx);
            RoiOptions options = new RoiOptions();
            RoiResult r = svc.findByPlane(imageID, z, t, options);
            ROIResult result = new ROIResult(PojoMapper.asCastedDataObjects(r.rois));
            results.add(result);
        }
        catch (ServerError e) {
            this.handleException(this, e, "Couldn't get ROIs by plane.");
        }
        return results;
    }

    public List<ROIResult> loadROIs(SecurityContext ctx, long imageID) throws DSOutOfServiceException, DSAccessException {
        return this.loadROIs(ctx, imageID, null, this.gateway.getLoggedInUser().getId());
    }

    public List<ROIResult> loadROIs(SecurityContext ctx, long imageID, List<Long> measurements) throws DSOutOfServiceException, DSAccessException {
        return this.loadROIs(ctx, imageID, measurements, -1L);
    }

    public List<ROIResult> loadROIs(SecurityContext ctx, long imageID, List<Long> measurements, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ROIResult> results = new ArrayList<ROIResult>();
        if (imageID < 0L) {
            return results;
        }
        try {
            RoiResult r;
            IRoiPrx svc = this.gateway.getROIService(ctx);
            RoiOptions options = new RoiOptions();
            if (userID >= 0L) {
                options.userId = rtypes.rlong((long)userID);
            }
            if (CollectionUtils.isEmpty(measurements)) {
                options = new RoiOptions();
                r = svc.findByImage(imageID, options);
                if (r == null) {
                    return results;
                }
                results.add(new ROIResult(PojoMapper.asCastedDataObjects(r.rois)));
            } else {
                Map map = svc.getMeasuredRoisMap(imageID, measurements, options);
                if (map == null) {
                    return results;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Long id = (Long)entry.getKey();
                    r = (RoiResult)entry.getValue();
                    ROIResult result = new ROIResult(PojoMapper.asCastedDataObjects(r.rois), id);
                    result.setResult(PyTablesUtils.createTableResult(svc.getTable(id.longValue()), "Image", imageID));
                    results.add(result);
                }
            }
            Collection<FolderData> folders = this.browse.getFolders(ctx);
            for (ROIResult rr : results) {
                rr.setFolders(folders);
            }
        }
        catch (Exception e) {
            this.handleException(this, e, "Cannot load the ROI for image: " + imageID);
        }
        return results;
    }

    public Collection<ROIData> saveROIs(SecurityContext ctx, long imageID, Collection<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        return this.saveROIs(ctx, imageID, -1L, roiList);
    }

    public Map<FolderData, Collection<ROIData>> addRoisToFolders(SecurityContext ctx, long imageID, Collection<ROIData> roiList, Collection<FolderData> folders) throws DSOutOfServiceException, DSAccessException {
        return this.addRoisToFolders(ctx, imageID, roiList, folders, false);
    }

    public Map<FolderData, Collection<ROIData>> addRoisToFolders(SecurityContext ctx, long imageID, Collection<ROIData> roiList, Collection<FolderData> folders, boolean removeFromOtherFolders) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(roiList) || CollectionUtils.isEmpty(folders)) {
            return Collections.emptyMap();
        }
        try {
            ArrayList<IObject> toSave;
            ArrayList<FolderData> savedFolders = new ArrayList<FolderData>();
            ArrayList<IObject> foldersToSave = new ArrayList<IObject>();
            for (FolderData folder : folders) {
                if (folder.getId() < 0L) {
                    foldersToSave.add(folder.asIObject());
                    continue;
                }
                savedFolders.add(folder);
            }
            if (!foldersToSave.isEmpty()) {
                List ids = this.gateway.getUpdateService(ctx).saveAndReturnIds(foldersToSave);
                Collection<FolderData> tmp = this.gateway.getFacility(BrowseFacility.class).getFolders(ctx, ids);
                savedFolders.addAll(tmp);
            }
            Collection<ROIData> saved = this.saveROIs(ctx, imageID, roiList);
            HashSet<Long> ids = new HashSet<Long>();
            for (ROIData d : saved) {
                ids.add(d.getId());
            }
            for (ROIData d : roiList) {
                if (d.isClientSide()) continue;
                ids.add(d.getId());
            }
            ArrayList<FolderData> foldersReloaded = savedFolders.isEmpty() ? savedFolders : this.gateway.getFacility(BrowseFacility.class).getFolders(ctx, Pojos.extractIds(savedFolders));
            Collection<Roi> rois = this.loadServerRois(ctx, ids);
            if (removeFromOtherFolders) {
                toSave = new ArrayList<IObject>();
                for (Roi roi : rois) {
                    roi.clearFolderLinks();
                    toSave.add((IObject)roi);
                }
                List<IObject> tmp = this.gateway.getFacility(DataManagerFacility.class).saveAndReturnObject(ctx, toSave, null, null);
                rois.clear();
                Iterator iterator = tmp.iterator();
                while (iterator.hasNext()) {
                    IObject t = (IObject)iterator.next();
                    rois.add((Roi)t);
                }
            }
            toSave = new ArrayList();
            for (Roi roi : rois) {
                for (FolderData folder : foldersReloaded) {
                    boolean linkExists = false;
                    for (FolderRoiLink link : roi.copyFolderLinks()) {
                        if (link.getParent().getId().getValue() != folder.getId()) continue;
                        linkExists = true;
                        break;
                    }
                    if (linkExists) continue;
                    FolderRoiLinkI link = new FolderRoiLinkI();
                    link.setParent(folder.asFolder());
                    link.setChild(roi);
                    toSave.add((IObject)link);
                }
            }
            HashMap<FolderData, Collection<ROIData>> result = new HashMap<FolderData, Collection<ROIData>>();
            if (!toSave.isEmpty()) {
                List<IObject> list = this.gateway.getFacility(DataManagerFacility.class).saveAndReturnObject(ctx, toSave, null, null);
                for (IObject obj : list) {
                    FolderRoiLink link = (FolderRoiLink)obj;
                    FolderData fd = new FolderData(link.getParent());
                    ROIData rd = new ROIData(link.getChild());
                    if (this.getById(result, fd) == null) {
                        result.put(fd, new ArrayList());
                    }
                    this.getById(result, fd).add(rd);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(this, e, "Cannot add ROIs to Folder ");
            return Collections.EMPTY_MAP;
        }
    }

    private Collection<ROIData> getById(Map<FolderData, Collection<ROIData>> map, FolderData f) {
        for (FolderData fd : map.keySet()) {
            if (fd.getId() != f.getId()) continue;
            return map.get(fd);
        }
        ArrayList<ROIData> coll = new ArrayList<ROIData>();
        map.put(f, coll);
        return coll;
    }

    public void removeRoisFromFolders(SecurityContext ctx, long imageID, Collection<ROIData> roiList, Collection<FolderData> folders) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(roiList) || CollectionUtils.isEmpty(folders)) {
            return;
        }
        try {
            Collection<Long> roiIds = Pojos.extractIds(roiList);
            Collection<Roi> serverRoiList = this.loadServerRois(ctx, roiIds);
            ArrayList<Long> toDelete = new ArrayList<Long>();
            for (ROIData roi : roiList) {
                if (roi.isClientSide()) continue;
                for (Roi serverRoi : serverRoiList) {
                    if (serverRoi.getId().getValue() != roi.getId()) continue;
                    for (FolderData folder : folders) {
                        for (FolderRoiLink link : serverRoi.copyFolderLinks()) {
                            if (link.getParent().getId().getValue() != folder.getId()) continue;
                            toDelete.add(link.getId().getValue());
                        }
                    }
                }
            }
            if (!toDelete.isEmpty()) {
                GraphQuery req = ((Requests.Delete2Builder)((Requests.Delete2Builder)Requests.delete().target("FolderRoiLink")).id(toDelete)).build();
                CmdCallbackI cb = this.gateway.submit(ctx, (Request)req);
                cb.block(10000L);
            }
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot remove ROIs to Folder ");
        }
    }

    public Collection<ROIData> saveROIs(SecurityContext ctx, long imageID, long userID, Collection<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(roiList)) {
            return Collections.emptyList();
        }
        try {
            IUpdatePrx updateService = this.gateway.getUpdateService(ctx);
            IRoiPrx svc = this.gateway.getROIService(ctx);
            ArrayList<Object> toSave = new ArrayList<Object>();
            if (imageID < 0L) {
                for (ROIData r : roiList) {
                    if (r.getId() <= -1L) continue;
                    throw new NotImplementedException("Modification of existing ROIs not attached to an image is not implemented yet.");
                }
                for (ROIData r : roiList) {
                    toSave.add(r.asIObject());
                }
            } else {
                RoiOptions options = new RoiOptions();
                if (userID >= 0L) {
                    options.userId = rtypes.rlong((long)userID);
                }
                RoiResult serverReturn = svc.findByImage(imageID, new RoiOptions());
                HashMap<Long, Roi> roiMap = new HashMap<Long, Roi>();
                List serverRoiList = serverReturn.rois;
                HashMap<Long, ROIData> clientROIMap = new HashMap<Long, ROIData>();
                for (ROIData roi : roiList) {
                    if (roi == null) continue;
                    clientROIMap.put(roi.getId(), roi);
                }
                for (Roi r : serverRoiList) {
                    if (r == null || !clientROIMap.containsKey(r.getId().getValue())) continue;
                    roiMap.put(r.getId().getValue(), r);
                }
                ArrayList<Long> deleted = new ArrayList<Long>();
                ImageI unloaded = new ImageI(imageID, false);
                for (ROIData roi : roiList) {
                    ROICoordinate coord;
                    int t;
                    int z;
                    Shape s;
                    ShapeData shape;
                    if (!roiMap.containsKey(roi.getId())) {
                        Roi rr = (Roi)roi.asIObject();
                        rr.setImage((Image)unloaded);
                        toSave.add(rr);
                        continue;
                    }
                    Roi serverRoi = (Roi)roiMap.get(roi.getId());
                    Iterator<List<ShapeData>> shapeIterator = roi.getIterator();
                    HashMap<ROICoordinate, ShapeData> clientCoordMap = new HashMap<ROICoordinate, ShapeData>();
                    while (shapeIterator.hasNext()) {
                        List<ShapeData> shapeList = shapeIterator.next();
                        shape = shapeList.get(0);
                        if (shape == null) continue;
                        clientCoordMap.put(shape.getROICoordinate(), shape);
                    }
                    HashMap<ROICoordinate, Shape> serverCoordMap = new HashMap<ROICoordinate, Shape>();
                    if (serverRoi != null) {
                        for (int i = 0; i < serverRoi.sizeOfShapes(); ++i) {
                            s = serverRoi.getShape(i);
                            if (s == null) continue;
                            z = -1;
                            t = -1;
                            if (s.getTheZ() != null) {
                                z = s.getTheZ().getValue();
                            }
                            if (s.getTheT() != null) {
                                t = s.getTheT().getValue();
                            }
                            serverCoordMap.put(new ROICoordinate(z, t), s);
                        }
                    }
                    Iterator si = serverCoordMap.entrySet().iterator();
                    ArrayList<ROICoordinate> removed = new ArrayList<ROICoordinate>();
                    while (si.hasNext()) {
                        Map.Entry entry = si.next();
                        coord = (ROICoordinate)entry.getKey();
                        if (!clientCoordMap.containsKey(coord)) {
                            s = (Shape)entry.getValue();
                            if (s == null) continue;
                            serverRoi.removeShape(s);
                            toSave.add(serverRoi);
                            continue;
                        }
                        s = (Shape)entry.getValue();
                        if (!(s instanceof Line) && !(s instanceof Polyline)) continue;
                        shape = (ShapeData)clientCoordMap.get(coord);
                        if ((!(s instanceof Line) || !(shape.asIObject() instanceof Polyline)) && (!(s instanceof Polyline) || !(shape.asIObject() instanceof Line))) continue;
                        removed.add(coord);
                        serverRoi.removeShape(s);
                        toSave.add(serverRoi);
                        deleted.add(s.getId().getValue());
                    }
                    for (Map.Entry entry : clientCoordMap.entrySet()) {
                        Shape serverShape;
                        int j;
                        coord = (ROICoordinate)entry.getKey();
                        shape = (ShapeData)entry.getValue();
                        Shape sh = (Shape)shape.asIObject();
                        ModelMapper.unloadCollections((IObject)sh);
                        if (shape == null) continue;
                        if (!serverCoordMap.containsKey(coord)) {
                            serverRoi.addShape(sh);
                            continue;
                        }
                        if (!shape.isDirty()) continue;
                        int shapeIndex = -1;
                        if (deleted.contains(shape.getId())) {
                            serverRoi.addShape(sh);
                            break;
                        }
                        for (j = 0; j < serverRoi.sizeOfShapes(); ++j) {
                            long sid;
                            if (serverRoi == null || (serverShape = serverRoi.getShape(j)) == null || serverShape.getId() == null || (sid = serverShape.getId().getValue()) != shape.getId()) continue;
                            shapeIndex = j;
                            break;
                        }
                        if (shapeIndex == -1) {
                            serverShape = null;
                            shapeIndex = -1;
                            for (j = 0; j < serverRoi.sizeOfShapes(); ++j) {
                                if (serverRoi == null) continue;
                                z = 0;
                                t = 0;
                                serverShape = serverRoi.getShape(j);
                                if (serverShape == null) continue;
                                if (serverShape.getTheT() != null) {
                                    t = serverShape.getTheT().getValue();
                                }
                                if (serverShape.getTheZ() != null) {
                                    z = serverShape.getTheZ().getValue();
                                }
                                if (t != shape.getT() || z != shape.getZ()) continue;
                                shapeIndex = j;
                                break;
                            }
                            if (shapeIndex != -1) {
                                if (!removed.contains(coord)) {
                                    try {
                                        Response res = this.dm.delete(ctx, (IObject)serverShape).loop(10, 500L);
                                        if (res instanceof GraphException) {
                                            GraphException ge = (GraphException)res;
                                            this.logWarn(this, "Could not delete shape " + serverShape.getId().getValue() + ": " + ge.message, null);
                                        }
                                        if (res instanceof ERR) {
                                            this.logWarn(this, "Could not delete shape " + serverShape.getId().getValue(), null);
                                        }
                                    }
                                    catch (LockTimeout e) {
                                        this.logWarn(this, "Could not delete shape " + serverShape.getId().getValue() + ", request timed out.", null);
                                    }
                                }
                                serverRoi.addShape(sh);
                                continue;
                            }
                            throw new Exception("serverRoi.shapeList is corrupted");
                        }
                        serverRoi.setShape(shapeIndex, sh);
                    }
                    if (serverRoi == null) continue;
                    Roi ri = (Roi)roi.asIObject();
                    serverRoi.setDescription(ri.getDescription());
                    serverRoi.setImage((Image)unloaded);
                    toSave.add(serverRoi);
                }
            }
            List updated = updateService.saveAndReturnArray(toSave);
            ArrayList<ROIData> result = new ArrayList<ROIData>();
            for (IObject r : updated) {
                result.add(new ROIData((Roi)r));
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(this, e, "Cannot Save the ROI for image: " + imageID);
            return new ArrayList<ROIData>();
        }
    }

    public Collection<FolderData> getROIFolders(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        if (imageId < 0L) {
            return Collections.emptyList();
        }
        try {
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("imageId", imageId);
            sb.append("select roilink from FolderRoiLink as roilink ");
            sb.append("left outer join fetch roilink.parent as folder ");
            sb.append("left outer join fetch roilink.child as roi ");
            sb.append("left outer join fetch roi.image as image ");
            sb.append("where image.id = :imageId ");
            List links = qs.findAllByQuery(sb.toString(), (Parameters)param);
            ArrayList<FolderData> result = new ArrayList<FolderData>();
            for (IObject l : links) {
                FolderRoiLink link = (FolderRoiLink)l;
                result.add(new FolderData(link.getParent()));
            }
            HashSet<Long> ids = new HashSet<Long>();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                FolderData next = (FolderData)it.next();
                if (ids.contains(next.getId())) {
                    it.remove();
                    continue;
                }
                ids.add(next.getId());
            }
            return result;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load ROI folders.");
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<ROIResult> loadROIsForFolder(SecurityContext ctx, long imageId, long folderId) throws DSOutOfServiceException, DSAccessException {
        if (imageId < 0L || folderId < 0L) {
            return Collections.emptyList();
        }
        try {
            List<ROIResult> roiresults = this.loadROIs(ctx, imageId);
            IQueryPrx qs = this.gateway.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("folderId", folderId);
            sb.append("select roilink from FolderRoiLink as roilink ");
            sb.append("left outer join fetch roilink.parent as folder ");
            sb.append("left outer join fetch roilink.child as roi ");
            sb.append("where folder.id = :folderId ");
            List links = qs.findAllByQuery(sb.toString(), (Parameters)param);
            HashSet<Long> roiIds = new HashSet<Long>();
            for (IObject l : links) {
                FolderRoiLink link = (FolderRoiLink)l;
                roiIds.add(link.getChild().getId().getValue());
            }
            Iterator<ROIResult> it = roiresults.iterator();
            while (it.hasNext()) {
                ROIResult r = it.next();
                Iterator<ROIData> it2 = r.getROIs().iterator();
                while (it2.hasNext()) {
                    ROIData roi = it2.next();
                    if (roiIds.contains(roi.getId())) continue;
                    it2.remove();
                }
                if (!r.getROIs().isEmpty()) continue;
                it.remove();
            }
            return roiresults;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Cannot load ROIs for folder " + folderId);
            return Collections.EMPTY_LIST;
        }
    }

    private Collection<Roi> loadServerRois(SecurityContext ctx, Collection<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        try {
            IQueryPrx service = this.gateway.getQueryService(ctx);
            ParametersI p = new ParametersI();
            p.addIds(ids);
            String query = "select distinct roi from Roi roi left outer join fetch roi.folderLinks left outer join fetch roi.shapes where roi.id in (:ids)";
            List objs = service.findAllByQuery(query, (Parameters)p);
            ArrayList<Roi> result = new ArrayList<Roi>(objs.size());
            for (IObject obj : objs) {
                result.add((Roi)obj);
            }
            return result;
        }
        catch (ServerError e) {
            this.handleException(this, e, "Cannot add ROIs to Folder ");
            return Collections.EMPTY_LIST;
        }
    }
}

