/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.sql.Timestamp;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.Annotation;
import omero.model.IObject;
import omero.rtypes;

public abstract class AnnotationData
extends DataObject {
    public static final String FILE_TRANSFER_NS = "openmicroscopy.org/omero/import/fileTransfer";

    protected AnnotationData(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("annotationClass cannot be null");
        }
        try {
            Annotation a = annotationClass.newInstance();
            this.setValue((IObject)a);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unkown annotation type: " + annotationClass.getName());
        }
    }

    protected <A extends Annotation> AnnotationData(A annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.setValue((IObject)annotation);
    }

    public void setNameSpace(String name) {
        this.asAnnotation().setNs(name == null ? null : rtypes.rstring((String)name));
    }

    public String getNameSpace() {
        RString ns = this.asAnnotation().getNs();
        return ns == null ? null : ns.getValue();
    }

    public Timestamp getLastModified() {
        if (this.nullDetails()) {
            return null;
        }
        return this.timeOfEvent(this.getDetails().getCreationEvent());
    }

    public String getDescription() {
        RString desc = this.asAnnotation().getDescription();
        return desc == null ? null : desc.getValue();
    }

    public void setDescription(String description) {
        this.asAnnotation().setDescription(description == null ? null : rtypes.rstring((String)description));
    }

    public abstract void setContent(Object var1);

    public abstract Object getContent();

    public abstract String getContentAsString();
}

