/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RBool;
import omero.RInt;
import omero.RString;
import omero.RTime;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.SetMutator;
import omero.gateway.model.TextualAnnotationData;
import omero.model.Annotation;
import omero.model.CommentAnnotation;
import omero.model.DatasetImageLink;
import omero.model.Fileset;
import omero.model.Format;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImageI;
import omero.model.Instrument;
import omero.model.LongAnnotation;
import omero.model.OriginalFile;
import omero.model.Pixels;
import omero.rtypes;

public class ImageData
extends DataObject {
    public static final String NAME = "ome.model.core.Image_name";
    public static final String DESCRIPTION = "ome.model.core.Image_description";
    public static final String PIXELS = "ome.model.core.Image_pixels";
    public static final String ANNOTATIONS = "ome.model.core.Image_annotationLinks";
    public static final String DATASET_LINKS = "ome.model.core.Image_datasetLinks";
    private List<PixelsData> allPixels;
    private Set<DatasetData> datasets;
    private Set<AnnotationData> annotations;
    private Long annotationCount;
    private String pathToFile;
    private int index;
    private String parentFilePath;
    private OriginalFile reference;

    public ImageData() {
        this.setDirty(true);
        this.setValue((IObject)new ImageI());
        this.index = -1;
    }

    public ImageData(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)image);
        this.index = -1;
    }

    public void setPathToFile(String path) {
        this.pathToFile = path == null ? this.getName() : path;
    }

    public void setReference(OriginalFile reference) {
        this.reference = reference;
    }

    public OriginalFile getReference() {
        return this.reference;
    }

    public String getPathToFile() {
        return this.pathToFile;
    }

    public void setParentFilePath(String path, int index) {
        this.parentFilePath = path;
        this.index = index;
    }

    public String getParentFilePath() {
        return this.parentFilePath;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSeries() {
        Image image = this.asImage();
        RInt value = image.getSeries();
        if (value == null) {
            return 0;
        }
        return value.getValue();
    }

    public String getFormat() {
        Image image = this.asImage();
        Format format = image.getFormat();
        if (format == null) {
            return null;
        }
        return format.getValue().getValue();
    }

    public void setRegisteredFile(Image object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Image)) {
            throw new IllegalArgumentException("Image not supported.");
        }
        Image img = this.asImage();
        img.setId(object.getId());
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asImage().setName(rtypes.rstring((String)name));
    }

    public String getName() {
        RString n = this.asImage().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asImage().setDescription(description == null ? null : rtypes.rstring((String)description));
    }

    public String getDescription() {
        RString d = this.asImage().getDescription();
        return d == null ? null : d.getValue();
    }

    public boolean isArchived() {
        RBool value = this.asImage().getArchived();
        if (value == null) {
            Fileset fs = this.asImage().getFileset();
            return fs != null;
        }
        return value.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asImage().getAnnotationLinksCountPerOwner();
    }

    public Timestamp getInserted() {
        return this.timeOfEvent(this.asImage().getDetails().getCreationEvent());
    }

    public Timestamp getAcquisitionDate() {
        RTime time = this.asImage().getAcquisitionDate();
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public PixelsData getDefaultPixels() {
        List<PixelsData> list = this.getAllPixels();
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void setDefaultPixels(PixelsData defaultPixels) {
        if (this.getDefaultPixels() == defaultPixels) {
            return;
        }
        this.setDirty(true);
        this.allPixels = null;
        this.asImage().setPrimaryPixels(defaultPixels.asPixels());
    }

    public List<PixelsData> getAllPixels() {
        if (this.allPixels == null && this.asImage().sizeOfPixels() >= 0) {
            this.allPixels = new ArrayList<PixelsData>();
            List pixels = this.asImage().copyPixels();
            for (Pixels p : pixels) {
                this.allPixels.add(new PixelsData(p));
            }
        }
        return this.allPixels == null ? null : new ArrayList<PixelsData>(this.allPixels);
    }

    public void setAllPixels(List<PixelsData> newValue) {
        List<PixelsData> currentValue = this.getAllPixels();
        SetMutator<PixelsData> m = new SetMutator<PixelsData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().removePixels(m.nextDeletion().asPixels());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().addPixels(m.nextAddition().asPixels());
        }
        this.allPixels = m.result();
    }

    public Set getDatasets() {
        if (this.datasets == null && this.asImage().sizeOfDatasetLinks() >= 0) {
            this.datasets = new HashSet<DatasetData>();
            List links = this.asImage().copyDatasetLinks();
            for (DatasetImageLink link : links) {
                this.datasets.add(new DatasetData(link.getParent()));
            }
        }
        return this.datasets == null ? null : new HashSet<DatasetData>(this.datasets);
    }

    public void setDatasets(Set newValue) {
        Set currentValue = this.getDatasets();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().unlinkDataset(m.nextDeletion().asDataset());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().linkDataset(m.nextAddition().asDataset());
        }
        this.datasets = new HashSet<DatasetData>(m.result());
    }

    public Set getAnnotations() {
        int size;
        if (this.annotations == null && (size = this.asImage().sizeOfAnnotationLinks()) >= 0) {
            this.annotations = new HashSet<AnnotationData>(size);
            List links = this.asImage().copyAnnotationLinks();
            for (ImageAnnotationLink link : links) {
                Annotation a = link.getChild();
                if (a instanceof CommentAnnotation) {
                    this.annotations.add(new TextualAnnotationData((CommentAnnotation)a));
                    continue;
                }
                if (!(a instanceof LongAnnotation)) continue;
                this.annotations.add(new RatingAnnotationData((LongAnnotation)a));
            }
        }
        return this.annotations == null ? null : new HashSet<AnnotationData>(this.annotations);
    }

    public void setAnnotations(Set newValue) {
        Set currentValue = this.getAnnotations();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asImage().unlinkAnnotation(m.nextDeletion().asAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount - 1L);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asImage().linkAnnotation(m.nextAddition().asAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount + 1L);
        }
        this.annotations = new HashSet<AnnotationData>(m.result());
    }

    public boolean isLifetime() {
        String name = this.getName();
        return name != null && name.endsWith(".sdt");
    }

    public long getInstrumentId() {
        Instrument instrument = this.asImage().getInstrument();
        if (instrument == null) {
            return -1L;
        }
        return instrument.getId().getValue();
    }

    public boolean isFSImage() {
        return this.asImage().getFileset() != null;
    }

    public long getFilesetId() {
        long id = -1L;
        if (this.isFSImage()) {
            id = this.asImage().getFileset().getId().getValue();
        }
        return id;
    }
}

