/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.DichroicData;
import omero.gateway.model.FilterData;
import omero.model.Dichroic;
import omero.model.IObject;
import omero.model.LightPath;
import omero.model.LightPathEmissionFilterLink;
import omero.model.LightPathExcitationFilterLink;

public class LightPathData
extends DataObject {
    private List<FilterData> emissionFilters;
    private List<FilterData> excitationFilters;

    public LightPathData(LightPath lightPath) {
        if (lightPath == null) {
            throw new IllegalArgumentException("lightPath cannot null.");
        }
        this.setValue((IObject)lightPath);
    }

    public List<FilterData> getEmissionFilters() {
        LightPath path = (LightPath)this.asIObject();
        if (this.emissionFilters == null && path.sizeOfEmissionFilterLink() > 0) {
            this.emissionFilters = new ArrayList<FilterData>();
            List l = path.copyEmissionFilterLink();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.emissionFilters.add(new FilterData(((LightPathEmissionFilterLink)i.next()).getChild()));
            }
        }
        return this.emissionFilters;
    }

    public List<FilterData> getExcitationFilters() {
        LightPath path = (LightPath)this.asIObject();
        if (this.excitationFilters == null && path.sizeOfExcitationFilterLink() > 0) {
            this.excitationFilters = new ArrayList<FilterData>();
            List l = path.copyExcitationFilterLink();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.excitationFilters.add(new FilterData(((LightPathExcitationFilterLink)i.next()).getChild()));
            }
        }
        return this.excitationFilters;
    }

    public DichroicData getDichroic() {
        LightPath path = (LightPath)this.asIObject();
        Dichroic d = path.getDichroic();
        if (d == null) {
            return null;
        }
        return new DichroicData(d);
    }
}

