/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.rnd;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.ServerError;
import omero.api.RawPixelsStorePrx;
import omero.api.ResolutionDescription;
import omero.api.StatefulServiceInterfacePrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.DataSourceException;
import omero.gateway.model.PixelsData;
import omero.gateway.rnd.BytesConverter;
import omero.gateway.rnd.Plane2D;
import omero.romio.PlaneDef;
import omero.util.ReadOnlyByteArray;

public class DataSink
implements AutoCloseable {
    public static final String INT_8 = "int8";
    public static final String UINT_8 = "uint8";
    public static final String INT_16 = "int16";
    public static final String UINT_16 = "uint16";
    public static final String INT_32 = "int32";
    public static final String UINT_32 = "uint32";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    private PixelsData source;
    private int bytesPerPixels;
    private BytesConverter strategy;
    private RawPixelsStorePrx store;
    private Gateway gw;
    private SecurityContext ctx;

    public DataSink(SecurityContext ctx, PixelsData source, Gateway gw) throws DSOutOfServiceException {
        this.ctx = ctx;
        this.gw = gw;
        this.source = source;
        this.store = gw.createPixelsStore(ctx);
        try {
            this.store.setPixelsId(source.getId(), false);
        }
        catch (ServerError e) {
            throw new DSOutOfServiceException("Can't set pixels id", e);
        }
        String type = source.getPixelType();
        this.bytesPerPixels = this.getBytesPerPixels(type);
        this.strategy = BytesConverter.getConverter(type);
    }

    private int getBytesPerPixels(String v) {
        if (INT_8.equals(v) || UINT_8.equals(v)) {
            return 1;
        }
        if (INT_16.equals(v) || UINT_16.equals(v)) {
            return 2;
        }
        if (INT_32.equals(v) || UINT_32.equals(v) || FLOAT.equals(v)) {
            return 4;
        }
        if (DOUBLE.equals(v)) {
            return 8;
        }
        return -1;
    }

    private Plane2D createPlane(int z, int t, int c, BytesConverter strategy) throws DataSourceException {
        Plane2D plane = null;
        byte[] data = null;
        try {
            data = this.store.getPlane(z, c, t);
        }
        catch (Exception e) {
            String p = "(" + z + ", " + c + ", " + t + ")";
            throw new DataSourceException("Cannot retrieve the plane " + p, e);
        }
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        plane = new Plane2D(array, this.source.getSizeX(), this.source.getSizeY(), this.bytesPerPixels, strategy);
        return plane;
    }

    public Plane2D getTile(int z, int t, int c, int x, int y, int w, int h) throws DataSourceException {
        byte[] data = null;
        try {
            data = this.store.getTile(z, c, t, x, y, w, h);
        }
        catch (Exception e) {
            String p = "(" + z + ", " + c + ", " + t + ", " + x + ", " + y + ", " + w + ", " + h + ")";
            throw new DataSourceException("Cannot retrieve the plane " + p, e);
        }
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        return new Plane2D(array, w, h, this.bytesPerPixels, this.strategy);
    }

    public Plane2D getPlane(int z, int t, int c) throws DataSourceException {
        return this.createPlane(z, t, c, this.strategy);
    }

    public Map<Integer, int[]> getHistogram(int[] channels, int binCount, boolean globalRange, PlaneDef plane) throws DataSourceException {
        try {
            if (plane == null) {
                plane = new PlaneDef(0, 0, 0, 0, 0, null, -1);
            }
            return this.store.getHistogram(channels, binCount, globalRange, plane);
        }
        catch (Exception e) {
            throw new DataSourceException("Couldn't get histogram data", e);
        }
    }

    public List<ResolutionDescription> getResolutionDescriptions() throws DataSourceException {
        try {
            return Arrays.asList(this.store.getResolutionDescriptions());
        }
        catch (Exception e) {
            throw new DataSourceException("Couldn't get resolution descriptions", e);
        }
    }

    public int setResolutionLevel(int level) throws DataSourceException {
        try {
            int resLevel = this.store.getResolutionLevel();
            this.store.setResolutionLevel(level);
            return resLevel;
        }
        catch (ServerError e) {
            throw new DataSourceException("Couldn't set resolution level data", e);
        }
    }

    public boolean isSame(long pixelsID) {
        return pixelsID == this.source.getId();
    }

    @Override
    public void close() {
        this.gw.closeService(this.ctx, (StatefulServiceInterfacePrx)this.store);
    }
}

