/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

final class Lanczos3Filter
implements ResampleFilter {
    private static final float PI_FLOAT = (float)Math.PI;

    Lanczos3Filter() {
    }

    private float sincModified(float value) {
        return (float)Math.sin(value) / value;
    }

    public final float apply(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            return this.sincModified(value *= (float)Math.PI) * this.sincModified(value / 3.0f);
        }
        return 0.0f;
    }

    public float getSamplingRadius() {
        return 3.0f;
    }

    public String getName() {
        return "Lanczos3";
    }
}

