/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.exclusions;

import java.util.List;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.exclusions.AbstractFileExclusion;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.ServiceFactoryPrx;
import omero.model.ChecksumAlgorithm;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameExclusion
extends AbstractFileExclusion {
    private static final Logger log = LoggerFactory.getLogger(FilenameExclusion.class);

    @Override
    public Boolean suggestExclusion(ServiceFactoryPrx factory, ImportContainer container) throws ServerError {
        IQueryPrx query = factory.getQueryService();
        String fullpath = container.getFile().getAbsolutePath();
        String filename = container.getFile().getName();
        List<IObject> files = query.findAllByQuery("select o from OriginalFile o join fetch o.hasher where o.name = :name", new ParametersI().add("name", rtypes.rstring(filename)));
        for (IObject obj : files) {
            String chksm;
            OriginalFile ofile = (OriginalFile)obj;
            log.debug("Found original file: {}", (Object)ofile.getId().getValue());
            ChecksumAlgorithm algo = ofile.getHasher();
            String string = chksm = ofile.getHash() == null ? null : ofile.getHash().getValue();
            if (algo == null) {
                log.debug("No hasher: no vote");
                return null;
            }
            if (chksm == null) {
                log.debug("No hash: no vote");
                return null;
            }
            String checksum = this.checksum(fullpath, algo);
            if (checksum == null) {
                log.debug("Null checksum: no vote");
                continue;
            }
            if (!checksum.equals(chksm)) continue;
            log.info("Checksum match for filename: {}", (Object)filename);
            return true;
        }
        return false;
    }
}

