/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.formats.MissingLibraryException;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorContainer;
import ome.formats.importer.util.FileUploader;
import ome.formats.importer.util.HtmlMessenger;
import ome.formats.importer.util.HtmlMessengerException;
import omero.api.IQueryPrx;
import omero.api.RawFileStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.client;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorHandler
implements IObserver,
IObservable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final List<IObserver> observers = new ArrayList<IObserver>();
    protected final List<ErrorContainer> errors = new ArrayList<ErrorContainer>();
    protected final ImportConfig config;
    protected boolean cancelUploads = false;
    protected boolean sendFiles = true;
    protected boolean sendLogs = true;
    public boolean fileUploadErrors = false;
    protected int totalErrors = 0;
    private HtmlMessenger messenger;
    private FileUploader fileUploader;
    private String serverReply;
    private Map<String, Long> logFiles;
    protected Map<String, ImportContainer> icMap;

    public ErrorHandler(ImportConfig config) {
        this.config = config;
        this.logFiles = new HashMap<String, Long>();
        this.icMap = new HashMap<String, ImportContainer>();
    }

    @Override
    public final void update(IObservable observable, ImportEvent event) {
        if (event instanceof MISSING_LIBRARY) {
            MISSING_LIBRARY ev = (MISSING_LIBRARY)event;
            this.log.warn(ev.toLog(), (Throwable)ev.exception);
        } else if (event instanceof FILE_EXCEPTION) {
            FILE_EXCEPTION ev = (FILE_EXCEPTION)event;
            this.log.error(ev.toLog(), (Throwable)ev.exception);
            this.addError(ev.exception, new File(ev.filename), ev.usedFiles, ev.reader);
        } else if (event instanceof INTERNAL_EXCEPTION) {
            INTERNAL_EXCEPTION ev = (INTERNAL_EXCEPTION)event;
            this.log.error(event.toLog(), (Throwable)ev.exception);
            this.addError(ev.exception, new File(ev.filename), ev.usedFiles, ev.reader);
        } else if (event instanceof UNKNOWN_FORMAT) {
            UNKNOWN_FORMAT ev = (UNKNOWN_FORMAT)event;
            String[] usedFiles = new String[]{ev.filename};
            if (!(ev.source instanceof ImportCandidates)) {
                this.addError(ev.exception, new File(ev.filename), usedFiles, "");
            }
            this.log.debug(event.toLog());
        } else if (event instanceof EXCEPTION_EVENT) {
            EXCEPTION_EVENT ev = (EXCEPTION_EVENT)event;
            this.log.error(ev.toLog(), (Throwable)ev.exception);
        } else if (event instanceof ImportEvent.METADATA_IMPORTED) {
            ImportEvent.METADATA_IMPORTED e = (ImportEvent.METADATA_IMPORTED)event;
            this.logFiles.put(e.container.getFile().getAbsolutePath(), e.logFileId);
        } else if (event instanceof ImportEvent.POST_UPLOAD_EVENT) {
            ImportEvent.POST_UPLOAD_EVENT e = (ImportEvent.POST_UPLOAD_EVENT)event;
            this.icMap.put(e.container.getFile().getAbsolutePath(), e.container);
        }
        this.onUpdate(observable, event);
    }

    public int errorCount() {
        return this.errors.size();
    }

    protected abstract void onUpdate(IObservable var1, ImportEvent var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File retrieveLogFile(Long id, ServiceFactoryPrx session) throws Throwable {
        if (id == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("importLog_");
        buf.append(id);
        File logfile = File.createTempFile(buf.toString(), ".log");
        logfile.deleteOnExit();
        IQueryPrx svc = session.getQueryService();
        ParametersI param = new ParametersI();
        param.map.put("id", rtypes.rlong(id));
        OriginalFile of = (OriginalFile)svc.findByQuery("select p from OriginalFile as p where p.id = :id", param);
        if (of == null) {
            return null;
        }
        String path = logfile.getAbsolutePath();
        RawFileStorePrx store = null;
        try {
            store = session.createRawFileStore();
            store.setFileId(id);
        }
        catch (Throwable e) {
            store.close();
            return null;
        }
        try {
            long size = -1L;
            long offset = 0L;
            int INC = 262144;
            FileOutputStream stream = new FileOutputStream(logfile);
            try {
                try {
                    size = store.size();
                    offset = 0L;
                    while (offset + (long)INC < size) {
                        stream.write(store.read(offset, INC));
                        offset += (long)INC;
                    }
                }
                finally {
                    stream.write(store.read(offset, (int)(size - offset)));
                    stream.close();
                }
            }
            catch (Exception e) {
                this.log.error("Cannot write log file", (Throwable)e);
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            this.log.error("Cannot write log file", (Throwable)e);
        }
        finally {
            store.close();
        }
        return logfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendErrors() {
        client sc = null;
        client client2 = null;
        ServiceFactoryPrx session = null;
        try {
            if (this.sendLogs || this.sendFiles) {
                sc = new client((String)this.config.hostname.get(), (Integer)this.config.port.get());
                ServiceFactoryPrx entryEncrypted = !this.config.sessionKey.empty() ? sc.joinSession((String)this.config.sessionKey.get()) : sc.createSession((String)this.config.username.get(), (String)this.config.password.get());
                client2 = sc.createClient(false);
                session = client2.getSession();
            }
            for (int i = 0; i < this.errors.size(); ++i) {
                if (!this.isSend(i)) {
                    this.onSent(i);
                    continue;
                }
                if (this.cancelUploads) {
                    this.onCancel();
                    break;
                }
                ErrorContainer errorContainer = this.errors.get(i);
                if (errorContainer.getStatus() != -1) continue;
                HashMap<String, String> postList = new HashMap<String, String>();
                postList.put("java_version", errorContainer.getJavaVersion());
                postList.put("java_classpath", errorContainer.getJavaClasspath());
                postList.put("app_version", errorContainer.getAppVersion());
                postList.put("comment_type", errorContainer.getCommentType());
                postList.put("os_name", errorContainer.getOSName());
                postList.put("os_arch", errorContainer.getOSArch());
                postList.put("os_version", errorContainer.getOSVersion());
                postList.put("extra", errorContainer.getExtra());
                postList.put("error", ErrorHandler.getStackTrace(errorContainer.getError()));
                postList.put("comment", errorContainer.getComment());
                postList.put("email", errorContainer.getEmail());
                postList.put("app_name", "2");
                postList.put("import_session", "test");
                postList.put("absolute_path", errorContainer.getAbsolutePath() + "/");
                String sendUrl = this.config.getTokenUrl();
                if (this.isSend(i)) {
                    if (!this.sendFiles) {
                        errorContainer.clearFiles();
                    }
                    if (this.sendLogs || this.sendFiles) {
                        File f = errorContainer.getSelectedFile();
                        if (f != null) {
                            Long id = this.logFiles.get(f.getAbsolutePath());
                            File logFile = null;
                            try {
                                logFile = this.retrieveLogFile(id, session);
                            }
                            catch (Throwable e) {
                                this.log.error("Cannot load log file", e);
                            }
                            if (logFile != null) {
                                this.sendLogs = true;
                                errorContainer.addFile(logFile.getAbsolutePath());
                            } else {
                                this.sendLogs = false;
                            }
                        } else {
                            this.sendLogs = false;
                        }
                    }
                }
                this.messenger = new HtmlMessenger(sendUrl, postList);
                this.serverReply = this.messenger.executePost();
                if (this.sendFiles || this.sendLogs) {
                    this.onSending(i);
                    this.log.info("Sending File(s)...");
                    errorContainer.setToken(this.serverReply);
                    this.fileUploader = new FileUploader(this.messenger.getCommunicationLink(this.config.getUploaderUrl()));
                    this.fileUploader.addObserver(this);
                    this.fileUploader.uploadFiles(this.config.getUploaderUrl(), 2000, errorContainer);
                    this.onSent(i);
                    continue;
                }
                this.onNotSending(i, this.serverReply);
            }
        }
        catch (Exception e) {
            this.log.error("Error during upload", (Throwable)e);
        }
        finally {
            if (client2 != null) {
                client2.__del__();
            }
            if (sc != null) {
                sc.__del__();
            }
        }
        if (this.cancelUploads) {
            this.finishCancelled();
        }
        if (this.fileUploadErrors) {
            this.finishWithErroredFiles();
            this.notifyObservers(new ImportEvent.ERRORS_COMPLETE());
        } else {
            this.finishComplete();
            this.notifyObservers(new ImportEvent.ERRORS_COMPLETE());
        }
    }

    protected void addError(Throwable error, File file, String[] files, String readerType) {
        ErrorContainer errorContainer = new ErrorContainer();
        errorContainer.setFiles(files);
        errorContainer.setSelectedFile(file);
        errorContainer.setReaderType(readerType);
        errorContainer.setCommentType("2");
        errorContainer.setJavaVersion(System.getProperty("java.version"));
        errorContainer.setJavaClasspath(System.getProperty("java.class.path"));
        errorContainer.setOSName(System.getProperty("os.name"));
        errorContainer.setOSArch(System.getProperty("os.arch"));
        errorContainer.setOSVersion(System.getProperty("os.version"));
        errorContainer.setAppVersion(this.config.getVersionNumber());
        errorContainer.setError(error);
        this.addError(errorContainer);
    }

    private void addError(ErrorContainer errorContainer) {
        String errorMessage = errorContainer.getError().toString();
        String[] splitMessage = errorMessage.split("\n");
        errorMessage = errorMessage.replaceAll("\n", "<br>&nbsp;&nbsp;");
        errorContainer.setIndex(this.totalErrors);
        ++this.totalErrors;
        errorContainer.setStatus(-1);
        this.errors.add(errorContainer);
        this.onAddError(errorContainer, splitMessage[0]);
        this.notifyObservers(new ImportEvent.ERRORS_PENDING());
    }

    protected void clearErrors(int index) {
        this.errors.remove(index);
    }

    @Override
    public final boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public final boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public final void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }

    protected void onCancel() {
    }

    protected void onAddError(ErrorContainer errorContainer, String message) {
    }

    protected boolean isSend(int index) {
        return this.errors.get(index).getSelectedFile() != null;
    }

    protected void onSending(int index) {
    }

    protected void onSent(int index) {
    }

    protected void onNotSending(int index, String serverReply) {
    }

    protected void onException(Exception exception) {
        this.notifyObservers(new ImportEvent.ERRORS_FAILED());
    }

    protected void finishCancelled() {
    }

    protected void finishComplete() {
    }

    protected void finishWithErroredFiles() {
    }

    public void executePost(String sendUrl, Map<String, String> postList) throws HtmlMessengerException {
        this.messenger = new HtmlMessenger(sendUrl, postList);
        this.serverReply = this.messenger.executePost();
    }

    public void uploadFile(ErrorContainer errorContainer) {
        errorContainer.setToken(this.serverReply);
        try {
            this.fileUploader = new FileUploader(this.messenger.getCommunicationLink(this.config.getUploaderUrl()));
            this.fileUploader.addObserver(this);
            this.fileUploader.uploadFiles(this.config.getUploaderUrl(), 2000, errorContainer);
        }
        catch (Exception e) {
            this.log.error("Error during upload", (Throwable)e);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public static class MISSING_LIBRARY
    extends FILE_EXCEPTION {
        public MISSING_LIBRARY(String filename, MissingLibraryException exception, String[] usedFiles, String reader) {
            super(filename, (Exception)exception, usedFiles, reader);
        }
    }

    public static class FILE_EXCEPTION
    extends EXCEPTION_EVENT {
        public final String filename;
        public final String[] usedFiles;
        public final String reader;

        public FILE_EXCEPTION(String filename, Exception exception, String[] usedFiles, String reader) {
            super(exception);
            this.filename = filename;
            this.usedFiles = usedFiles;
            this.reader = reader;
        }

        @Override
        public String toLog() {
            return super.toLog() + ": " + this.filename;
        }
    }

    public static class UNREADABLE_FILE
    extends EXCEPTION_EVENT {
        public final String filename;
        public final Object source;

        public UNREADABLE_FILE(String filename, Exception exception, Object source) {
            super(exception);
            this.filename = filename;
            this.source = source;
        }

        @Override
        public String toLog() {
            return super.toLog() + ": " + this.filename;
        }
    }

    public static class UNKNOWN_FORMAT
    extends EXCEPTION_EVENT {
        public final String filename;
        public final Object source;

        public UNKNOWN_FORMAT(String filename, Exception exception, Object source) {
            super(exception);
            this.filename = filename;
            this.source = source;
        }

        @Override
        public String toLog() {
            return super.toLog() + ": " + this.filename;
        }
    }

    public static class INTERNAL_EXCEPTION
    extends EXCEPTION_EVENT {
        public final String filename;
        public final String[] usedFiles;
        public final String reader;

        public INTERNAL_EXCEPTION(String filename, Exception exception, String[] usedFiles, String reader) {
            super(exception);
            this.filename = filename;
            this.usedFiles = usedFiles;
            this.reader = reader;
        }

        @Override
        public String toLog() {
            return String.format("%s: %s\n%s", super.toLog(), this.filename, ErrorHandler.getStackTrace(this.exception));
        }
    }

    public static abstract class EXCEPTION_EVENT
    extends ImportEvent {
        public final Exception exception;

        public EXCEPTION_EVENT(Exception exception) {
            this.exception = exception;
        }
    }
}

