/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2._PermissionsVerifierDisp;
import Ice.Current;
import Ice.StringHolder;
import java.util.ArrayList;
import ome.api.IQuery;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionException;
import ome.model.meta.Experimenter;
import ome.model.meta.Session;
import ome.services.blitz.fire.Ring;
import ome.services.sessions.SessionManager;
import ome.services.sessions.SessionProvider;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class PermissionsVerifierI
extends _PermissionsVerifierDisp {
    private static final Logger log = LoggerFactory.getLogger(PermissionsVerifierI.class);
    private final Ring ring;
    private final SessionManager manager;
    private final SessionProvider sessionProvider;
    private final Executor ex;
    private final Principal p;

    public PermissionsVerifierI(Ring ring, SessionManager manager, SessionProvider sessionProvider, Executor ex, String uuid) {
        this.ring = ring;
        this.manager = manager;
        this.sessionProvider = sessionProvider;
        this.ex = ex;
        this.p = new Principal(uuid);
    }

    public boolean checkPermissions(final String userId, String password, StringHolder reason, Current __current) {
        try {
            Object session = null;
            try {
                session = this.manager.find(password);
            }
            catch (SessionException sessionException) {
                // empty catch block
            }
            if (session == null) {
                try {
                    session = this.manager.find(userId);
                }
                catch (SessionException sessionException) {
                    // empty catch block
                }
            }
            if (session == null && this.ring.checkPassword(userId)) {
                session = "ring.checkPassword(userId)";
            }
            if (session != null) {
                if (userId.equals(password)) {
                    return true;
                }
                log.warn("username and password don't match: " + userId);
                reason.value = "username and password must be equal; use joinSession";
                return false;
            }
            if (this.manager.executePasswordCheck(userId, password)) {
                return true;
            }
            final ArrayList data = new ArrayList();
            this.ex.execute(this.p, (Executor.Work)new Executor.SimpleWork<Void>((Object)"failedPassword", userId, new Object[0]){

                @Transactional(readOnly=true)
                public Void doWork(org.hibernate.Session session, ServiceFactory sf) {
                    Long sessionId = PermissionsVerifierI.this.sessionProvider.findSessionIdByUuid(userId, sf);
                    Session s = sessionId == null ? null : PermissionsVerifierI.this.sessionProvider.findSessionById(sessionId.longValue(), sf);
                    IQuery q = sf.getQueryService();
                    Experimenter e = null;
                    if (s != null) {
                        e = s.getOwner();
                        if (!e.isLoaded()) {
                            e = (Experimenter)q.get(Experimenter.class, e.getId().longValue());
                        }
                        data.add(String.format("user=%s", e.getOmeName()));
                    } else {
                        e = (Experimenter)q.findByString(Experimenter.class, "omeName", userId);
                        if (e != null) {
                            data.add(String.format("id=%s", e.getId()));
                        }
                    }
                    if (s != null) {
                        data.add(String.format("created=%s", s.getStarted()));
                        data.add(String.format("closed=%s", s.getClosed()));
                    }
                    return null;
                }
            });
            reason.value = String.format("Password check failed for '%s': %s", userId, data);
            return false;
        }
        catch (SecurityViolation sv) {
            reason.value = sv.getMessage();
            return false;
        }
        catch (Throwable t) {
            reason.value = "Internal error. Please contact your administrator:\n" + t.getMessage();
            log.error("Exception thrown while checking password for:" + userId, t);
            return false;
        }
    }
}

