/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ome.api.IQuery;
import ome.api.IUpdate;
import ome.api.JobHandle;
import ome.api.RawFileStore;
import ome.api.local.LocalAdmin;
import ome.conditions.InternalException;
import ome.conditions.ResourceError;
import ome.io.nio.FileBuffer;
import ome.model.fs.Fileset;
import ome.model.fs.FilesetJobLink;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.parameters.Parameters;
import ome.security.basic.OmeroInterceptor;
import ome.services.RawFileBean;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.blitz.repo.RepositoryDao;
import ome.services.blitz.repo.path.FsFile;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import omero.RMap;
import omero.RType;
import omero.SecurityViolation;
import omero.ServerError;
import omero.ValidationException;
import omero.model.ChecksumAlgorithm;
import omero.model.IObject;
import omero.model.Job;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.transaction.annotation.Transactional;

public class RepositoryDaoImpl
implements RepositoryDao {
    private static final String LOAD_ORIGINAL_FILE = "select f from OriginalFile as f left outer join fetch f.hasher where ";
    private static final String LOAD_USER_INSTITUTION = "SELECT institution FROM " + Experimenter.class.getName() + " WHERE id = :id";
    private static final int BATCH_SIZE = 1024;
    private static final Logger log = LoggerFactory.getLogger(RepositoryDaoImpl.class);
    private final IceMapper mapper = new IceMapper();
    protected final Principal principal;
    protected final Roles roles;
    protected final Executor executor;
    protected final Executor statefulExecutor;
    protected final OmeroInterceptor interceptor;
    protected final String fileRepoSecretKey;

    public RepositoryDaoImpl(Principal principal, Roles roles, Executor executor, Executor statefulExecutor, OmeroInterceptor interceptor, String fileRepoSecretKey) {
        this.principal = principal;
        this.roles = roles;
        this.executor = executor;
        this.statefulExecutor = statefulExecutor;
        this.interceptor = interceptor;
        this.fileRepoSecretKey = fileRepoSecretKey;
    }

    public RepositoryDaoImpl(Principal principal, Executor executor) {
        this(principal, new Roles(), executor, (Executor)executor.getContext().getBean("statefulExecutor", Executor.class), (OmeroInterceptor)executor.getContext().getBean("omeroInterceptor", OmeroInterceptor.class), UUID.randomUUID().toString());
    }

    protected RawFileBean unwrapRawFileBean(RawFileStore proxy) {
        try {
            return (RawFileBean)((Advised)proxy).getTargetSource().getTarget();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SecurityViolation wrapSecurityViolation(ome.conditions.SecurityViolation sv) throws SecurityViolation {
        SecurityViolation copy = new SecurityViolation();
        IceMapper.fillServerError(copy, sv);
        throw copy;
    }

    @Override
    public RawFileStore getRawFileStore(final long fileId, CheckedPath checked, String mode, Current current) throws SecurityViolation {
        RawFileStore proxy = (RawFileStore)this.executor.getContext().getBean("managed-ome.api.RawFileStore", RawFileStore.class);
        final RawFileBean bean = this.unwrapRawFileBean(proxy);
        final FileBuffer buffer = checked.getFileBuffer(mode);
        try {
            Map<String, String> fileContext = this.fileContext(fileId, current);
            this.statefulExecutor.execute(fileContext, this.currentUser(current), (Executor.Work)new StatefulWork<Void>(bean, (Object)this, "setFileIdWithBuffer", new Object[]{fileId, checked, mode}){

                @Transactional(readOnly=true)
                public Void doWork(Session session, ServiceFactory sf) {
                    bean.setFileIdWithBuffer(fileId, buffer);
                    return null;
                }
            });
        }
        catch (ome.conditions.SecurityViolation sv) {
            throw this.wrapSecurityViolation(sv);
        }
        return proxy;
    }

    @Override
    public OriginalFile findRepoFile(final String uuid, final CheckedPath checked, final String mimetype, Current current) throws ServerError {
        try {
            ome.model.core.OriginalFile ofile = (ome.model.core.OriginalFile)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<ome.model.core.OriginalFile>((Object)this, "findRepoFile", new Object[]{uuid, checked, mimetype}){

                @Transactional(readOnly=true)
                public ome.model.core.OriginalFile doWork(Session session, ServiceFactory sf) {
                    return RepositoryDaoImpl.this.findRepoFile(sf, this.getSqlAction(), uuid, checked, mimetype);
                }
            });
            return (OriginalFile)new IceMapper().map((Filterable)ofile);
        }
        catch (ome.conditions.SecurityViolation sv) {
            throw this.wrapSecurityViolation(sv);
        }
    }

    @Override
    public ome.model.core.OriginalFile findRepoFile(ServiceFactory sf, SqlAction sql, String uuid, CheckedPath checked, String mimetype) {
        Long id = sql.findRepoFile(uuid, checked.getRelativePath(), checked.getName(), mimetype);
        if (id == null) {
            return null;
        }
        return (ome.model.core.OriginalFile)sf.getQueryService().get(ome.model.core.OriginalFile.class, id.longValue());
    }

    @Override
    public RMap treeList(final String repoUuid, final CheckedPath checked, Current current) throws ServerError {
        final RMap map = rtypes.rmap();
        this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Void>((Object)this, "treeList", new Object[]{repoUuid, checked}){

            @Transactional(readOnly=true)
            public Void doWork(Session session, ServiceFactory sf) {
                RepositoryDaoImpl.this._treeList(map, repoUuid, checked, sf, this.getSqlAction());
                return null;
            }
        });
        return map;
    }

    private void _treeList(RMap rv, String repoUuid, CheckedPath checked, ServiceFactory sf, SqlAction sql) {
        ome.model.core.OriginalFile file = this.findRepoFile(sf, sql, repoUuid, checked, null);
        if (file == null) {
            if (rv.getValue().size() == 0) {
                log.debug("No file found in _treeList: " + checked);
            } else {
                log.warn("No file found in _treeList: " + checked);
            }
            return;
        }
        String name = file.getName();
        String mime = file.getMimetype();
        Long size = file.getSize();
        Long id = file.getId();
        RMap subRv = rtypes.rmap();
        Map<String, RType> subVal = subRv.getValue();
        rv.put(name, subRv);
        subVal.put("id", rtypes.rlong(id));
        subVal.put("mimetype", rtypes.rstring(mime));
        if (size != null) {
            subVal.put("size", rtypes.rlong(size));
        }
        if (file.getMimetype() != null && "Directory".equals(file.getMimetype())) {
            List<ome.model.core.OriginalFile> subFiles = this.getOriginalFiles(sf, sql, repoUuid, checked);
            RMap subFilesRv = rtypes.rmap();
            for (ome.model.core.OriginalFile subFile : subFiles) {
                CheckedPath child = null;
                try {
                    child = checked.child(subFile.getName());
                    if (child == null) {
                        throw new ValidationException(null, null, "null child!");
                    }
                }
                catch (ValidationException ve) {
                    log.warn(String.format("Validation exception on %s.child(%s)", checked, subFile.getName()), (Throwable)((Object)ve));
                    throw new ome.conditions.ValidationException(ve.getMessage());
                }
                this._treeList(subFilesRv, repoUuid, child, sf, sql);
            }
            subVal.put("files", subFilesRv);
        }
    }

    @Override
    public void createOrFixUserDir(String repoUuid, List<CheckedPath> checkedPaths, Session s, ServiceFactory sf, SqlAction sql) throws ServerError {
        Slf4JStopWatch outer = new Slf4JStopWatch();
        try {
            for (CheckedPath checked : checkedPaths) {
                CheckedPath parent;
                try {
                    parent = checked.parent();
                }
                catch (ValidationException ve) {
                    throw new RuntimeException((Throwable)((Object)ve));
                }
                Slf4JStopWatch sw = new Slf4JStopWatch();
                Long id = sql.findRepoFile(repoUuid, checked.getRelativePath(), checked.getName());
                sw.stop("omero.repo.file.find");
                ome.model.core.OriginalFile f = null;
                if (id == null) {
                    sw = new Slf4JStopWatch();
                    f = this._internalRegister(repoUuid, Arrays.asList(checked), Arrays.asList(parent), null, "Directory", sf, sql, s).get(0);
                    sw.stop("omero.repo.file.register");
                } else {
                    try {
                        sw = new Slf4JStopWatch();
                        f = (ome.model.core.OriginalFile)sf.getQueryService().get(ome.model.core.OriginalFile.class, id.longValue());
                        if (f != null) {
                            long groupId = f.getDetails().getGroup().getId();
                            if (this.roles.getUserGroupId() == groupId) {
                                f = null;
                            }
                        }
                        sw.stop("omero.repo.file.check_group");
                    }
                    catch (ome.conditions.SecurityViolation e) {
                        f = new ome.model.core.OriginalFile(id, false);
                    }
                }
                if (f == null) continue;
                sw = new Slf4JStopWatch();
                ((LocalAdmin)sf.getAdminService()).internalMoveToCommonSpace((ome.model.IObject)f);
                sw.stop("omero.repo.file.move_to_common");
            }
        }
        catch (ome.conditions.SecurityViolation sv) {
            throw this.wrapSecurityViolation(sv);
        }
        finally {
            outer.stop("omero.repo.user_dir");
        }
    }

    @Override
    public boolean canUpdate(final IObject obj, Current current) {
        return (Boolean)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Boolean>((Object)this, "canUpdate", new Object[0]){

            @Transactional(readOnly=true)
            public Boolean doWork(Session session, ServiceFactory sf) {
                try {
                    ome.model.IObject iobj = (ome.model.IObject)new IceMapper().reverse(obj);
                    return sf.getAdminService().canUpdate(iobj);
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    public List<Long> filterFilesByRepository(final String repo, List<Long> ids, Current current) {
        ArrayList<Long> inRepo = new ArrayList<Long>();
        for (final List idsBatch : Iterables.partition(ids, (int)1024)) {
            inRepo.addAll((Collection)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Collection<Long>>((Object)this, "filterFilesByRepository", new Object[0]){

                @Transactional(readOnly=true)
                public List<Long> doWork(Session session, ServiceFactory sf) {
                    return this.getSqlAction().filterFileIdsByRepo(repo, idsBatch);
                }
            }));
        }
        return inRepo;
    }

    @Override
    public OriginalFile getOriginalFile(final long repoId, Current current) throws SecurityViolation {
        try {
            ome.model.core.OriginalFile oFile = (ome.model.core.OriginalFile)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<ome.model.core.OriginalFile>((Object)this, "getOriginalFile", new Object[]{repoId}){

                @Transactional(readOnly=true)
                public ome.model.core.OriginalFile doWork(Session session, ServiceFactory sf) {
                    return (ome.model.core.OriginalFile)sf.getQueryService().findByQuery("select f from OriginalFile as f left outer join fetch f.hasher where  f.id = :id", new Parameters().addId(Long.valueOf(repoId)));
                }
            });
            return (OriginalFileI)new IceMapper().map((Filterable)oFile);
        }
        catch (ome.conditions.SecurityViolation sv) {
            throw this.wrapSecurityViolation(sv);
        }
    }

    @Override
    public List<OriginalFile> getOriginalFiles(final String repoUuid, final CheckedPath checked, Current current) throws SecurityViolation {
        try {
            List oFiles = (List)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork(this, "getOriginalFiles", new Object[]{repoUuid, checked}){

                @Transactional(readOnly=true)
                public List<ome.model.core.OriginalFile> doWork(Session session, ServiceFactory sf) {
                    return RepositoryDaoImpl.this.getOriginalFiles(sf, this.getSqlAction(), repoUuid, checked);
                }
            });
            return (List)new IceMapper().map(oFiles);
        }
        catch (ome.conditions.SecurityViolation sv) {
            throw this.wrapSecurityViolation(sv);
        }
    }

    protected List<ome.model.core.OriginalFile> getOriginalFiles(ServiceFactory sf, SqlAction sql, String repoUuid, CheckedPath checked) {
        Long id;
        IQuery q = sf.getQueryService();
        if (checked.isRoot) {
            id = ((ome.model.core.OriginalFile)q.findByString(ome.model.core.OriginalFile.class, "hash", repoUuid)).getId();
            if (id == null) {
                throw new ome.conditions.SecurityViolation("No repository with UUID: " + repoUuid);
            }
        } else {
            id = sql.findRepoFile(repoUuid, checked.getRelativePath(), checked.getName());
            if (id == null) {
                throw new ome.conditions.SecurityViolation("No such parent dir: " + checked);
            }
        }
        q.get(ome.model.core.OriginalFile.class, id.longValue());
        List ids = sql.findRepoFiles(repoUuid, checked.getDirname());
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.emptyList();
        }
        ArrayList<ome.model.core.OriginalFile> files = new ArrayList<ome.model.core.OriginalFile>(ids.size());
        String filesById = "select f from OriginalFile as f left outer join fetch f.hasher where f.id in (:ids)";
        for (List idsBatch : Iterables.partition((Iterable)ids, (int)1024)) {
            Parameters params = new Parameters().addIds((Collection)idsBatch);
            for (ome.model.IObject file : q.findAllByQuery("select f from OriginalFile as f left outer join fetch f.hasher where f.id in (:ids)", params)) {
                files.add((ome.model.core.OriginalFile)file);
            }
        }
        return files;
    }

    @Override
    public omero.model.Fileset saveFileset(final String repoUuid, omero.model.Fileset _fs, final ChecksumAlgorithm checksumAlgorithm, final List<CheckedPath> paths, Current current) throws ServerError {
        IceMapper mapper = new IceMapper();
        final ArrayList<CheckedPath> parents = new ArrayList<CheckedPath>();
        for (CheckedPath path : paths) {
            parents.add(path.parent());
        }
        final Fileset fs = (Fileset)mapper.reverse(_fs);
        Slf4JStopWatch outer = new Slf4JStopWatch();
        try {
            omero.model.Fileset fileset = (omero.model.Fileset)mapper.map((Filterable)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Fileset>((Object)this, "saveFileset", new Object[]{repoUuid, fs, paths}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Transactional(readOnly=false)
                public Fileset doWork(Session session, ServiceFactory sf) {
                    for (int i = 0; i < fs.sizeOfJobLinks(); ++i) {
                        FilesetJobLink link = fs.getFilesetJobLink(i);
                        try (JobHandle jh = sf.createJobHandle();){
                            jh.submit(link.child());
                            link.setChild((ome.model.IObject)jh.getJob());
                            continue;
                        }
                    }
                    Slf4JStopWatch sw = new Slf4JStopWatch();
                    int size = paths.size();
                    List ofs = RepositoryDaoImpl.this._internalRegister(repoUuid, paths, parents, checksumAlgorithm, null, sf, this.getSqlAction(), session);
                    sw.stop("omero.repo.save_fileset.register");
                    sw = new Slf4JStopWatch();
                    for (int i = 0; i < size; ++i) {
                        CheckedPath checked = (CheckedPath)paths.get(i);
                        ome.model.core.OriginalFile of = (ome.model.core.OriginalFile)ofs.get(i);
                        fs.getFilesetEntry(i).setOriginalFile(of);
                    }
                    sw.stop("omero.repo.save_fileset.update_fileset_entries");
                    sw = new Slf4JStopWatch();
                    try {
                        Fileset fileset = (Fileset)sf.getUpdateService().saveAndReturnObject((ome.model.IObject)fs);
                        return fileset;
                    }
                    finally {
                        sw.stop("omero.repo.save_fileset.save");
                    }
                }
            }));
            return fileset;
        }
        catch (Exception e) {
            throw (ServerError)mapper.handleException(e, this.executor.getContext());
        }
        finally {
            outer.stop("omero.repo.save_fileset");
        }
    }

    @Override
    public List<omero.model.Fileset> loadFilesets(final List<Long> ids, Current current) throws ServerError {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<omero.model.Fileset>();
        }
        IceMapper mapper = new IceMapper();
        try {
            return (List)mapper.map((List)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork(this, "loadFilesets", new Object[]{ids}){

                @Transactional(readOnly=true)
                public Object doWork(Session session, ServiceFactory sf) {
                    return sf.getQueryService().findAllByQuery("select fs from Fileset fs where fs.id in (:ids)", new Parameters().addIds((Collection)ids));
                }
            }));
        }
        catch (Exception e) {
            throw (ServerError)mapper.handleException(e, this.executor.getContext());
        }
    }

    @Override
    public OriginalFile register(final String repoUuid, final CheckedPath checked, final String mimetype, Current current) throws ServerError {
        if (checked.isRoot) {
            throw new SecurityViolation(null, null, "Can't re-register the repository");
        }
        final CheckedPath parent = checked.parent();
        IceMapper mapper = new IceMapper();
        try {
            ome.model.core.OriginalFile of = (ome.model.core.OriginalFile)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<ome.model.core.OriginalFile>((Object)this, "register", new Object[]{repoUuid, checked, mimetype}){

                @Transactional(readOnly=false)
                public ome.model.core.OriginalFile doWork(Session session, ServiceFactory sf) {
                    return (ome.model.core.OriginalFile)RepositoryDaoImpl.this._internalRegister(repoUuid, Arrays.asList(checked), Arrays.asList(parent), null, mimetype, sf, this.getSqlAction(), session).get(0);
                }
            });
            OriginalFile rv = (OriginalFile)mapper.map((Filterable)of);
            String name = rv.getName().getValue();
            if (name.startsWith(this.fileRepoSecretKey)) {
                rv.setName(rtypes.rstring(name.substring(this.fileRepoSecretKey.length())));
            }
            return rv;
        }
        catch (Exception e) {
            throw (ServerError)mapper.handleException(e, this.executor.getContext());
        }
    }

    @Override
    public ome.model.core.OriginalFile register(String repoUuid, CheckedPath checked, String mimetype, ServiceFactory sf, SqlAction sql, Session session) throws ServerError {
        if (checked.isRoot) {
            throw new SecurityViolation(null, null, "Can't re-register the repository");
        }
        CheckedPath parent = checked.parent();
        return this._internalRegister(repoUuid, Arrays.asList(checked), Arrays.asList(parent), null, mimetype, sf, sql, session).get(0);
    }

    public Job saveJob(Job job, Current current) throws ServerError {
        if (job == null) {
            throw new ValidationException(null, null, "Job is null!");
        }
        IceMapper mapper = new IceMapper();
        try {
            final ome.model.jobs.Job in = (ome.model.jobs.Job)mapper.reverse(job);
            ome.model.jobs.Job out = (ome.model.jobs.Job)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<ome.model.jobs.Job>((Object)this, "saveJob", new Object[]{in}){

                @Transactional(readOnly=false)
                public ome.model.jobs.Job doWork(Session session, ServiceFactory sf) {
                    JobHandle jh = sf.createJobHandle();
                    jh.submit(in);
                    return jh.getJob();
                }
            });
            return (Job)mapper.map((Filterable)out);
        }
        catch (Exception e) {
            throw (ServerError)mapper.handleException(e, this.executor.getContext());
        }
    }

    @Override
    public void updateJob(Job job, final String message, final String status, Current current) throws ServerError {
        if (job == null || job.getId() == null) {
            throw new ValidationException(null, null, "Job is null!");
        }
        IceMapper mapper = new IceMapper();
        try {
            final ome.model.jobs.Job in = (ome.model.jobs.Job)mapper.reverse(job);
            this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Void>((Object)this, "updateJob", new Object[]{in, message, status}){

                @Transactional(readOnly=false)
                public Void doWork(Session session, ServiceFactory sf) {
                    JobHandle jh = sf.createJobHandle();
                    jh.attach(in.getId().longValue());
                    jh.setStatusAndMessage(status, message);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw (ServerError)mapper.handleException(e, this.executor.getContext());
        }
    }

    @Override
    public void makeDirs(final PublicRepositoryI repo, final List<CheckedPath> dirs, final boolean parents, Current __current) throws ServerError {
        try {
            EventContext effectiveEventContext;
            String realSessionUuid = (String)__current.ctx.get("omero.internal.sudo.real:omero.session.uuid");
            if (realSessionUuid != null) {
                String realGroupName = (String)__current.ctx.get("omero.internal.sudo.real:omero.group");
                Principal realPrincipal = new Principal(realSessionUuid, realGroupName, null);
                HashMap<String, String> realCtx = new HashMap<String, String>(__current.ctx);
                realCtx.put("omero.session.uuid", realSessionUuid);
                if (realGroupName == null) {
                    realCtx.remove("omero.group");
                } else {
                    realCtx.put("omero.group", realGroupName);
                }
                effectiveEventContext = (EventContext)this.executor.execute(realCtx, realPrincipal, (Executor.Work)new Executor.SimpleWork<EventContext>((Object)this, "makeDirs", new Object[]{dirs}){

                    @Transactional(readOnly=true)
                    public EventContext doWork(Session session, ServiceFactory sf) {
                        return ((LocalAdmin)sf.getAdminService()).getEventContextQuiet();
                    }
                });
            } else {
                effectiveEventContext = null;
            }
            this.executor.execute(__current.ctx, this.currentUser(__current), (Executor.Work)new Executor.SimpleWork<Void>((Object)this, "makeDirs", new Object[]{dirs}){

                @Transactional(readOnly=false)
                public Void doWork(Session session, ServiceFactory sf) {
                    EventContext eventContext = effectiveEventContext == null ? ((LocalAdmin)sf.getAdminService()).getEventContextQuiet() : effectiveEventContext;
                    for (CheckedPath checked : dirs) {
                        try {
                            repo.makeDir(checked, parents, session, sf, this.getSqlAction(), eventContext);
                        }
                        catch (ServerError se) {
                            throw new Rethrow((Throwable)((Object)se));
                        }
                    }
                    return null;
                }
            });
        }
        catch (Rethrow rt) {
            throw (ServerError)((Object)rt.t);
        }
        catch (Exception e) {
            throw (ServerError)this.mapper.handleException(e, this.executor.getContext());
        }
    }

    private List<ome.model.core.OriginalFile> _internalRegister(String repoUuid, List<CheckedPath> checked, List<CheckedPath> parents, ChecksumAlgorithm checksumAlgorithm, String mimetype, ServiceFactory sf, SqlAction sql, Session session) {
        ArrayList<ome.model.core.OriginalFile> toReturn = new ArrayList<ome.model.core.OriginalFile>();
        ArrayListMultimap levels = ArrayListMultimap.create();
        for (int i = 0; i < checked.size(); ++i) {
            levels.put((Object)parents.get(i), (Object)checked.get(i));
        }
        for (CheckedPath parent : levels.keySet()) {
            List level = levels.get((Object)parent);
            ArrayList<String> basenames = new ArrayList<String>(checked.size());
            for (CheckedPath path : level) {
                basenames.add(path.getName());
            }
            Slf4JStopWatch sw = new Slf4JStopWatch();
            Map fileIds = sql.findRepoFiles(repoUuid, ((CheckedPath)level.get(0)).getRelativePath(), basenames, null);
            sw.stop("omero.repo.internal_register.find_repo_files");
            ArrayList<Long> toLoad = new ArrayList<Long>();
            ArrayList<CheckedPath> toCreate = new ArrayList<CheckedPath>();
            for (int i = 0; i < level.size(); ++i) {
                CheckedPath path = (CheckedPath)level.get(i);
                Long fileId = (Long)fileIds.get(path.getName());
                if (fileId == null) {
                    toCreate.add(path);
                    continue;
                }
                toLoad.add(fileId);
            }
            if (toCreate.size() > 0) {
                this.canWriteParentDirectory(sf, sql, repoUuid, parent);
                List<ome.model.core.OriginalFile> created = this.createOriginalFile(sf, sql, repoUuid, toCreate, checksumAlgorithm, mimetype, session);
                toReturn.addAll(created);
            }
            sw = new Slf4JStopWatch();
            if (toLoad.size() > 0) {
                List loaded = sf.getQueryService().findAllByQuery("select o from OriginalFile o where o.id in (:ids)", new Parameters().addIds(toLoad));
                toReturn.addAll(loaded);
            }
            sw.stop("omero.repo.internal_register.load");
        }
        Slf4JStopWatch sw = new Slf4JStopWatch();
        ArrayList<ome.model.core.OriginalFile> toReturnSorted = new ArrayList<ome.model.core.OriginalFile>();
        for (CheckedPath path : checked) {
            ome.model.core.OriginalFile of = toReturn.stream().filter(f -> (f.getName().equals(path.getName()) || f.getName().equals(this.fileRepoSecretKey + path.getName())) && f.getPath().equals(path.getRelativePath())).findFirst().get();
            toReturnSorted.add(of);
        }
        sw.stop("omero.repo.internal_register.sort");
        return toReturnSorted;
    }

    @Override
    public FsFile getFile(final long id, Current current, final String repoUuid) {
        return (FsFile)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<FsFile>((Object)this, "getFile", new Object[]{id}){

            @Transactional(readOnly=true)
            public FsFile doWork(Session session, ServiceFactory sf) {
                String path = this.getSqlAction().findRepoFilePath(repoUuid, id);
                if (path == null) {
                    return null;
                }
                return new FsFile(path);
            }
        });
    }

    @Override
    public List<SqlAction.DeleteLog> findRepoDeleteLogs(final SqlAction.DeleteLog template, Current current) {
        return (List)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<List<SqlAction.DeleteLog>>((Object)this, "findRepoDeleteLogs", new Object[]{template}){

            @Transactional(readOnly=true)
            public List<SqlAction.DeleteLog> doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().findRepoDeleteLogs(template);
            }
        });
    }

    @Override
    public List<List<SqlAction.DeleteLog>> findRepoDeleteLogs(final List<SqlAction.DeleteLog> templates, Current current) {
        return (List)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<List<List<SqlAction.DeleteLog>>>((Object)this, "findRepoDeleteLogs", new Object[]{templates}){

            @Transactional(readOnly=true)
            public List<List<SqlAction.DeleteLog>> doWork(Session session, ServiceFactory sf) {
                ArrayList<List<SqlAction.DeleteLog>> rv = new ArrayList<List<SqlAction.DeleteLog>>();
                for (SqlAction.DeleteLog template : templates) {
                    rv.add(this.getSqlAction().findRepoDeleteLogs(template));
                }
                return rv;
            }
        });
    }

    @Override
    public int deleteRepoDeleteLogs(final SqlAction.DeleteLog template, Current current) {
        return (Integer)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<Integer>((Object)this, "deleteRepoDeleteLogs", new Object[]{template}){

            @Transactional(readOnly=false)
            public Integer doWork(Session session, ServiceFactory sf) {
                return this.getSqlAction().deleteRepoDeleteLogs(template);
            }
        });
    }

    @Override
    public List<Integer> deleteRepoDeleteLogs(final List<SqlAction.DeleteLog> templates, Current current) {
        return (List)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<List<Integer>>((Object)this, "deleteRepoDeleteLogs", new Object[]{templates}){

            @Transactional(readOnly=false)
            public List<Integer> doWork(Session session, ServiceFactory sf) {
                ArrayList<Integer> rv = new ArrayList<Integer>();
                for (SqlAction.DeleteLog template : templates) {
                    Integer i = this.getSqlAction().deleteRepoDeleteLogs(template);
                    rv.add(i);
                }
                return rv;
            }
        });
    }

    @Override
    public omero.sys.EventContext getEventContext(Current curr) {
        Principal currentUser = new Principal((String)curr.ctx.get("omero.session.uuid"));
        EventContext ec = (EventContext)this.executor.execute(curr.ctx, currentUser, (Executor.Work)new Executor.SimpleWork<EventContext>((Object)this, "getEventContext", new Object[0]){

            @Transactional(readOnly=true)
            public EventContext doWork(Session session, ServiceFactory sf) {
                return ((LocalAdmin)sf.getAdminService()).getEventContextQuiet();
            }
        });
        return IceMapper.convert(ec);
    }

    @Override
    public String getUserInstitution(final long userId, Current current) {
        return (String)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.SimpleWork<String>((Object)this, "getUserInstitution", new Object[0]){

            @Transactional(readOnly=true)
            public String doWork(Session session, ServiceFactory sf) {
                return RepositoryDaoImpl.this.getUserInstitution(userId, sf);
            }
        });
    }

    @Override
    public String getUserInstitution(long userId, ServiceFactory sf) {
        Object[] firstResult;
        Parameters parameters = new Parameters().addId(Long.valueOf(userId));
        List results = sf.getQueryService().projection(LOAD_USER_INSTITUTION, parameters);
        if (results instanceof List && results.get(0) instanceof Object[] && (firstResult = (Object[])results.get(0)).length > 0 && firstResult[0] instanceof String) {
            return (String)firstResult[0];
        }
        return null;
    }

    protected List<ome.model.core.OriginalFile> createOriginalFile(ServiceFactory sf, SqlAction sql, String repoUuid, List<CheckedPath> checked, ChecksumAlgorithm checksumAlgorithm, String mimetype, Session session) {
        ome.model.enums.ChecksumAlgorithm ca = null;
        if (checksumAlgorithm != null) {
            ca = new ome.model.enums.ChecksumAlgorithm(checksumAlgorithm.getValue().getValue());
        }
        ArrayList<ome.model.core.OriginalFile> rv = new ArrayList<ome.model.core.OriginalFile>();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (CheckedPath path : checked) {
            ome.model.core.OriginalFile ofile = path.asOriginalFile(mimetype);
            rv.add(ofile);
            ofile.setCtime(now);
            ofile.setHasher(ca);
            ofile.setName(this.fileRepoSecretKey + ofile.getName());
            ofile.setRepo(repoUuid);
        }
        Slf4JStopWatch sw = new Slf4JStopWatch();
        IUpdate iUpdate = sf.getUpdateService();
        ome.model.IObject[] saved = iUpdate.saveAndReturnArray(rv.toArray(new ome.model.IObject[rv.size()]));
        sw.stop("omero.repo.create_original_file.save");
        ArrayList<Long> ids = new ArrayList<Long>(saved.length);
        sw = new Slf4JStopWatch();
        for (int i = 0; i < saved.length; ++i) {
            CheckedPath path = checked.get(i);
            ome.model.core.OriginalFile ofile = (ome.model.core.OriginalFile)saved[i];
            rv.set(i, ofile);
            ids.add(ofile.getId());
            if (!"Directory".equals(ofile.getMimetype())) continue;
            this.internalMkdir(path);
        }
        sw.stop("omero.repo.create_original_file.internal_mkdir");
        return rv;
    }

    protected void internalMkdir(CheckedPath file) {
        if (file.exists()) {
            if (file.isRoot || file.isDirectory()) {
                return;
            }
            throw new ResourceError("Cannot mkdir " + file + " because it is already a file");
        }
        try {
            if (!file.mkdirs()) {
                throw new ResourceError("Cannot mkdir " + file);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            throw new ResourceError("Cannot mkdir " + file + ":" + e.getMessage());
        }
    }

    protected void canWriteParentDirectory(ServiceFactory sf, SqlAction sql, String repoUuid, CheckedPath parent) {
        if (parent.isRoot) {
            return;
        }
        Long parentId = sql.findRepoFile(repoUuid, parent.getRelativePath(), parent.getName());
        if (parentId == null) {
            throw new ome.conditions.SecurityViolation("Cannot find parent directory: " + parent);
        }
        ome.model.core.OriginalFile parentObject = new ome.model.core.OriginalFile(parentId, false);
        long parentObjectOwnerId = -1L;
        long parentObjectGroupId = -1L;
        try {
            String query = "SELECT details.owner.id, details.group.id FROM OriginalFile WHERE id = :id";
            Parameters parameters = new Parameters().addId(parentId);
            Object[] results = (Object[])sf.getQueryService().projection("SELECT details.owner.id, details.group.id FROM OriginalFile WHERE id = :id", parameters).get(0);
            parentObjectOwnerId = (Long)results[0];
            parentObjectGroupId = (Long)results[1];
        }
        catch (Exception e) {
            log.warn("failed to retrieve owner and group details for original file #" + parentId, (Throwable)e);
        }
        if (parentObjectOwnerId != this.roles.getRootId() || parentObjectGroupId != this.roles.getUserGroupId()) {
            LocalAdmin admin = (LocalAdmin)sf.getAdminService();
            EventContext ec = admin.getEventContext();
            if (!(admin.canAnnotate((ome.model.IObject)parentObject) || parentObjectGroupId == this.roles.getUserGroupId() && ec.getCurrentGroupPermissions().isGranted(parentObjectOwnerId == ec.getCurrentUserId() ? Permissions.Role.USER : Permissions.Role.GROUP, Permissions.Right.ANNOTATE))) {
                throw new ome.conditions.SecurityViolation("No annotate access for parent directory: " + parentId);
            }
        }
    }

    protected Principal currentUser(Current __current) {
        Map ctx = __current.ctx;
        String session = (String)ctx.get("omero.session.uuid");
        String group = (String)ctx.get("omero.group");
        return new Principal(session, group, null);
    }

    protected Map<String, String> fileContext(long fileId, Current current) throws SecurityViolation {
        OriginalFile file = this.getOriginalFile(fileId, current);
        return this.groupContext(file.getDetails().getGroup().getId().getValue(), current);
    }

    protected Map<String, String> groupContext(Long groupId, Current current) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (current.ctx != null) {
            context.putAll(current.ctx);
        }
        if (groupId != null) {
            context.put("omero.group", Long.toString(groupId));
        }
        return context;
    }

    @Override
    public ome.model.enums.ChecksumAlgorithm getChecksumAlgorithm(final String name, Current current) {
        return (ome.model.enums.ChecksumAlgorithm)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.LoggedWork<ome.model.enums.ChecksumAlgorithm>(){

            public String description() {
                return "get a checksum algorithm by name " + name;
            }

            @Transactional(readOnly=true)
            public ome.model.enums.ChecksumAlgorithm doWork(Session session, ServiceFactory sf) {
                String query = "FROM ChecksumAlgorithm WHERE value = :name";
                Parameters params = new Parameters().addString("name", name);
                List results = sf.getQueryService().projection("FROM ChecksumAlgorithm WHERE value = :name", params);
                return (ome.model.enums.ChecksumAlgorithm)((Object[])results.get(0))[0];
            }
        });
    }

    @Override
    public ome.model.core.OriginalFile getOriginalFileWithHasher(final long id, Current current) {
        return (ome.model.core.OriginalFile)this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.LoggedWork<ome.model.core.OriginalFile>(){

            public String description() {
                return "get an original file #" + id + ", with hasher joined";
            }

            @Transactional(readOnly=true)
            public ome.model.core.OriginalFile doWork(Session session, ServiceFactory sf) {
                String query = "FROM OriginalFile o LEFT OUTER JOIN FETCH o.hasher WHERE o.id = :id";
                Parameters params = new Parameters().addId(Long.valueOf(id));
                List results = sf.getQueryService().projection("FROM OriginalFile o LEFT OUTER JOIN FETCH o.hasher WHERE o.id = :id", params);
                return (ome.model.core.OriginalFile)((Object[])results.get(0))[0];
            }
        });
    }

    @Override
    public void saveObject(final ome.model.IObject object, Current current) {
        this.executor.execute(current.ctx, this.currentUser(current), (Executor.Work)new Executor.LoggedWork<Void>(){

            public String description() {
                return "save the model object " + object;
            }

            @Transactional(readOnly=false)
            public Void doWork(Session session, ServiceFactory sf) {
                sf.getUpdateService().saveObject(object);
                return null;
            }
        });
    }

    private static abstract class StatefulWork<T>
    extends Executor.SimpleWork<T>
    implements Executor.StatefulWork {
        private final RawFileBean bean;

        StatefulWork(RawFileBean bean, Object self, String method, Object ... args) {
            super(self, method, args);
            this.bean = bean;
        }

        public Object getThis() {
            return this.bean;
        }
    }

    private static class Rethrow
    extends InternalException {
        private final Throwable t;

        Rethrow(Throwable t) {
            super("rethrow!");
            this.t = t;
        }
    }
}

