/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import omero.cmd.SkipHead;
import omero.cmd.graphs.BaseGraphPolicyAdjuster;
import omero.cmd.graphs.GraphUtil;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipHeadPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipHeadPolicy.class);

    public static GraphPolicy getSkipHeadPolicySkip(final GraphPolicy graphPolicy, final GraphPathBean graphPathBean, Collection<String> startFrom, final GraphPolicy.Action startAction, final SetMultimap<String, Long> permissionsOverrides) throws GraphException {
        if (CollectionUtils.isEmpty(startFrom)) {
            throw new GraphException(SkipHead.class.getSimpleName() + " requires the start classes to be named");
        }
        Function<String, Class<? extends IObject>> getClassFromName = new Function<String, Class<? extends IObject>>(){

            @Override
            public Class<? extends IObject> apply(String className) {
                int lastDot = className.lastIndexOf(46);
                if (lastDot > 0) {
                    className = className.substring(lastDot + 1);
                }
                return graphPathBean.getClassForSimpleName(className);
            }
        };
        final ImmutableSet startFromClasses = ImmutableSet.copyOf((Collection)startFrom.stream().map(getClassFromName).collect(Collectors.toSet()));
        final Predicate<IObject> isStartFrom = new Predicate<IObject>(){
            private final Predicate<Class<? extends IObject>> tester;
            {
                this.tester = GraphUtil.getPredicateFromClasses((Iterable<Class<? extends IObject>>)startFromClasses);
            }

            @Override
            public boolean test(IObject subject) {
                return this.tester.test(subject.getClass());
            }
        };
        return new GraphPolicy(){

            public void registerPredicate(GraphPolicyRulePredicate predicate) {
                graphPolicy.registerPredicate(predicate);
            }

            public GraphPolicy getCleanInstance() {
                throw new IllegalStateException("not expecting to provide a clean instance");
            }

            public void setCondition(String name) {
                graphPolicy.setCondition(name);
            }

            public boolean isCondition(String name) {
                return graphPolicy.isCondition(name);
            }

            public void noteDetails(Session session, IObject object, String realClass, long id) {
                graphPolicy.noteDetails(session, object, realClass, id);
            }

            public final Set<GraphPolicy.Details> review(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, boolean isErrorRules) throws GraphException {
                if (rootObject.action == startAction && isStartFrom.test(rootObject.subject)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("deferring review of " + rootObject);
                    }
                    String className = rootObject.subject.getClass().getName();
                    Long id = rootObject.subject.getId();
                    if (rootObject.isCheckPermissions) {
                        permissionsOverrides.remove((Object)className, (Object)id);
                    } else {
                        permissionsOverrides.put((Object)className, (Object)id);
                    }
                    return Collections.emptySet();
                }
                return graphPolicy.review(linkedFrom, rootObject, linkedTo, notNullable, isErrorRules);
            }
        };
    }

    public static GraphPolicy getSkipHeadPolicyPerform(GraphPolicy graphPolicy, final SetMultimap<String, Long> permissionsOverrides) {
        return new BaseGraphPolicyAdjuster(graphPolicy){

            @Override
            protected boolean isAdjustedBeforeReview(GraphPolicy.Details object) {
                if (object.isCheckPermissions && permissionsOverrides.containsEntry((Object)object.subject.getClass().getName(), (Object)object.subject.getId())) {
                    object.isCheckPermissions = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("preserving previous setting, making " + object);
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

