/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Input {
    private RandomAccessFile raf = null;
    private String header = "GRIB";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    private final ArrayList records = new ArrayList();
    private final ArrayList products = new ArrayList();
    private final HashMap gdsHM = new HashMap();

    public Grib1Input(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final void scan(boolean getProducts, boolean oneRecord) throws NotSupportedException, NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        HashMap gdsCounter = new HashMap();
        Grib1ProductDefinitionSection pds = null;
        Grib1GridDefinitionSection gds = null;
        long gdsOffset = 0L;
        while (this.raf.getFilePointer() < this.raf.length()) {
            int length;
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
            if (is.getGribEdition() == 2) {
                System.out.println("Error Grib 2 record in Grib1 file");
                continue;
            }
            long EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
            pds = new Grib1ProductDefinitionSection(this.raf);
            if (pds.getLengthErr()) continue;
            if (pds.gdsExists()) {
                gdsOffset = this.raf.getFilePointer();
                gds = new Grib1GridDefinitionSection(this.raf);
            } else {
                gds = new Grib1Grid(pds);
            }
            long dataOffset = 0L;
            dataOffset = pds.getCenter() == 98 ? ((long)(length = GribNumbers.uint3(this.raf)) + this.raf.getFilePointer() < EOR ? this.raf.getFilePointer() - 3L : this.raf.getFilePointer() - 2L) : this.raf.getFilePointer();
            this.raf.seek(EOR);
            if (getProducts) {
                Grib1Product gp = new Grib1Product(this.header, pds, this.getGDSkey(gds, gdsCounter), gdsOffset, this.raf.getFilePointer());
                this.products.add(gp);
            } else {
                Grib1Record gr = new Grib1Record(this.header, is, pds, gds, dataOffset, this.raf.getFilePointer());
                this.records.add(gr);
            }
            if (oneRecord) {
                return;
            }
            if (this.raf.getFilePointer() <= this.raf.length()) continue;
            this.raf.seek(0L);
            System.err.println("Grib1Input: possible file corruption");
            this.checkGDSkeys(gds, gdsCounter);
            return;
        }
        this.checkGDSkeys(gds, gdsCounter);
    }

    public final int getEdition() throws IOException, NotSupportedException {
        long length;
        boolean check = false;
        long l = length = this.raf.length() < 4000L ? this.raf.length() : 4000L;
        if (!this.seekHeader(this.raf, length)) {
            return 0;
        }
        Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            char c = (char)raf.read();
            hdr.append(c);
            if (c == 'G') {
                match = 1;
                continue;
            }
            if (c == 'R' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'I' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'B' && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB1";
                return true;
            }
            match = 0;
        }
        return false;
    }

    private String getGDSkey(Grib1GridDefinitionSection gds, HashMap gdsCounter) {
        String key = gds.getCheckSum();
        if (gds.getGridType() == 0 || gds.getGridType() == 4) {
            if (!this.gdsHM.containsKey(key)) {
                this.gdsHM.put(key, gds);
            }
        } else if (!this.gdsHM.containsKey(key)) {
            this.gdsHM.put(key, gds);
            gdsCounter.put(key, "1");
        } else {
            int count = Integer.parseInt((String)gdsCounter.get(key));
            gdsCounter.put(key, Integer.toString(++count));
        }
        return key;
    }

    private void checkGDSkeys(Grib1GridDefinitionSection gds, HashMap gdsCounter) {
        String key;
        if (gds.getGridType() == 0 || gds.getGridType() == 4) {
            return;
        }
        String bestKey = "";
        int count = 0;
        Iterator it = gdsCounter.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            int gdsCount = Integer.parseInt((String)gdsCounter.get(key));
            if (gdsCount <= count) continue;
            count = gdsCount;
            bestKey = key;
        }
        gdsCounter.remove(bestKey);
        it = gdsCounter.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            this.gdsHM.remove(key);
        }
        for (int i = 0; i < this.products.size(); ++i) {
            Grib1Product g1p = (Grib1Product)this.products.get(i);
            g1p.setGDSkey(bestKey);
        }
    }

    public final ArrayList getProducts() {
        return this.products;
    }

    public final ArrayList getRecords() {
        return this.records;
    }

    public final HashMap getGDSs() {
        return this.gdsHM;
    }
}

