/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.jobs.Job;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@PrimaryKeyJoinColumn(name="job_id")
@Table(name="pixeldatajob")
@ForeignKey(name="FKpixeldatajob_job_id_job")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class PixelDataJob
extends Job
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "pixeldatajob_owner_filter";
    public static final String GROUP_FILTER = "pixeldatajob_group_filter";
    public static final String EVENT_FILTER = "pixeldatajob_event_filter";
    public static final String PERMS_FILTER = "pixeldatajob_perms_filter";
    public static final Set<String> FIELDS;

    public PixelDataJob() {
        this(null, true);
    }

    protected PixelDataJob(Long id) {
        this(id, true);
    }

    public PixelDataJob(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public PixelDataJob newInstance() {
        return new PixelDataJob();
    }

    public PixelDataJob proxy() {
        return new PixelDataJob(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        super.putAt(field, value);
    }

    @Override
    public void unload() {
        this._loaded = false;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet raw = new HashSet();
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

