/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DFSEdgeTypes;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePathEnumerator
implements EdgeTypes,
DFSEdgeTypes {
    private CFG cfg;
    private DepthFirstSearch dfs;
    private int maxPaths;
    private int maxWork;
    private int work;
    private List<List<Edge>> pathList;
    private static final boolean DEBUG = SystemProperties.getBoolean("spe.debug");
    public static final int DEFAULT_MAX_WORK = 200000;

    public SimplePathEnumerator(CFG cfg, int maxPaths, int maxWork) {
        this.cfg = cfg;
        this.dfs = new DepthFirstSearch(cfg);
        this.dfs.search();
        this.maxPaths = maxPaths;
        this.maxWork = maxWork;
        this.work = 0;
        this.pathList = new LinkedList<List<Edge>>();
    }

    public SimplePathEnumerator(CFG cfg, int maxPaths) {
        this(cfg, maxPaths, 200000);
    }

    public SimplePathEnumerator enumerate() {
        Iterator entryOut = this.cfg.outgoingEdgeIterator(this.cfg.getEntry());
        if (!entryOut.hasNext()) {
            throw new IllegalStateException();
        }
        Edge entryEdge = (Edge)entryOut.next();
        LinkedList<Edge> init = new LinkedList<Edge>();
        init.add(entryEdge);
        this.work(init);
        if (DEBUG && this.work == this.maxWork) {
            System.out.println("**** Reached max work! ****");
        }
        return this;
    }

    public Iterator<List<Edge>> iterator() {
        return this.pathList.iterator();
    }

    private void work(LinkedList<Edge> partialPath) {
        if (this.pathList.size() == this.maxPaths) {
            return;
        }
        Edge last = partialPath.getLast();
        if (last.getTarget() == this.cfg.getExit()) {
            this.pathList.add(new LinkedList<Edge>(partialPath));
            return;
        }
        Iterator i = this.cfg.outgoingEdgeIterator(last.getTarget());
        while (i.hasNext()) {
            Edge outEdge = (Edge)i.next();
            if (this.dfs.getDFSEdgeType(outEdge) == 1 || outEdge.getType() == 8) continue;
            partialPath.add(outEdge);
            this.work(partialPath);
            partialPath.removeLast();
            if (this.work == this.maxWork) {
                return;
            }
            ++this.work;
            if (this.pathList.size() != this.maxPaths) continue;
            return;
        }
    }
}

