/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subtypes {
    private static final boolean DEBUG_HIERARCHY = SystemProperties.getBoolean("findbugs.debug.hierarchy");
    private boolean computed = false;
    private Set<String> referenced = new HashSet<String>();
    private Set<JavaClass> allClasses = new HashSet<JavaClass>();
    private Set<JavaClass> applicationClasses = new HashSet<JavaClass>();
    private Set<JavaClass> parentsAdded = new HashSet<JavaClass>();
    private Map<JavaClass, Set<JavaClass>> immediateSubtypes = new HashMap<JavaClass, Set<JavaClass>>();
    private Map<JavaClass, Set<JavaClass>> transitiveSubtypes = new HashMap<JavaClass, Set<JavaClass>>();

    public Set<JavaClass> getImmediateSubtypes(JavaClass c) {
        if (!this.allClasses.contains(c)) {
            this.addClass(c);
        }
        this.compute();
        return this.immediateSubtypes.get(c);
    }

    public boolean hasSubtypes(JavaClass c) {
        if (!this.allClasses.contains(c)) {
            this.addClass(c);
        }
        this.compute();
        return !this.immediateSubtypes.get(c).isEmpty();
    }

    public Set<JavaClass> getAllClasses() {
        this.compute();
        return this.allClasses;
    }

    public Set<JavaClass> getTransitiveSubtypes(JavaClass c) {
        if (!this.allClasses.contains(c)) {
            this.addClass(c);
        }
        this.compute();
        return this.transitiveSubtypes.get(c);
    }

    public Set<JavaClass> getTransitiveCommonSubtypes(JavaClass a, JavaClass b) {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        result.addAll(this.getTransitiveSubtypes(a));
        result.add(a);
        boolean bIsSubtypeOfA = result.contains(b);
        result.retainAll(this.getTransitiveSubtypes(b));
        if (bIsSubtypeOfA) {
            result.add(b);
        }
        return result;
    }

    private void addReferencedClasses(JavaClass c) {
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append("adding referenced classes for ").append(c.getClassName()).toString());
        }
        ConstantPool cp = c.getConstantPool();
        Constant[] constants = cp.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            int j;
            Constant co = constants[i];
            if (co instanceof ConstantDouble || co instanceof ConstantLong) {
                ++i;
            }
            if (co instanceof ConstantClass) {
                String originalName = null;
                try {
                    originalName = ((ConstantClass)co).getBytes(cp);
                    String name = Subtypes.extractClassName(originalName);
                    if (DEBUG_HIERARCHY) {
                        System.out.println(new StringBuffer().append(i).append(" : ").append(name).toString());
                    }
                    this.addNamedClass(name);
                }
                catch (RuntimeException e) {
                    AnalysisContext.logError(new StringBuffer().append("Error extracting name from ").append(originalName).toString(), e);
                }
                continue;
            }
            if (!(co instanceof ConstantCP)) continue;
            ConstantCP co2 = (ConstantCP)co;
            ConstantNameAndType nt = (ConstantNameAndType)cp.getConstant(co2.getNameAndTypeIndex());
            String sig = ((ConstantUtf8)cp.getConstant(nt.getSignatureIndex())).getBytes();
            while ((j = sig.indexOf(76)) != -1) {
                int k = sig.indexOf(59, j);
                String name = sig.substring(j + 1, k);
                if (DEBUG_HIERARCHY) {
                    System.out.println(new StringBuffer().append(i).append(" : ").append(name).toString());
                }
                this.addNamedClass(name);
                sig = sig.substring(k + 1);
            }
        }
    }

    public static void learnFieldsAndMethods(JavaClass c) {
        for (Field field : c.getFields()) {
            XFactory.createXField(c, field);
        }
        for (FieldOrMethod fieldOrMethod : c.getMethods()) {
            XFactory.createXMethod(c, (Method)fieldOrMethod);
        }
    }

    public void addNamedClass(String name) {
        block4: {
            if (name.length() == 0 || name.charAt(0) == '[') {
                AnalysisContext.logError(new StringBuffer().append("Bad class name: ").append(name).toString());
                return;
            }
            if (this.referenced.add(name = name.replace('/', '.'))) {
                try {
                    JavaClass clazz = Repository.lookupClass(name);
                    Subtypes.learnFieldsAndMethods(clazz);
                    this.addClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    if (name.length() <= 1) break block4;
                    AnalysisContext.reportMissingClass(e);
                }
            }
        }
    }

    public void addApplicationClass(JavaClass c) {
        if (c == null) {
            return;
        }
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append("Adding application class ").append(c.getClassName()).toString());
        }
        if (this.applicationClasses.add(c)) {
            Subtypes.learnFieldsAndMethods(c);
            if (DEBUG_HIERARCHY && this.computed) {
                System.out.println("Need to recompute");
            }
            this.computed = false;
        }
    }

    public void addClass(JavaClass c) {
        if (c == null) {
            return;
        }
        if (this.allClasses.add(c)) {
            if (DEBUG_HIERARCHY) {
                System.out.println(new StringBuffer().append("ADDING ").append(c.getClassName()).append(" ").append(System.identityHashCode(c)).append(" ").append(c.hashCode()).toString());
            }
            this.immediateSubtypes.put(c, new HashSet());
            if (DEBUG_HIERARCHY && this.computed) {
                System.out.println("Need to recompute");
            }
            this.computed = false;
        } else if (!this.immediateSubtypes.containsKey(c)) {
            if (DEBUG_HIERARCHY) {
                System.out.println(new StringBuffer().append("INITIALIZING ").append(c.getClassName()).append(" ").append(System.identityHashCode(c)).append(" ").append(c.hashCode()).toString());
            }
            this.immediateSubtypes.put(c, new HashSet());
        }
    }

    private void addParents(JavaClass c) {
        if (!this.parentsAdded.add(c)) {
            return;
        }
        try {
            this.addParent(c.getSuperClass(), c);
            for (JavaClass i : c.getInterfaces()) {
                this.addParent(i, c);
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    private void addParent(JavaClass p, JavaClass c) {
        if (p == null) {
            return;
        }
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append("adding ").append(c.getClassName()).append(" is a ").append(p.getClassName()).toString());
        }
        this.addClass(p);
        this.addParents(p);
        Set<JavaClass> children = this.immediateSubtypes.get(p);
        children.add(c);
    }

    private void compute() {
        if (this.computed) {
            return;
        }
        if (DEBUG_HIERARCHY) {
            System.out.println("Computing {");
        }
        this.transitiveSubtypes.clear();
        for (JavaClass c : this.applicationClasses) {
            this.addClass(c);
            this.addReferencedClasses(c);
        }
        for (JavaClass c : new HashSet<JavaClass>(this.allClasses)) {
            this.addParents(c);
        }
        for (JavaClass c : this.allClasses) {
            this.compute(c);
        }
        this.parentsAdded.clear();
        if (DEBUG_HIERARCHY) {
            System.out.println("} Done Computing");
        }
        this.computed = true;
    }

    private Set<JavaClass> compute(JavaClass c) {
        Set<JavaClass> descendents;
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append(" compute ").append(c.getClassName()).append(" ").append(System.identityHashCode(c)).append(" ").append(c.hashCode()).append(" ").append(this.immediateSubtypes.get(c) == null ? " id is null" : " id is non null").toString());
        }
        if ((descendents = this.transitiveSubtypes.get(c)) != null) {
            if (!descendents.contains(c)) {
                System.out.println(new StringBuffer().append("This is wrong for ").append(c.getClassName()).toString());
            }
            return descendents;
        }
        descendents = new HashSet<JavaClass>();
        descendents.add(c);
        this.transitiveSubtypes.put(c, descendents);
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append("immediate subtypes of ").append(c.getClassName()).append(" ").append(System.identityHashCode(c)).append(" ").append(c.hashCode()).append(this.immediateSubtypes.get(c) == null ? " is null" : " is non null").toString());
        }
        for (JavaClass child : this.immediateSubtypes.get(c)) {
            if (DEBUG_HIERARCHY) {
                System.out.println(new StringBuffer().append("Updating child ").append(child.getClassName()).append(" of ").append(c.getClassName()).toString());
            }
            descendents.addAll(this.compute(child));
        }
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append(c.getClassName()).append(" has ").append(descendents.size()).append(" decendents").toString());
        }
        return descendents;
    }

    public static String extractClassName(String originalName) {
        String name = originalName;
        if (name.charAt(0) != '[' && name.charAt(name.length() - 1) != ';') {
            return name;
        }
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        if (name.charAt(0) == '[') {
            throw new IllegalArgumentException(new StringBuffer().append("Bad class name: ").append(originalName).toString());
        }
        return name;
    }

    public boolean isApplicationClass(JavaClass javaClass) {
        boolean isAppClass = this.applicationClasses.contains(javaClass);
        if (DEBUG_HIERARCHY) {
            System.out.println(new StringBuffer().append(javaClass.getClassName()).append(" ==> ").append(isAppClass ? "IS" : "IS NOT").append(" an application class (").append(this.applicationClasses.size()).append(" entries in app class map)").toString());
        }
        return isAppClass;
    }
}

