/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsPressure;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPressureEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Pressure
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Pressure_value";
    public static final String UNIT = "ome.model.units.Pressure_unit";
    private double value;
    private UnitsPressure unit = null;

    public static ome.xml.model.enums.UnitsPressure makePressureUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsPressure.fromString((String)unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Pressure unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Pressure makePressureXML(double d, String unit) {
        ome.units.unit.Unit units = UnitsPressureEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsPressure)Pressure.makePressureUnitXML(unit));
        return new ome.units.quantity.Pressure((Number)d, units);
    }

    public static ome.units.quantity.Pressure convertPressure(Pressure t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsPressure units = Pressure.makePressureUnitXML(u);
        ome.units.unit.Unit units2 = UnitsPressureEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsPressure)units);
        return new ome.units.quantity.Pressure((Number)v, units2);
    }

    public static Pressure convertPressure(Pressure value, ome.units.unit.Unit<ome.units.quantity.Pressure> ul) {
        return Pressure.convertPressure(value, ul.getSymbol());
    }

    public static Pressure convertPressure(Pressure value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Pressure() {
    }

    public Pressure(double d, String u) {
        this.value = d;
        this.unit = UnitsPressure.valueOf(u);
    }

    public Pressure(double d, UnitsPressure u) {
        this.value = d;
        this.unit = u;
    }

    public Pressure(double d, ome.units.unit.Unit<ome.units.quantity.Pressure> unit) {
        this(d, UnitsPressure.bySymbol(unit.getSymbol()));
    }

    public Pressure(ome.units.quantity.Pressure value) {
        this(value.value().doubleValue(), UnitsPressure.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="PRESSURE")})
    public UnitsPressure getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsPressure unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsPressure)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Pressure(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pressure other = (Pressure)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

