/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeKey<T> {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;

    public AttributeKey(String key) {
        this(key, null, true);
    }

    public AttributeKey(String key, T defaultValue) {
        this(key, defaultValue, true);
    }

    public AttributeKey(String key, T defaultValue, boolean isNullValueAllowed) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClone(Figure f) {
        T value = this.get(f);
        try {
            return (T)(value == null ? null : Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public T get(Figure f) {
        Object value = f.getAttribute(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public T get(Map<AttributeKey, Object> a) {
        Object value = a.get(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public void set(Figure f, T value) {
        f.willChange();
        this.basicSet(f, value);
        f.changed();
    }

    public void basicSet(Figure f, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        f.setAttribute(this, value);
    }

    public UndoableEdit setUndoable(final Figure figure, final T value, final ResourceBundleUtil labels) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        final Object restoreData = figure.getAttributesRestoreData();
        figure.willChange();
        figure.setAttribute(this, value);
        figure.changed();
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            public String getPresentationName() {
                return labels.getString(AttributeKey.this.getKey());
            }

            public void undo() {
                super.undo();
                figure.willChange();
                figure.restoreAttributesTo(restoreData);
                figure.changed();
            }

            public void redo() {
                super.redo();
                figure.willChange();
                figure.setAttribute(AttributeKey.this, value);
                figure.changed();
            }
        };
        return edit;
    }

    public void setClone(Figure f, T value) {
        f.willChange();
        this.basicSetClone(f, value);
        f.changed();
    }

    public void basicSetClone(Figure f, T value) {
        try {
            this.basicSet(f, value == null ? null : Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public void set(Map<AttributeKey, Object> a, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        a.put(this, value);
    }

    public void setClone(Map<AttributeKey, Object> a, T value) {
        try {
            this.set(a, value == null ? null : Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AttributeKey) {
            AttributeKey that = (AttributeKey)o;
            return that.key.equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public boolean isAssignable(Object value) {
        if (value == null) {
            return this.isNullValueAllowed();
        }
        try {
            Object a = value;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

