/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ome.api.IQuery;
import ome.conditions.InternalException;
import ome.conditions.ResourceError;
import ome.formats.OMEROMetadataStore;
import ome.io.nio.OriginalFilesService;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.enums.Format;
import ome.model.screen.Plate;
import ome.model.screen.Well;
import ome.model.screen.WellSample;
import ome.parameters.Parameters;
import ome.services.blitz.impl.AbstractCloseableAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.BlitzOnly;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.roi.PopulateRoiJob;
import ome.services.throttling.Adapter;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.ServiceFactory;
import ome.tools.spring.InternalServiceFactory;
import ome.util.SqlAction;
import omero.RBool;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RLong;
import omero.RMap;
import omero.RString;
import omero.ServerError;
import omero.api.AMD_MetadataStore_createRoot;
import omero.api.AMD_MetadataStore_populateMinMax;
import omero.api.AMD_MetadataStore_postProcess;
import omero.api.AMD_MetadataStore_saveToDB;
import omero.api.AMD_MetadataStore_setPixelsFile;
import omero.api.AMD_MetadataStore_updateObjects;
import omero.api.AMD_MetadataStore_updateReferences;
import omero.api._MetadataStoreOperations;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.SharedResourcesPrx;
import omero.metadatastore.IObjectContainer;
import omero.model.FilesetJobLink;
import omero.model.ScriptJob;
import omero.rtypes;
import omero.util.IceMapper;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class MetadataStoreI
extends AbstractCloseableAmdServant
implements _MetadataStoreOperations,
ServiceFactoryAware,
BlitzOnly {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreI.class);
    protected final Set<Long> savedPlates = new HashSet<Long>();
    protected final Set<Long> savedImagesNotInPlates = new HashSet<Long>();
    protected OMEROMetadataStore store;
    protected ServiceFactoryI sf;
    protected PopulateRoiJob popRoi;
    protected final SqlAction sql;
    protected final OriginalFilesService filesService;
    protected final String omeroDataDir;

    public MetadataStoreI(BlitzExecutor be, PopulateRoiJob popRoi, SqlAction sql, OriginalFilesService filesService, String omeroDataDir) throws Exception {
        super(null, be);
        this.popRoi = popRoi;
        this.sql = sql;
        this.filesService = filesService;
        this.omeroDataDir = new File(omeroDataDir).getAbsolutePath() + File.separator;
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
    }

    @Override
    public void onSetOmeroContext(OmeroContext ctx) throws Exception {
        InternalServiceFactory sf = new InternalServiceFactory(ctx);
        this.store = new OMEROMetadataStore(sf, this.sql);
    }

    private <T extends IObject> T safeReverse(Object o, IceMapper mapper) {
        try {
            return (T)((IObject)mapper.reverse(o));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely reverse: " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePixels(List<Pixels> pixels, Map<String, List<? extends IObject>> rv, IQuery query) {
        Set<Long> set = this.savedPlates;
        synchronized (set) {
            for (Pixels p : pixels) {
                Image i = p.getImage();
                if (i == null) continue;
                if (i.sizeOfWellSamples() < 1) {
                    this.savedImagesNotInPlates.add(i.getId());
                    continue;
                }
                for (WellSample ws : i.unmodifiableWellSamples()) {
                    Plate plate;
                    Well w = ws.getWell();
                    if (w == null || (plate = w.getPlate()) == null) continue;
                    this.savedPlates.add(plate.getId());
                }
            }
        }
        List<IObject> plates = this.loadObjects("Plate", query, this.savedPlates);
        List<IObject> images = this.loadObjects("Image", query, this.savedImagesNotInPlates);
        rv.put("Plate", plates);
        rv.put("Image", images);
        rv.put("Pixels", pixels);
    }

    private List<IObject> loadObjects(String type, IQuery query, Collection<Long> ids) {
        if (ids != null && ids.size() > 0) {
            return query.findAllByQuery("select p from " + type + " p where p.id in (:ids)", new Parameters().addIds(ids));
        }
        return null;
    }

    @Override
    public void createRoot_async(AMD_MetadataStore_createRoot __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "createRoot", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.createRoot();
                return null;
            }
        }));
    }

    @Override
    public void populateMinMax_async(AMD_MetadataStore_populateMinMax __cb, final double[][][] imageChannelGlobalMinMax, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "populateMinMax", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.populateMinMax(imageChannelGlobalMinMax);
                return null;
            }
        }));
    }

    @Override
    public void saveToDB_async(AMD_MetadataStore_saveToDB __cb, FilesetJobLink link, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.PRIMITIVE_FILTERABLE_COLLECTION_MAP);
        final ome.model.fs.FilesetJobLink link_ = (ome.model.fs.FilesetJobLink)mapper.reverse(link);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "saveToDb", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                HashMap<String, List<Pixels>> rv = new HashMap<String, List<Pixels>>();
                List<Pixels> pix = MetadataStoreI.this.store.saveToDB(link_);
                rv.put("Pixels", pix);
                MetadataStoreI.this.parsePixels(pix, rv, sf.getQueryService());
                return rv;
            }
        }));
    }

    @Override
    public void updateObjects_async(AMD_MetadataStore_updateObjects __cb, final IObjectContainer[] objects, Current __current) throws ServerError {
        final IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "updateObjects", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                for (IObjectContainer o : objects) {
                    IObject sourceObject;
                    try {
                        sourceObject = (IObject)mapper.reverse(o.sourceObject);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    MetadataStoreI.this.store.updateObject(o.LSID, sourceObject, o.indexes);
                }
                return null;
            }
        }));
    }

    @Override
    public void updateReferences_async(AMD_MetadataStore_updateReferences __cb, final Map<String, String[]> references, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "updateReferences", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                MetadataStoreI.this.store.updateReferences(references);
                return null;
            }
        }));
    }

    @Override
    public void postProcess_async(AMD_MetadataStore_postProcess __cb, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.UNMAPPED);
        final ArrayList copy = new ArrayList();
        final ArrayList procs = new ArrayList();
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "postProcess", new Object[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory _sf) {
                Set<Long> set = MetadataStoreI.this.savedPlates;
                synchronized (set) {
                    copy.addAll(MetadataStoreI.this.savedPlates);
                    if (copy.size() == 0) {
                        return null;
                    }
                    for (Long id : copy) {
                        RMap inputs = rtypes.rmap("Plate_ID", rtypes.rlong(id));
                        ScriptJob job = MetadataStoreI.this.popRoi.createJob(_sf);
                        try {
                            SharedResourcesPrx sr = MetadataStoreI.this.sf.sharedResources(null);
                            InteractiveProcessorPrx prx = sr.acquireProcessor(job, 15);
                            prx.execute(inputs);
                            prx.setDetach(true);
                            procs.add(prx);
                            log.info("Launched populateroi.py on plate " + id);
                        }
                        catch (ServerError e) {
                            String msg = "Error acquiring post processor";
                            log.error(msg, (Throwable)((Object)e));
                            throw new InternalException(msg);
                        }
                    }
                    MetadataStoreI.this.savedPlates.clear();
                    return procs;
                }
            }
        }));
    }

    @Override
    public void setPixelsFile_async(AMD_MetadataStore_setPixelsFile __cb, final long pixelsId, final String file, final String repo, Current __current) throws ServerError {
        IceMapper mapper = new IceMapper(IceMapper.VOID);
        this.runnableCall(__current, new Adapter(__cb, __current, mapper, this.sf.executor, this.sf.principal, new Executor.SimpleWork(this, "setPixelsParams", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                File targetFile;
                if (file != null) {
                    targetFile = new File(file);
                } else {
                    Pixels pixels = (Pixels)sf.getQueryService().get(Pixels.class, pixelsId);
                    Format format = pixels.getImage().getFormat();
                    List files = pixels.linkedOriginalFileList();
                    if (files == null || files.size() == 0) {
                        throw new ResourceError(String.format("Pixels:%d has no linked original files!", pixelsId));
                    }
                    OriginalFile source = null;
                    for (OriginalFile file2 : files) {
                        if (!file2.getMimetype().equals(format.getValue())) continue;
                        if (source != null) {
                            throw new ResourceError(String.format("Pixels:%d has at least two source original files %d and %d", pixelsId, source.getId(), file2.getId()));
                        }
                        source = file2;
                    }
                    targetFile = new File(MetadataStoreI.this.filesService.getFilesPath(source.getId()));
                }
                Pattern p = Pattern.compile(Pattern.quote(MetadataStoreI.this.omeroDataDir), 2);
                String parent = targetFile.getParent();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("omero.data.dir: '%s' file.absolutePath: '%s' parent: '%s'", MetadataStoreI.this.omeroDataDir, targetFile.getAbsolutePath(), parent));
                }
                String path = p.matcher(parent).replaceFirst("");
                MetadataStoreI.this.sql.setPixelsNamePathRepo(pixelsId, targetFile.getName(), path, repo);
                return null;
            }
        }));
    }

    public Integer toJavaType(RInt x) {
        return x == null ? null : Integer.valueOf(x.getValue());
    }

    public Long toJavaType(RLong x) {
        return x == null ? null : Long.valueOf(x.getValue());
    }

    public Boolean toJavaType(RBool x) {
        return x == null ? null : Boolean.valueOf(x.getValue());
    }

    public Float toJavaType(RFloat x) {
        return x == null ? null : Float.valueOf(x.getValue());
    }

    public Double toJavaType(RDouble x) {
        return x == null ? null : Double.valueOf(x.getValue());
    }

    public String toJavaType(RString x) {
        return x == null ? null : x.getValue();
    }

    @Override
    protected void preClose(Current current) {
        this.store = null;
    }

    @Override
    protected void postClose(Current current) {
    }
}

