/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ome.api.IAdmin;
import ome.api.IQuery;
import ome.model.IAnnotationLink;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.FolderImageLink;
import ome.model.containers.FolderRoiLink;
import ome.model.containers.ProjectDatasetLink;
import ome.model.internal.Details;
import ome.model.meta.Experimenter;
import ome.model.screen.ScreenPlateLink;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.graphs.GroupPredicate;
import ome.services.graphs.PermissionsPredicate;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import ome.system.Roles;
import omero.ServerError;
import omero.cmd.Chown2;
import omero.cmd.Chown2Response;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.WrappableRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Chown2I
extends Chown2
implements IRequest,
ReadOnlyStatus.IsAware,
WrappableRequest<Chown2> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Chown2I.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of((Object)((Object)GraphPolicy.Ability.DELETE));
    private final ACLVoter aclVoter;
    private final Roles securityRoles;
    private final GraphPathBean graphPathBean;
    private final LightAdminPrivileges adminPrivileges;
    private final Deletion deletionInstance;
    private final Set<Class<? extends IObject>> targetClasses;
    private GraphPolicy graphPolicy;
    private final SetMultimap<String, String> unnullable;
    private final ApplicationContext applicationContext;
    private List<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters = new ArrayList<Function<GraphPolicy, GraphPolicy>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private InternalProcessor internalProcessor;
    private Set<Long> acceptableGroupsFrom;
    private Set<Long> acceptableGroupsTo;
    private GraphTraversal.PlanExecutor unlinker;
    private GraphTraversal.PlanExecutor processor;
    private int targetObjectCount = 0;
    private int deletedObjectCount = 0;
    private int givenObjectCount = 0;

    public Chown2I(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Deletion deletionInstance, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy, SetMultimap<String, String> unnullable, ApplicationContext applicationContext) {
        this.aclVoter = aclVoter;
        this.securityRoles = securityRoles;
        this.graphPathBean = graphPathBean;
        this.adminPrivileges = adminPrivileges;
        this.deletionInstance = deletionInstance;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
        this.unnullable = unnullable;
        this.applicationContext = applicationContext;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("userId", this.userId);
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("targetUsers", (Object)this.targetUsers);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(this.dryRun ? 5 : 7);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        EventContext eventContext = helper.getEventContext();
        boolean isChownPrivilege = this.graphHelper.checkIsAdministrator(this.adminPrivileges.getPrivilege("Chown"));
        if (isChownPrivilege) {
            this.acceptableGroupsFrom = null;
            this.acceptableGroupsTo = null;
        } else {
            IAdmin iAdmin = helper.getServiceFactory().getAdminService();
            this.acceptableGroupsFrom = ImmutableSet.copyOf((Collection)eventContext.getLeaderOfGroupsList());
            this.acceptableGroupsTo = ImmutableSet.copyOf((Collection)iAdmin.getMemberOfGroupIds(new Experimenter(Long.valueOf(this.userId), false)));
            if (this.acceptableGroupsFrom.isEmpty()) {
                throw new RuntimeException(new ome.services.graphs.GraphException("not an owner of any group"));
            }
            if (this.targetUsers != null) {
                for (Long targetUserId : this.targetUsers) {
                    HashSet<Long> groupsForTargetUserData = new HashSet<Long>(this.acceptableGroupsFrom);
                    Experimenter targetUser = new Experimenter(targetUserId, false);
                    groupsForTargetUserData.retainAll(iAdmin.getMemberOfGroupIds(targetUser));
                    if (!groupsForTargetUserData.isEmpty()) continue;
                    String message = "not an owner of any group of " + Experimenter.class.getName() + "[" + targetUserId + "]";
                    throw new RuntimeException(new ome.services.graphs.GraphException(message));
                }
            }
        }
        Set<Object> requiredAbilities = isChownPrivilege ? Collections.emptySet() : REQUIRED_ABILITIES;
        this.graphPolicy.registerPredicate(new GroupPredicate(this.securityRoles));
        this.graphPolicy.registerPredicate(new PermissionsPredicate());
        this.internalProcessor = new InternalProcessor(requiredAbilities);
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(this.childOptions, REQUIRED_ABILITIES, this.graphPolicy, this.graphPolicyAdjusters, this.aclVoter, this.graphPathBean, this.unnullable, this.internalProcessor, this.dryRun);
        if (isChownPrivilege) {
            this.graphTraversal.setOwnsAll();
        }
        this.graphPolicyAdjusters = null;
    }

    private SetMultimap<Class<?>, Class<? extends IObject>> getImplementorMap() throws ServerError {
        HashSet<Class<IObject>> leafClasses = new HashSet<Class<IObject>>();
        for (String className : this.graphPathBean.getAllClasses()) {
            if (!this.graphPathBean.getSubclassesOf(className).isEmpty()) continue;
            try {
                leafClasses.add(Class.forName(className).asSubclass(IObject.class));
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServerError(null, null, "graph path bean reports unknown class " + className, cnfe);
            }
        }
        Iterator leafClassIterator = leafClasses.iterator();
        while (leafClassIterator.hasNext()) {
            Class leafClass = (Class)leafClassIterator.next();
            boolean isLegal = false;
            for (Class<? extends IObject> targetClass : this.targetClasses) {
                if (!targetClass.isAssignableFrom(leafClass)) continue;
                isLegal = true;
                break;
            }
            if (isLegal) continue;
            leafClassIterator.remove();
        }
        HashMultimap implementors = HashMultimap.create();
        for (Class clazz : leafClasses) {
            HashSet interfaces = new HashSet(Arrays.asList(clazz.getInterfaces()));
            while (!interfaces.isEmpty()) {
                Iterator interfaceIterator = interfaces.iterator();
                Class intrface = (Class)interfaceIterator.next();
                interfaceIterator.remove();
                interfaces.addAll(Arrays.asList(intrface.getInterfaces()));
                implementors.put((Object)intrface, (Object)clazz);
            }
        }
        return implementors;
    }

    private void targetAllUsersObjects() throws ServerError {
        SetMultimap<Class<?>, Class<? extends IObject>> implementorMap = this.getImplementorMap();
        IQuery iQuery = this.helper.getServiceFactory().getQueryService();
        Parameters params = new Parameters().addList("owners", this.targetUsers);
        if (this.acceptableGroupsFrom != null) {
            params = params.addSet("groups", this.acceptableGroupsFrom);
        }
        HashSet<Class<? extends IObject>> classesToQuery = new HashSet<Class<? extends IObject>>();
        for (Class<? extends IObject> clazz : this.targetClasses) {
            Set implementors = implementorMap.get(clazz);
            if (implementors.isEmpty()) {
                classesToQuery.add(clazz);
                continue;
            }
            classesToQuery.addAll(implementors);
        }
        for (Class<Object> clazz : classesToQuery) {
            ArrayList<Long> idList;
            String queryClassName = clazz.getName();
            String idProperty = this.graphPathBean.getIdentifierProperty(queryClassName);
            String hql = "SELECT " + idProperty + " FROM " + queryClassName + " WHERE details.owner.id IN (:owners)";
            if (this.acceptableGroupsFrom != null) {
                hql = hql + " AND details.group.id IN (:groups)";
            }
            if ((idList = (ArrayList<Long>)this.targetObjects.get(queryClassName)) == null) {
                idList = new ArrayList<Long>();
                this.targetObjects.put(queryClassName, idList);
            }
            for (Object[] id : iQuery.projection(hql, params)) {
                idList.add((Long)id[0]);
            }
        }
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    if (CollectionUtils.isNotEmpty((Collection)this.targetUsers)) {
                        this.targetAllUsersObjects();
                    }
                    return null;
                }
                case 1: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    return this.graphTraversal.planOperation(targetMultimap, true, true);
                }
                case 2: {
                    this.graphTraversal.assertNoPolicyViolations();
                    return null;
                }
                case 3: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 4: {
                    this.unlinker = this.graphTraversal.unlinkTargets(false);
                    this.graphTraversal = null;
                    return null;
                }
                case 5: {
                    this.unlinker.execute();
                    return null;
                }
                case 6: {
                    this.processor.execute();
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 1) {
            Map.Entry result = (Map.Entry)object;
            if (!this.dryRun) {
                try {
                    this.internalProcessor.deleteFiles(this.deletionInstance);
                }
                catch (Exception e) {
                    this.helper.cancel(new ERR(), (Throwable)e, "file-delete-fail", new String[0]);
                }
            }
            Map<String, List<Long>> givenObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getKey()));
            Map<String, List<Long>> deletedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getValue()));
            this.givenObjectCount += ((SetMultimap)result.getKey()).size();
            this.deletedObjectCount += ((SetMultimap)result.getValue()).size();
            Chown2Response response = new Chown2Response(givenObjects, deletedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in " + (this.dryRun ? "mock " : "") + "chown to " + this.userId + " of " + this.targetObjectCount + ", gave " + this.givenObjectCount + " and deleted " + this.deletedObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("includedObjects", response.includedObjects);
                arguments.addParameter("deletedObjects", response.deletedObjects);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    @Override
    public void copyFieldsTo(Chown2 request) {
        GraphUtil.copyFields(this, request);
        request.userId = this.userId;
    }

    @Override
    public void adjustGraphPolicy(Function<GraphPolicy, GraphPolicy> adjuster) {
        if (this.graphPolicyAdjusters == null) {
            throw new IllegalStateException("request is already initialized");
        }
        this.graphPolicyAdjusters.add(adjuster);
    }

    @Override
    public int getStepProvidingCompleteResponse() {
        return 1;
    }

    @Override
    public GraphPolicy.Action getActionForStarting() {
        return GraphPolicy.Action.INCLUDE;
    }

    @Override
    public Map<String, List<Long>> getStartFrom(Response response) {
        return ((Chown2Response)response).includedObjects;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return this.dryRun;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        private final Logger LOGGER;
        private final ImmutableSet<Class<? extends ILink>> UNIQUENESS_RISK_LINK_TYPES;
        private final Long userFromId;
        private final Experimenter userTo;
        private final Set<GraphPolicy.Ability> requiredAbilities;
        private final Set<LinkDetails> linksToChown;

        public InternalProcessor(Set<GraphPolicy.Ability> requiredAbilities) {
            super(Chown2I.this.helper.getSession());
            this.LOGGER = LoggerFactory.getLogger(InternalProcessor.class);
            this.UNIQUENESS_RISK_LINK_TYPES = ImmutableSet.of(IAnnotationLink.class, ScreenPlateLink.class, ProjectDatasetLink.class, DatasetImageLink.class, FolderImageLink.class, FolderRoiLink.class, (Object[])new Class[0]);
            this.userFromId = Chown2I.this.helper.getEventContext().getCurrentUserId();
            this.userTo = new Experimenter(Long.valueOf(Chown2I.this.userId), false);
            this.linksToChown = new HashSet<LinkDetails>();
            this.requiredAbilities = requiredAbilities;
        }

        @Override
        public void deleteInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            super.deleteInstances(className, ids);
            Chown2I.this.graphHelper.publishEventLog(Chown2I.this.applicationContext, "DELETE", className, ids);
        }

        @Override
        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            String update = "UPDATE " + className + " SET details.owner = :user WHERE id IN (:ids)";
            int count = this.session.createQuery(update).setParameter("user", (Object)this.userTo).setParameterList("ids", ids).executeUpdate();
            Chown2I.this.graphHelper.publishEventLog(Chown2I.this.applicationContext, "UPDATE", className, ids);
            if (count != ids.size()) {
                this.LOGGER.warn("not all the objects of type " + className + " could be processed");
            }
        }

        @Override
        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return this.requiredAbilities;
        }

        private boolean isDuplicationRisk(Class<? extends ILink> linkType) {
            for (Class riskType : this.UNIQUENESS_RISK_LINK_TYPES) {
                if (!riskType.isAssignableFrom(linkType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void assertMayProcess(String className, long objectId, Details details) throws ome.services.graphs.GraphException {
            Class<ILink> linkType;
            Class<?> actualClass;
            if (details.getOwner().getId() == Chown2I.this.userId) {
                return;
            }
            Long objectGroupId = details.getGroup().getId();
            if (Chown2I.this.acceptableGroupsFrom != null && !Chown2I.this.acceptableGroupsFrom.contains(objectGroupId)) {
                throw new ome.services.graphs.GraphException("user " + this.userFromId + " is not an owner of group " + objectGroupId);
            }
            if (Chown2I.this.acceptableGroupsTo != null && !Chown2I.this.acceptableGroupsTo.contains(objectGroupId)) {
                throw new ome.services.graphs.GraphException("user " + Chown2I.this.userId + " is not a member of group " + objectGroupId);
            }
            try {
                actualClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                this.LOGGER.error("could not look up model class " + className, (Throwable)cnfe);
                return;
            }
            if (ILink.class.isAssignableFrom(actualClass) && this.isDuplicationRisk(linkType = actualClass.asSubclass(ILink.class))) {
                Object[] parentChildIds = (Object[])this.session.createQuery("SELECT parent.id, child.id FROM " + className + " WHERE id = :id").setParameter("id", (Object)objectId).uniqueResult();
                Long parentId = (Long)parentChildIds[0];
                Long childId = (Long)parentChildIds[1];
                Long count = (Long)this.session.createQuery("SELECT COUNT(*) FROM " + className + " WHERE parent.id = :parent AND child.id = :child AND details.owner.id = :owner").setParameter("parent", (Object)parentId).setParameter("child", (Object)childId).setParameter("owner", (Object)Chown2I.this.userId).uniqueResult();
                if (count > 0L || !this.linksToChown.add(new LinkDetails(linkType, parentId, childId))) {
                    throw new ome.services.graphs.GraphException("would have user " + Chown2I.this.userId + " owning multiple identical links");
                }
            }
        }
    }

    private final class LinkDetails {
        private final Class<? extends ILink> linkType;
        private final long parentId;
        private final long childId;

        public LinkDetails(Class<? extends ILink> linkType, long parentId, long childId) {
            this.linkType = linkType;
            this.parentId = parentId;
            this.childId = childId;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof LinkDetails) {
                LinkDetails otherLink = (LinkDetails)other;
                return this.linkType == otherLink.linkType && this.parentId == otherLink.parentId && this.childId == otherLink.childId;
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{LinkDetails.class, this.linkType, this.parentId, this.childId});
        }
    }
}

