/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ManufacturerSpec
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturerSpec.class);
    private String manufacturer;
    private String model;
    private String serialNumber;
    private String lotNumber;

    public ManufacturerSpec() {
    }

    public ManufacturerSpec(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ManufacturerSpec(ManufacturerSpec orig) {
        this.manufacturer = orig.manufacturer;
        this.model = orig.model;
        this.serialNumber = orig.serialNumber;
        this.lotNumber = orig.lotNumber;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        if (element.hasAttribute("Manufacturer")) {
            this.setManufacturer(String.valueOf(element.getAttribute("Manufacturer")));
        }
        if (element.hasAttribute("Model")) {
            this.setModel(String.valueOf(element.getAttribute("Model")));
        }
        if (element.hasAttribute("SerialNumber")) {
            this.setSerialNumber(String.valueOf(element.getAttribute("SerialNumber")));
        }
        if (element.hasAttribute("LotNumber")) {
            this.setLotNumber(String.valueOf(element.getAttribute("LotNumber")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element ManufacturerSpec_element) {
        if (ManufacturerSpec_element == null) {
            ManufacturerSpec_element = document.createElementNS(NAMESPACE, "ManufacturerSpec");
        }
        super.asXMLElement(document, ManufacturerSpec_element);
        if (this.manufacturer != null) {
            ManufacturerSpec_element.setAttribute("Manufacturer", this.manufacturer);
        }
        if (this.model != null) {
            ManufacturerSpec_element.setAttribute("Model", this.model);
        }
        if (this.serialNumber != null) {
            ManufacturerSpec_element.setAttribute("SerialNumber", this.serialNumber);
        }
        if (this.lotNumber != null) {
            ManufacturerSpec_element.setAttribute("LotNumber", this.lotNumber);
        }
        return ManufacturerSpec_element;
    }
}

