/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutUtils;

public class PlateLayout
implements Layout {
    static final String DESCRIPTION = "Layout the plate.";
    private Set oldNodes;

    @Override
    public void doLayout() {
    }

    @Override
    public void visit(ImageNode node) {
    }

    @Override
    public void visit(ImageSet node) {
        if (node.getParentDisplay() != null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.oldNodes)) {
            Collection<ImageDisplay> nodes = node.getChildrenDisplay();
            Iterator<ImageDisplay> i = nodes.iterator();
            ArrayList<ImageDisplay> l = new ArrayList<ImageDisplay>();
            ArrayList<CellDisplay> col = new ArrayList<CellDisplay>();
            ArrayList<CellDisplay> row = new ArrayList<CellDisplay>();
            while (i.hasNext()) {
                ImageDisplay n = i.next();
                if (n instanceof CellDisplay) {
                    CellDisplay cell = (CellDisplay)n;
                    if (cell.getType() == 1) {
                        col.add(cell);
                        continue;
                    }
                    row.add(cell);
                    continue;
                }
                l.add(n);
            }
            Dimension maxDim = new Dimension(0, 0);
            for (ImageDisplay child : l) {
                WellSampleData wsd = (WellSampleData)child.getHierarchyObject();
                if (wsd.getId() < 0L) continue;
                maxDim = LayoutUtils.max(maxDim, child.getPreferredSize());
            }
            int height = 0;
            int width = 0;
            i = l.iterator();
            int h = 0;
            while (i.hasNext()) {
                WellSampleNode wsNode = (WellSampleNode)i.next();
                h = 0;
                int hh = 0;
                int r = wsNode.getLayedoutRow();
                int c = wsNode.getLayedoutColumn();
                Dimension d = wsNode.getPreferredSize();
                if (r > 0) {
                    h = wsNode.getTitleHeight();
                }
                if (wsNode.getTitleBarType() == 0) {
                    hh = h = wsNode.getTitleHeight();
                }
                wsNode.setBounds(width + c * maxDim.width, height + r * (maxDim.height + h) + hh, d.width, d.height);
            }
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getIndex() {
        return 3;
    }

    @Override
    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }

    @Override
    public void setImagesPerRow(int number) {
    }

    @Override
    public int getImagesPerRow() {
        return 0;
    }
}

