/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;

class SkipComputePanel
extends JPanel {
    private static final String TEXT_THUMBNAIL_GENERATION = "Thumbnail generation";
    private static final String TEXT_MIN_MAX_COMPUTE = "Min/max calculation";
    private static final String TEXT_CHECKSUM_CHECKING = "Checksum verification";
    private static final String TEXT_TOOLTIP_THUMBNAIL_SKIP = "Skip generation of thumbnails\nThumbnails will usually be generated when accessing the images post-import via the OMERO clients.";
    private static final String TEXT_TOOLTIP_MIN_MAX_SKIP = "Skip calculation of the minima and maxima pixel values\nThis option will also skip the calculation of the pixels checksum. Recalculating minima and maxima pixel values post-import is currently not supported. See Calculation of minima and maxima pixel values for more information.";
    private static final String TEXT_TOOLTIP_CHECKSUM_SKIP = "Skip checksum calculation on image files before and after transfer\nThis option effectively sets the --checksum_algorithm to use a fast algorithm, File-Size-64, that considers only file size, not the actual file contents.";
    private static final String TEXT_TOOLTIP_UPGRADE_SKIP = "Skip upgrade check for Bio-Formats";
    private JCheckBox thumbGenCheckbox;
    private JCheckBox minMaxCheckBox;
    private JCheckBox checksumCheckBox;
    private Map<String, Object> choices = new HashMap<String, Object>();

    public SkipComputePanel() {
        super(new GridLayout(0, 1));
        this.thumbGenCheckbox = new JCheckBox(TEXT_THUMBNAIL_GENERATION);
        this.thumbGenCheckbox.setToolTipText(TEXT_TOOLTIP_THUMBNAIL_SKIP);
        this.thumbGenCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean doThumbnails = !SkipComputePanel.this.thumbGenCheckbox.isSelected();
                SkipComputePanel.this.choices.put(ImportableObject.OPTION_THUMBNAILS, doThumbnails);
            }
        });
        this.thumbGenCheckbox.setSelected(false);
        this.minMaxCheckBox = new JCheckBox(TEXT_MIN_MAX_COMPUTE);
        this.minMaxCheckBox.setToolTipText(TEXT_TOOLTIP_MIN_MAX_SKIP);
        this.minMaxCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SkipComputePanel.this.choices.put(ImportableObject.OPTION_SKIP_MINMAX, SkipComputePanel.this.minMaxCheckBox.isSelected());
            }
        });
        this.minMaxCheckBox.setSelected(false);
        this.checksumCheckBox = new JCheckBox(TEXT_CHECKSUM_CHECKING);
        this.checksumCheckBox.setToolTipText(TEXT_TOOLTIP_CHECKSUM_SKIP);
        this.checksumCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SkipComputePanel.this.checksumCheckBox.isSelected()) {
                    SkipComputePanel.this.choices.put(ImportableObject.OPTION_CHECKSUMS, "File-Size-64");
                } else {
                    SkipComputePanel.this.choices.put(ImportableObject.OPTION_CHECKSUMS, "SHA1-160");
                }
            }
        });
        this.checksumCheckBox.setSelected(false);
        this.add(this.thumbGenCheckbox);
        this.add(this.minMaxCheckBox);
        this.add(this.checksumCheckBox);
    }

    public Map<String, Object> getChoices() {
        return this.choices;
    }
}

