/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import ome.xml.model.Arc;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.GenericExcitationSource;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OME;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEParser;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ArcConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ChannelConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DetectorConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DichroicConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ExperimentConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilamentConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilterConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.GenericExcitationSourceConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ImageConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ImagingEnvConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LEDConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LaserConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ObjectiveConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.model.xml.Channel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.model.xml.DetectorSettings;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.redesign.ObjectTable;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.DynamicModuleTree;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleContentGUI;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleTree;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class MDEContent
extends JPanel
implements TreeSelectionListener,
ItemListener {
    private DynamicModuleTree moduleTree;
    private JPanel moduleContentPanel;
    private ModuleController controller;
    private ModuleList fileInstrumentValues;
    private LinkedHashMap<String, ObjectTable> hardwareTables;
    private DefaultMutableTreeNode fileObjectTree;

    public MDEContent(OME ome, DefaultMutableTreeNode root, ModuleController controller, ActionListener listener) {
        super(new BorderLayout());
        this.controller = controller;
        if (ome != null) {
            this.moduleTree = new DynamicModuleTree(this.initTree(ome, root), listener);
            this.createInstrumentTables(this.fileInstrumentValues);
            this.moduleContentPanel = new JPanel(new BorderLayout());
            JScrollPane scrollView = new JScrollPane(this.moduleContentPanel);
            JSplitPane splitPane = new JSplitPane(1, this.moduleTree, scrollView);
            splitPane.setResizeWeight(0.5);
            splitPane.setDividerLocation(150);
            this.add((Component)splitPane, "Center");
            this.selectModuleAction(this.moduleTree.selectFirstNode());
            this.moduleTree.addTreeSelectionListener(this);
            this.fileObjectTree = ModuleTree.cloneTreeNode(this.getRootNode());
        } else {
            this.add((Component)new JLabel("\tNot a valid microscopy file format!"), "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public MDEContent(DefaultMutableTreeNode root, ModuleController controller, boolean isDir, ModuleList instrumentList, ActionListener listener) {
        super(new BorderLayout());
        this.controller = controller;
        this.fileInstrumentValues = instrumentList;
        this.createInstrumentTables(instrumentList);
        this.moduleTree = root == null ? new DynamicModuleTree(listener) : new DynamicModuleTree(root, listener);
        this.moduleContentPanel = new JPanel(new BorderLayout());
        JScrollPane scrollView = new JScrollPane(this.moduleContentPanel);
        JSplitPane splitPane = new JSplitPane(1, this.moduleTree, scrollView);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(150);
        this.add((Component)splitPane, "Center");
        this.selectModuleAction(this.moduleTree.selectFirstNode());
        this.moduleTree.addTreeSelectionListener(this);
        this.revalidate();
        this.repaint();
    }

    private void selectModuleAction(DefaultMutableTreeNode object) {
        if (object != null) {
            this.showModuleContent(object);
        }
    }

    private void showModuleContent(DefaultMutableTreeNode object) {
        this.moduleContentPanel.removeAll();
        this.moduleContentPanel.add((Component)new ModuleContentGUI(object, this.hardwareTables, this.controller.shouldFilterRequired()), "Center");
        this.moduleContentPanel.revalidate();
        this.moduleContentPanel.repaint();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selectedNode = this.moduleTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        try {
            this.selectModuleAction(selectedNode);
        }
        catch (Exception ex) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] module tree selection event: select root node?");
        }
    }

    public DefaultMutableTreeNode getInitialFileObjectRootNode() {
        return this.fileObjectTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        if (this.moduleTree == null) {
            return null;
        }
        return this.moduleTree.getRootNode();
    }

    public ModuleTree getModuleTree() {
        if (this.moduleTree == null) {
            return null;
        }
        return this.moduleTree.getModuleTree();
    }

    private DefaultMutableTreeNode initTree(OME ome, DefaultMutableTreeNode root) {
        if (ome == null) {
            return this.controller.getTree();
        }
        if (root == null) {
            root = this.controller.getTree();
        }
        for (int i = 0; i < ome.sizeOfImageList(); ++i) {
            root = this.initImageContent(root, ome, i);
        }
        Experiment exp = null;
        Experimenter exper = null;
        if (ome.copyExperimentList() != null && ome.copyExperimentList().size() > 0) {
            exp = ome.getExperiment(0);
        }
        if (ome.copyExperimenterList() != null && ome.copyExperimenterList().size() > 0) {
            exper = ome.getExperimenter(0);
        }
        this.addContent(this.createContent("OME:Experiment", new ExperimentConverter().convertData(exp, exper)), 0, root);
        return root;
    }

    public ModuleContent createContent(String type, LinkedHashMap<String, TagData> data) {
        ModuleContent content = this.controller.getContentOfType(type);
        if (content != null) {
            content.setAttributes(data);
        }
        return content;
    }

    public DefaultMutableTreeNode addContent(ModuleContent c, int index, DefaultMutableTreeNode parent) {
        if (parent == null) {
            return null;
        }
        if (c == null) {
            return null;
        }
        List<DefaultMutableTreeNode> childs = MDEHelper.getListOfChilds(c.getType(), parent);
        DefaultMutableTreeNode node = null;
        if (childs != null && !childs.isEmpty()) {
            if (childs.size() <= index) {
                DefaultMutableTreeNode newChild = this.controller.cloneTreeStructure(childs.get(0), parent);
                parent.add(newChild);
                childs.add(index, newChild);
            }
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Add content: " + c.getType());
            node = childs.get(index);
            ModuleContent newC = MDEHelper.completeData(((ModuleTreeElement)node.getUserObject()).getData(), c);
            ((ModuleTreeElement)node.getUserObject()).setData(newC);
        } else {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Can't add content! No child nodes of given type " + c.getType() + " at " + parent.getUserObject().toString());
        }
        return node;
    }

    private DefaultMutableTreeNode initImageContent(DefaultMutableTreeNode tree, OME ome, int i) {
        if (ome.getImage(i) == null) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] image content is empty");
            return tree;
        }
        if (tree == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] No tree is given to init image content");
            return null;
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Read file content of index: " + i);
        List objList = null;
        List detectorList = null;
        List lightSourceList = null;
        List filterList = null;
        List dichList = null;
        Object chList = null;
        Object filtersetList = null;
        Image imgObj = ome.getImage(i);
        Instrument instruments = imgObj.getLinkedInstrument();
        if (instruments == null) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] no instruments are defined for image");
        } else {
            objList = instruments.copyObjectiveList();
            detectorList = instruments.copyDetectorList();
            lightSourceList = instruments.copyLightSourceList();
            filterList = instruments.copyFilterList();
            dichList = instruments.copyDichroicList();
            ModuleList hardwareList = new ModuleList();
            hardwareList.put("OME:Objective", MDEParser.parseObjectiveList(objList, this.controller));
            hardwareList.put("OME:Detector", MDEParser.parseDetectorList(detectorList, this.controller));
            hardwareList.put("OME:Laser", MDEParser.parseLightSourceLaser(lightSourceList, this.controller));
            hardwareList.put("OME:Filament", MDEParser.parseLightSourceFilament(lightSourceList, this.controller));
            hardwareList.put("OME:Arc", MDEParser.parseLightSourceArc(lightSourceList, this.controller));
            hardwareList.put("OME:LightEmittingDiode", MDEParser.parseLightSourceLED(lightSourceList, this.controller));
            hardwareList.put("OME:Generic_Excitation_Src", MDEParser.parseLightSourceGES(lightSourceList, this.controller));
            hardwareList.put("OME:Filter", MDEParser.parseFilterList(filterList, this.controller));
            hardwareList.put("OME:Dichroic", MDEParser.parseDichroicList(dichList, this.controller));
            this.fileInstrumentValues = hardwareList;
        }
        DefaultMutableTreeNode currentNode = null;
        currentNode = this.addContent(this.createContent("OME:Image", new ImageConverter().convertData(imgObj)), i, tree);
        ObjectiveSettings os = imgObj.getObjectiveSettings();
        String id = os == null ? "" : os.getID();
        Objective o = (Objective)this.getElementByID(objList, id);
        String oName = o != null ? o.getModel() : null;
        this.addContent(this.createContent("OME:Objective", new ObjectiveConverter().convertData(o, os)), 0, currentNode);
        this.addContent(this.createContent("OME:ImagingEnvironment", new ImagingEnvConverter().convertData(null)), 0, currentNode);
        DefaultMutableTreeNode chNode = null;
        int idx = 0;
        for (ome.xml.model.Channel c : imgObj.getPixels().copyChannelList()) {
            String lSrcName;
            chNode = this.addContent(this.createContent("OME:Channel", new ChannelConverter().convertData(new Channel(c))), idx, currentNode);
            ome.xml.model.DetectorSettings ds = c.getDetectorSettings();
            String idDs = ds == null ? "" : ds.getID();
            Detector d = (Detector)this.getElementByID(detectorList, idDs);
            DetectorSettings dsNew = ds == null ? null : new DetectorSettings(ds);
            String dName = d != null ? d.getModel() : null;
            this.addContent(this.createContent("OME:Detector", new DetectorConverter().convertData(d, dsNew)), 0, chNode);
            LightSourceSettings ls = c.getLightSourceSettings();
            String idLs = ls == null ? "" : ls.getID();
            LightSource l = (LightSource)this.getElementByID(lightSourceList, idLs);
            String string = lSrcName = l != null ? l.getModel() : null;
            if (l != null) {
                DefaultMutableTreeNode lSrcNode = this.addContent(this.controller.getContentOfType("OME:LightSource"), 0, chNode);
                if (l instanceof Laser) {
                    this.addContent(this.createContent("OME:Laser", new LaserConverter().convertData((Laser)l, ls)), 0, lSrcNode);
                } else if (l instanceof Arc) {
                    this.addContent(this.createContent("OME:Arc", new ArcConverter().convertData((Arc)l, ls)), 0, lSrcNode);
                } else if (l instanceof Filament) {
                    this.addContent(this.createContent("OME:Filament", new FilamentConverter().convertData((Filament)l, ls)), 0, lSrcNode);
                } else if (l instanceof LightEmittingDiode) {
                    this.addContent(this.createContent("OME:LightEmittingDiode", new LEDConverter().convertData((LightEmittingDiode)l, ls)), 0, lSrcNode);
                } else if (l instanceof GenericExcitationSource) {
                    this.addContent(this.createContent("OME:Generic_Excitation_Src", new GenericExcitationSourceConverter().convertData((GenericExcitationSource)l, ls)), 0, lSrcNode);
                }
            }
            LightPath lp = c.getLightPath();
            FilterSet fs = c.getLinkedFilterSet();
            if (lp != null) {
                Dichroic dich;
                DefaultMutableTreeNode lpNode = this.addContent(this.controller.getContentOfType("OME:LightPath"), 0, chNode);
                if (lp.sizeOfLinkedExcitationFilterList() > 0) {
                    this.createNode("OME:ExcitationFilter", lp.copyLinkedExcitationFilterList(), filterList, lpNode);
                }
                if ((dich = lp.getLinkedDichroic()) != null) {
                    this.addContent(this.createContent("OME:Dichroic", new DichroicConverter().convertData(dich)), 0, lpNode);
                }
                if (lp.sizeOfLinkedEmissionFilterList() > 0) {
                    this.createNode("OME:ExcitationFilter", lp.copyLinkedEmissionFilterList(), filterList, lpNode);
                }
            }
            if (fs != null) {
                // empty if block
            }
            ++idx;
        }
        return tree;
    }

    private <T extends ManufacturerSpec> T getElementByID(List<T> list, String id) {
        int result = -1;
        if (id == null || list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!this.getElementID((ManufacturerSpec)list.get(i)).equals(id)) continue;
            result = i;
            break;
        }
        if (result != -1) {
            return (T)((ManufacturerSpec)list.get(result));
        }
        if (list.size() == 1) {
            return (T)((ManufacturerSpec)list.get(0));
        }
        return null;
    }

    private <T extends ManufacturerSpec> String getElementID(T object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Objective) {
            return ((Objective)object).getID();
        }
        if (object instanceof Detector) {
            return ((Detector)object).getID();
        }
        if (object instanceof LightSource) {
            return ((LightSource)object).getID();
        }
        return "";
    }

    private DefaultMutableTreeNode createNode(String type, List<Filter> reflist, List<Filter> filterList, DefaultMutableTreeNode p) {
        DefaultMutableTreeNode listNode = this.addContent(this.controller.getContentOfType(type), 0, p);
        int idx = 0;
        for (Filter f : reflist) {
            String thisType = "OME:Filter";
            ModuleContent content = this.controller.getContentOfType(thisType);
            if (content != null) {
                content.setAttributes(new FilterConverter().convertData(f));
            }
            this.addContent(content, idx, listNode);
            ++idx;
        }
        return listNode;
    }

    public void setInstrumentList(ModuleList list) {
        this.fileInstrumentValues = list;
    }

    public ModuleList getInstrumentList() {
        return this.fileInstrumentValues;
    }

    private void createInstrumentTables(ModuleList fileInstruments) {
        String key;
        if (this.hardwareTables == null) {
            this.hardwareTables = new LinkedHashMap();
        } else {
            this.hardwareTables.clear();
        }
        ModuleList mList = this.controller.getInstrumentsForCurrentMic();
        ArrayList<String> keyInUseList = new ArrayList<String>();
        if (fileInstruments != null) {
            for (Map.Entry entry : fileInstruments.entrySet()) {
                List values;
                key = (String)entry.getKey();
                ArrayList<ModuleContent> hardware = new ArrayList<ModuleContent>();
                List valFile = (List)entry.getValue();
                ObjectTable objTable = null;
                if (valFile != null) {
                    hardware.addAll(valFile);
                }
                if (mList != null && (values = (List)mList.get(key)) != null) {
                    hardware.addAll(values);
                    keyInUseList.add(key);
                }
                objTable = new ObjectTable(hardware);
                this.hardwareTables.put(key, objTable);
            }
        }
        if (mList != null) {
            for (Map.Entry entry : mList.entrySet()) {
                key = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (keyInUseList.contains(key) || values == null) continue;
                this.hardwareTables.put(key, new ObjectTable(values));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.controller.setFilterRequired(true);
        } else {
            this.controller.setFilterRequired(false);
        }
        DefaultMutableTreeNode selectedNode = this.moduleTree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        try {
            this.selectModuleAction(selectedNode);
        }
        catch (Exception ex) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Filter required failed");
        }
    }
}

