/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.units.quantity.ElectricPotential;
import ome.units.unit.Unit;
import ome.xml.model.Detector;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.EnumerationException;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.model.xml.DetectorSettings;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class DetectorConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        labelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPane.add(label);
        IconManager icons = IconManager.getInstance();
        JButton applyBtn = new JButton(icons.getIcon(73));
        applyBtn.setToolTipText("Apply table selection");
        applyBtn.setAlignmentX(1.0f);
        applyBtn.setActionCommand(String.valueOf(index));
        if (listeners != null && listeners.size() > 0) {
            applyBtn.addActionListener(listeners.get(0));
        }
        labelPane.add(applyBtn);
        return labelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Detector detector, DetectorSettings settings) {
        this.tagMap = new LinkedHashMap();
        if (detector != null) {
            try {
                this.tagMap.put("ID", this.convertID(detector.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(detector.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(detector.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
            try {
                this.tagMap.put("DetectorType", this.convertType(detector.getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("DetectorType", this.convertType(null, true));
            }
            try {
                this.tagMap.put("Zoom", this.convertZoom(detector.getZoom(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Zoom", this.convertZoom(null, true));
            }
            try {
                this.tagMap.put("AmplificationGain", this.convertAmplGain(detector.getAmplificationGain(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("AmplificationGain", this.convertAmplGain(null, true));
            }
            try {
                this.tagMap.put("User::Voltage", this.convertVoltage(detector.getVoltage(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Voltage", this.convertVoltage(null, true));
            }
            try {
                this.tagMap.put("User::Offset", this.convertOffset(detector.getOffset(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Offset", this.convertOffset(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            this.tagMap.put("DetectorType", this.convertType(null, true));
            this.tagMap.put("Zoom", this.convertZoom(null, true));
            this.tagMap.put("AmplificationGain", this.convertAmplGain(null, true));
            this.tagMap.put("User::Voltage", this.convertVoltage(null, true));
            this.tagMap.put("User::Offset", this.convertOffset(null, true));
        }
        if (settings != null) {
            try {
                this.tagMap.put("User::Gain", this.convertGain(settings.getGain(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Gain", this.convertGain(null, true));
            }
            try {
                this.tagMap.put("User::Voltage", this.convertVoltage(settings.getVoltage(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Voltage", this.convertVoltage(null, true));
            }
            try {
                this.tagMap.put("User::Offset", this.convertOffset(settings.getOffset(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Offset", this.convertOffset(null, true));
            }
            try {
                this.tagMap.put("User::Confocal Zoom", this.convertConfocalZoom(settings.getZoom(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Confocal Zoom", this.convertConfocalZoom(null, true));
            }
            try {
                this.tagMap.put("User::Binning", this.convertBinning(settings.getBinning(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Binning", this.convertBinning(null, true));
            }
            try {
                this.tagMap.put("User::Subarray", this.convertSubarray(settings.getSubarray(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Subarray", this.convertSubarray(null, true));
            }
        } else {
            this.tagMap.put("User::Gain", this.convertGain(null, true));
            this.tagMap.put("User::Voltage", this.convertVoltage(null, true));
            this.tagMap.put("User::Offset", this.convertOffset(null, true));
            this.tagMap.put("User::Confocal Zoom", this.convertConfocalZoom(null, true));
            this.tagMap.put("User::Binning", this.convertBinning(null, true));
            this.tagMap.put("User::Subarray", this.convertSubarray(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Detector", "ID", value, prop, "TextField");
    }

    public TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Detector", "Model", value, prop, "TextField");
    }

    public TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Detector", "Manufacturer", value, prop, "TextField");
    }

    public TagData convertType(DetectorType value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        TagData t = new TagData("OME:Detector", "DetectorType", val, prop, "ComboBox", OMEValueConverter.getNames(DetectorType.class));
        t.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        return t;
    }

    public TagData convertAmplGain(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Detector", "AmplificationGain", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertZoom(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Detector", "Zoom", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertGain(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Detector", "User::Gain", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertBinning(Binning value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Detector", "User::Binning", val, prop, "ComboBox", OMEValueConverter.getNames(Binning.class));
    }

    public TagData convertVoltage(ElectricPotential value, boolean prop) {
        ome.model.units.ElectricPotential val = null;
        if (value != null) {
            val = new ome.model.units.ElectricPotential(value);
        }
        return new TagData("OME:Detector", "User::Voltage", (ome.model.units.Unit)val, ome.model.units.ElectricPotential.class, prop, "TextField");
    }

    public TagData convertOffset(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Detector", "User::Offset", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertConfocalZoom(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Detector", "User::Confocal Zoom", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertSubarray(String value, boolean prop) {
        return new TagData("OME:Detector", "User::Subarray", value, prop, "TextField");
    }

    private static ElectricPotential parseElectricPotential(String c, Unit unit) throws Exception {
        if (c == null || c.equals("")) {
            return null;
        }
        Object p = null;
        return new ElectricPotential((Number)Double.valueOf(c), unit);
    }

    private static Binning parseBinning(String c) throws EnumerationException {
        if (c == null || c.equals("")) {
            return null;
        }
        return Binning.fromString((String)c);
    }
}

