/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ImportStatus;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.RotationIcon;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

abstract class ImporterUIElement
extends ClosableTabbedPaneComponent
implements PropertyChangeListener {
    static final String DESCRIPTION = "Closing will cancel imports that have not yet started.";
    static final String SHOW_FAILURE = "Show Failed";
    static final String SHOW_ALL = "Show All";
    private static final double[] COLUMNS = new double[]{-1.0};
    private static final Dimension ICON_SIZE = new Dimension(16, 16);
    private static final Icon IMPORT_SUCCESS;
    private static final Icon IMPORT_FAIL;
    private static final Icon IMPORT_PARTIAL;
    static final String MESSAGE;
    ImportableObject object;
    LinkedHashMap<String, FileImportComponentI> components;
    int countUploaded;
    int countImported;
    int countUploadFailure;
    int countFailure;
    HashSet<FileImportComponentI> cancelledComponents = new HashSet();
    int totalToImport;
    private long sizeImport;
    JButton filterButton;
    private JLabel sizeLabel;
    private JLabel numberOfImportLabel;
    private JLabel reportLabel;
    private JLabel importSizeLabel;
    int id;
    private Map<JLabel, Object> foldersName;
    ImporterUI view;
    ImporterControl controller;
    ImporterModel model;
    private FileImportComponentI.ContainerType type;
    private List<DataObject> existingContainers;
    private JXBusyLabel busyLabel;
    private RotationIcon rotationIcon;
    private boolean uploadStarted;
    private boolean offlineCompleted;

    private boolean handleOfflineImportOutcome(FileImportComponentI fc, Object result) {
        if (ImporterAgent.isOfflineImport()) {
            this.offlineCompleted = true;
            this.countUploadFailure = 0;
            if (result instanceof Exception) {
                this.countFailure = this.totalToImport;
                this.countUploaded = 0;
                this.countImported = 0;
                fc.propagateOfflineImportFailureStatus((Exception)result);
            } else {
                this.countFailure = 0;
                this.countUploaded = this.totalToImport;
                this.countImported = this.totalToImport;
                fc.propagateSuccessfulOfflineImportStatus();
            }
            this.setNumberOfImport();
            this.setClosable(true);
            if (this.rotationIcon != null) {
                this.rotationIcon.stopRotation();
            }
            return true;
        }
        return false;
    }

    private DataObject getObjectFromID(DataObject data, Collection result) {
        for (DataObject object : result) {
            if (!object.getClass().equals(data.getClass()) || object.getId() != data.getId()) continue;
            return object;
        }
        return null;
    }

    private DataObject getObject(DataObject data, Collection result) {
        String name = "";
        if (data instanceof ProjectData) {
            name = ((ProjectData)data).getName();
        } else if (data instanceof ScreenData) {
            name = ((ScreenData)data).getName();
        } else if (data instanceof DatasetData) {
            name = ((DatasetData)data).getName();
        }
        Iterator i = result.iterator();
        String n = "";
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            if (!object.getClass().equals(data.getClass())) continue;
            if (object instanceof ProjectData) {
                n = ((ProjectData)object).getName();
            } else if (object instanceof ScreenData) {
                n = ((ScreenData)object).getName();
            } else if (object instanceof DatasetData) {
                n = ((DatasetData)object).getName();
            }
            if (!n.equals(name)) continue;
            return object;
        }
        return null;
    }

    abstract void showFailures();

    abstract FileImportComponentI buildComponent(ImportableFile var1, boolean var2, boolean var3, int var4, Collection<TagAnnotationData> var5);

    private void initialize() {
        Iterator<Object> j;
        this.sizeImport = 0L;
        this.busyLabel = new JXBusyLabel(ICON_SIZE);
        this.numberOfImportLabel = UIUtilities.createComponent(null);
        this.foldersName = new LinkedHashMap<JLabel, Object>();
        this.countUploadFailure = 0;
        this.countFailure = 0;
        this.countUploaded = 0;
        this.addPropertyChangeListener(this.controller);
        this.components = new LinkedHashMap();
        List<ImportableFile> files = this.object.getFiles();
        Iterator<ImportableFile> i = files.iterator();
        this.type = FileImportComponentI.ContainerType.NA;
        List<Object> containers = this.object.getRefNodes();
        if (containers != null && containers.size() > 0 && (j = containers.iterator()).hasNext()) {
            TreeImageDisplay node = (TreeImageDisplay)j.next();
            Object h = node.getUserObject();
            if (h instanceof DatasetData) {
                this.type = FileImportComponentI.ContainerType.DATASET;
            } else if (h instanceof ScreenData) {
                this.type = FileImportComponentI.ContainerType.SCREEN;
            } else if (h instanceof ProjectData) {
                this.type = FileImportComponentI.ContainerType.PROJECT;
            }
        }
        boolean single = this.model.isSingleGroup();
        while (i.hasNext()) {
            JLabel l;
            ImportableFile importable = i.next();
            FileObject f = importable.getFile();
            FileImportComponentI c = this.buildComponent(importable, !this.controller.isMaster(), single, this.getID(), this.object.getTags());
            c.setType(this.type);
            c.addPropertyChangeListener(this.controller);
            c.addPropertyChangeListener(this);
            if (f.isDirectory()) {
                if (importable.isFolderAsContainer()) {
                    l = new JLabel(f.getName());
                    this.foldersName.put(l, c);
                }
            } else if (importable.isFolderAsContainer()) {
                String name = f.getParentName();
                Iterator<Map.Entry<JLabel, Object>> k = this.foldersName.entrySet().iterator();
                boolean exist = false;
                while (k.hasNext()) {
                    Map.Entry<JLabel, Object> entry = k.next();
                    l = entry.getKey();
                    if (!l.getText().equals(name)) continue;
                    exist = true;
                    break;
                }
                if (name == null) {
                    name = f.getName();
                }
                if (!exist) {
                    this.foldersName.put(new JLabel(name), c);
                }
            }
            importable.setStatus(c.getStatus());
            this.components.put(c.toString(), c);
        }
        this.totalToImport = files.size();
    }

    void downloadLogFile(long logFileID) {
        if (logFileID < 0L) {
            return;
        }
        Environment env = (Environment)ImporterAgent.getRegistry().lookup("/env");
        String path = env.getOmeroFilesHome();
        File f = new File(path, "importLog_" + logFileID);
        DownloadAndLaunchActivityParam activity = new DownloadAndLaunchActivityParam(logFileID, 0, f, null);
        activity.setUIRegister(false);
        UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.model.getSecurityContext(), activity);
    }

    private JPanel createRow() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private void makeLabelStyle(JTextArea textArea) {
        if (textArea == null) {
            return;
        }
        textArea.setEditable(false);
        textArea.setCursor(null);
        textArea.setOpaque(false);
        textArea.setFocusable(false);
    }

    ImporterUIElement(ImporterControl controller, ImporterModel model, ImporterUI view, int id, int index, String name, ImportableObject object) {
        super(index, name, DESCRIPTION);
        if (object == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No Control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No View.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.id = id;
        this.object = object;
        this.initialize();
    }

    void setNumberOfImport() {
        StringBuffer buffer = new StringBuffer();
        int n = this.countUploaded - this.countUploadFailure;
        buffer.append(n);
        buffer.append(" out of ");
        buffer.append(this.totalToImport);
        buffer.append(" uploaded");
        this.numberOfImportLabel.setText(buffer.toString());
    }

    JPanel buildHeader() {
        this.sizeLabel = UIUtilities.createComponent(null);
        this.sizeLabel.setText(FileUtils.byteCountToDisplaySize((long)this.sizeImport));
        this.reportLabel = UIUtilities.setTextFont("Report:", 1);
        this.importSizeLabel = UIUtilities.setTextFont("Import Size:", 1);
        this.numberOfImportLabel = UIUtilities.createComponent(null);
        this.filterButton = new JButton(SHOW_FAILURE);
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImporterUIElement.this.showFailures();
            }
        });
        double[][] design = new double[][]{{-2.0}, {-2.0, -2.0}};
        TableLayout layout = new TableLayout((double[][])design);
        JPanel detailsPanel = new JPanel((LayoutManager)layout);
        detailsPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel p = this.createRow();
        p.add(this.reportLabel);
        p.add(this.numberOfImportLabel);
        detailsPanel.add((Component)p, "0, 0");
        p = this.createRow();
        p.add(this.importSizeLabel);
        p.add(this.sizeLabel);
        detailsPanel.add((Component)p, "0, 1");
        JPanel middlePanel = new JPanel();
        middlePanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        middlePanel.add(this.filterButton);
        JTextArea description = new JTextArea(MESSAGE);
        this.makeLabelStyle(description);
        description.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        descriptionPanel.add(description);
        JPanel header = new JPanel();
        header.setBackground(UIUtilities.BACKGROUND_COLOR);
        header.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        header.setLayout(new BorderLayout());
        header.add(Box.createVerticalStrut(10), "North");
        header.add((Component)detailsPanel, "West");
        header.add((Component)middlePanel, "Center");
        header.add((Component)descriptionPanel, "East");
        header.add(Box.createVerticalStrut(10), "South");
        return header;
    }

    int getID() {
        return this.id;
    }

    Object getFormattedResult(ImportableFile f) {
        FileImportComponentI c = this.components.get(f.toString());
        if (c == null) {
            return null;
        }
        ImportErrorObject object = c.getImportErrorObject();
        if (object != null) {
            return object;
        }
        return null;
    }

    Object uploadComplete(ImportableFile f, Object result) {
        FileImportComponentI c = this.components.get(f.toString());
        return this.uploadComplete(c, result);
    }

    Object uploadComplete(FileImportComponentI c, Object result) {
        Boolean b;
        if (c == null) {
            return null;
        }
        c.uploadComplete(result);
        FileObject file = c.getFile();
        if (this.handleOfflineImportOutcome(c, result)) {
            return null;
        }
        ImportErrorObject r = null;
        if (file.isFile()) {
            ++this.countUploaded;
            this.sizeImport += c.getImportSize();
            this.sizeLabel.setText(FileUtils.byteCountToDisplaySize((long)this.sizeImport));
            if (result instanceof Exception) {
                r = new ImportErrorObject(file.getTrueFile(), (Exception)result, c.getGroupID());
                if (c.hasResult()) {
                    return null;
                }
                this.setImportResult(c, result);
            } else if (result instanceof Boolean) {
                Boolean b2 = (Boolean)result;
                if (!b2.booleanValue() && c.isCancelled()) {
                    --this.countUploaded;
                    if (this.isDone() && this.rotationIcon != null) {
                        this.rotationIcon.stopRotation();
                    }
                } else {
                    this.setImportResult(c, result);
                }
            } else if (c.isCancelled()) {
                if (result == null) {
                    ++this.countImported;
                    if (this.isDone() && this.rotationIcon != null) {
                        this.rotationIcon.stopRotation();
                    }
                } else {
                    --this.countUploaded;
                }
            }
        } else if (result instanceof Exception) {
            ++this.countUploaded;
            if (!c.hasComponents()) {
                ++this.countImported;
                ++this.countUploadFailure;
                c.setStatus(result);
            }
            if (this.isDone() && this.rotationIcon != null) {
                this.rotationIcon.stopRotation();
            }
        } else if (result instanceof Boolean && !(b = (Boolean)result).booleanValue() && c.isCancelled()) {
            ++this.countUploaded;
            ++this.countImported;
            if (this.isDone() && this.rotationIcon != null) {
                this.rotationIcon.stopRotation();
            }
        }
        this.setNumberOfImport();
        this.setClosable(this.isUploadComplete());
        return r;
    }

    void setImportResult(FileImportComponentI fc, Object result) {
        if (fc == null) {
            return;
        }
        FileObject file = fc.getFile();
        if (file.isFile()) {
            fc.setStatus(result);
            ++this.countImported;
            if (fc.isCancelled() && result != null && !(result instanceof Boolean)) {
                --this.countImported;
            }
            if (this.isDone() && this.rotationIcon != null) {
                this.rotationIcon.stopRotation();
            }
            if (fc.hasUploadFailed()) {
                ++this.countUploadFailure;
                this.sizeImport -= fc.getImportSize();
                this.sizeLabel.setText(FileUtils.byteCountToDisplaySize((long)this.sizeImport));
            }
            if (fc.hasImportFailed()) {
                ++this.countFailure;
            }
            this.setNumberOfImport();
            this.setClosable(this.isDone());
        } else if (result instanceof Exception) {
            fc.setStatus(result);
            ++this.countImported;
            ++this.countFailure;
            ++this.countUploadFailure;
            if (this.isDone() && this.rotationIcon != null) {
                this.rotationIcon.stopRotation();
            }
            this.setNumberOfImport();
            this.setClosable(this.isDone());
        }
    }

    boolean isUploadComplete() {
        if (ImporterAgent.isOfflineImport()) {
            return this.offlineCompleted;
        }
        return this.countUploaded + this.countUploadFailure + this.cancelled() >= this.totalToImport;
    }

    boolean isDone() {
        if (ImporterAgent.isOfflineImport()) {
            return this.offlineCompleted;
        }
        return this.countImported + this.cancelled() >= this.totalToImport;
    }

    Icon startImport(JComponent component) {
        SwingUtilities.invokeLater(() -> {
            this.uploadStarted = true;
            this.setClosable(false);
            this.busyLabel.setBusy(true);
            this.repaint();
        });
        return new RotationIcon(this.busyLabel.getIcon(), component, true);
    }

    boolean hasStarted() {
        return this.uploadStarted;
    }

    void setUploadStarted(boolean uploadStarted) {
        this.uploadStarted = uploadStarted;
    }

    boolean hasImportToCancel() {
        for (FileImportComponentI fic : this.components.values()) {
            if (!fic.hasImportToCancel()) continue;
            return true;
        }
        return false;
    }

    int cancelled() {
        return this.cancelledComponents.size();
    }

    List<FileImportComponentI> getMarkedFiles() {
        ArrayList<FileImportComponentI> list = new ArrayList<FileImportComponentI>();
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            List<FileImportComponentI> l = fc.getImportErrors();
            if (l == null || l.size() <= 0) continue;
            list.addAll(l);
        }
        return list;
    }

    List<FileImportComponentI> getFilesToReupload() {
        ArrayList<FileImportComponentI> list = new ArrayList<FileImportComponentI>();
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            List<FileImportComponentI> l = fc.getFilesToReupload();
            if (CollectionUtils.isEmpty(l)) continue;
            list.addAll(l);
        }
        return list;
    }

    ImportableObject getData() {
        return this.object;
    }

    List<DataObject> getExistingContainers() {
        if (this.existingContainers != null) {
            return this.existingContainers;
        }
        this.existingContainers = new ArrayList<DataObject>();
        Iterator<Map.Entry<String, FileImportComponentI>> i = this.components.entrySet().iterator();
        HashMap<Long, DatasetData> datasets = new HashMap<Long, DatasetData>();
        HashMap<Long, DataObject> projects = new HashMap<Long, DataObject>();
        HashMap<Long, DataObject> screens = new HashMap<Long, DataObject>();
        while (i.hasNext()) {
            DataObject object;
            Map.Entry<String, FileImportComponentI> entry = i.next();
            FileImportComponentI fc = entry.getValue();
            DatasetData d = fc.getDataset();
            if (d != null && d.getId() > 0L) {
                datasets.put(d.getId(), d);
            }
            if ((object = fc.getDataObject()) instanceof ScreenData && object.getId() > 0L) {
                screens.put(object.getId(), object);
            }
            if (!(object instanceof ProjectData) || object.getId() <= 0L || d == null || d.getId() > 0L) continue;
            projects.put(object.getId(), object);
        }
        this.existingContainers.addAll(datasets.values());
        this.existingContainers.addAll(projects.values());
        this.existingContainers.addAll(screens.values());
        return this.existingContainers;
    }

    void setImportLogFile(Collection<FileAnnotationData> data, long id) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        block0: for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            if ((long)fc.getIndex() != id) continue;
            for (FileAnnotationData fa : data) {
                if (!"openmicroscopy.org/omero/import/logFile".equals(fa.getNameSpace())) continue;
                this.downloadLogFile(fa.getFileID());
                continue block0;
            }
        }
    }

    boolean hasFailuresToSend() {
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            if (!fc.hasFailuresToSend()) continue;
            return true;
        }
        return false;
    }

    boolean hasFailuresToReimport() {
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            if (!fc.hasFailuresToReimport()) continue;
            return true;
        }
        return false;
    }

    boolean hasFailuresToReupload() {
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            if (!fc.hasFailuresToReupload()) continue;
            return true;
        }
        return false;
    }

    void cancelLoading() {
        if (this.components == null || this.components.size() == 0) {
            return;
        }
        Iterator<FileImportComponentI> i = this.components.values().iterator();
        while (i.hasNext()) {
            i.next().cancelLoading();
        }
    }

    boolean hasToRefreshTree() {
        if (this.components == null || this.components.size() == 0) {
            return false;
        }
        for (Map.Entry<String, FileImportComponentI> entry : this.components.entrySet()) {
            FileImportComponentI fc = entry.getValue();
            if (!fc.hasToRefreshTree()) continue;
            return true;
        }
        return false;
    }

    Icon getImportIcon() {
        if (this.isDone()) {
            if (ImporterAgent.isOfflineImport()) {
                return this.countFailure > 0 ? IMPORT_FAIL : IMPORT_SUCCESS;
            }
            Iterator<Map.Entry<String, FileImportComponentI>> i = this.components.entrySet().iterator();
            int failure = 0;
            while (i.hasNext()) {
                Map.Entry<String, FileImportComponentI> entry = i.next();
                FileImportComponentI fc = entry.getValue();
                ImportStatus v = fc.getImportStatus();
                if (v == ImportStatus.PARTIAL) {
                    return IMPORT_PARTIAL;
                }
                if (v != ImportStatus.FAILURE) continue;
                ++failure;
            }
            if (failure == this.components.size()) {
                return IMPORT_FAIL;
            }
            if (failure > 0) {
                return IMPORT_PARTIAL;
            }
            return IMPORT_SUCCESS;
        }
        return this.busyLabel.getIcon();
    }

    void onImportEnded() {
        SwingUtilities.invokeLater(() -> {
            this.busyLabel.setBusy(false);
            this.setClosable(true);
        });
    }

    void resetContainers(Collection result) {
        if (result == null || result.size() == 0) {
            return;
        }
        List<ImportableFile> files = this.getData().getFiles();
        if (files == null || files.size() == 0) {
            return;
        }
        for (ImportableFile f : files) {
            DatasetData r;
            DataObject parent = f.getParent();
            DatasetData dataset = f.getDataset();
            if (parent != null) {
                ProjectData p;
                DataObject data;
                if (parent.getId() <= 0L) {
                    data = this.getObject(parent, result);
                    r = null;
                    if (dataset != null && data != null && dataset.getId() <= 0L) {
                        r = dataset;
                        p = (ProjectData)data;
                        r = (DatasetData)this.getObject(dataset, p.getDatasets());
                    }
                    f.setLocation(data, r);
                    continue;
                }
                if (dataset == null || dataset.getId() > 0L) continue;
                data = this.getObjectFromID(parent, result);
                r = dataset;
                p = (ProjectData)data;
                if (p != null) {
                    r = (DatasetData)this.getObject(dataset, p.getDatasets());
                    f.setLocation(data, r);
                    continue;
                }
                f.setLocation(null, r);
                continue;
            }
            if (dataset == null || dataset.getId() > 0L) continue;
            r = dataset;
            r = (DatasetData)this.getObject(dataset, result);
            f.setLocation(null, r);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String name = propertyChangeEvent.getPropertyName();
        if ("cancelImport".equals(name)) {
            FileImportComponentI c = (FileImportComponentI)propertyChangeEvent.getNewValue();
            this.cancelledComponents.add(c);
            this.cancelledComponents.addAll(c.getChildren());
        } else if ("importFilesNumber".equals(name)) {
            Integer v = (Integer)propertyChangeEvent.getNewValue() - 1;
            this.totalToImport += v.intValue();
            this.setNumberOfImport();
        } else if ("cancelImport".equals(name)) {
            this.controller.cancel((FileImportComponentI)propertyChangeEvent.getNewValue());
        }
    }

    static {
        IconManager icons = IconManager.getInstance();
        IMPORT_SUCCESS = icons.getIcon(16);
        IMPORT_FAIL = icons.getIcon(10);
        IMPORT_PARTIAL = icons.getIcon(17);
        MESSAGE = "When upload is complete, the import" + CommonsLangUtils.LINE_SEPARATOR + "window and OMERO session can be closed." + CommonsLangUtils.LINE_SEPARATOR + "Reading will continue on the server.";
    }
}

