/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class RenderingDefinitionHistory {
    public static final String CAN_UNDO = "canUndo";
    public static final String CAN_REDO = "canRedo";
    private static final int PREV_ACTION_BACKWARD = 1;
    private static final int PREV_ACTION_FORWARD = 2;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List<RndProxyDef> history = new ArrayList<RndProxyDef>();
    private int pointer = -1;
    private int previousAction = 0;

    public void reset() {
        boolean oldU = this.canUndo();
        boolean oldR = this.canRedo();
        this.history.clear();
        this.pointer = -1;
        this.previousAction = 0;
        this.pcs.firePropertyChange(CAN_UNDO, oldU, this.canUndo());
        this.pcs.firePropertyChange(CAN_REDO, oldR, this.canRedo());
    }

    public RndProxyDef getCurrent() {
        if (this.history.isEmpty() || this.pointer < 0) {
            return null;
        }
        if (this.pointer >= this.history.size()) {
            throw new IllegalStateException("Pointer is not within the valid range: " + this.pointer + " [-1;" + (this.history.size() - 1) + "]");
        }
        return this.history.get(this.pointer);
    }

    public void add(RndProxyDef def) {
        boolean oldU = this.canUndo();
        boolean oldR = this.canRedo();
        if (!this.history.isEmpty() && this.pointer < this.history.size() - 1) {
            this.trim();
        }
        this.history.add(def);
        this.pointer = this.history.size() - 1;
        this.pcs.firePropertyChange(CAN_UNDO, oldU, this.canUndo());
        this.pcs.firePropertyChange(CAN_REDO, oldR, this.canRedo());
    }

    public void resetPrevAction() {
        this.previousAction = 0;
    }

    public RndProxyDef forward() {
        boolean oldU = this.canUndo();
        boolean oldR = this.canRedo();
        this.pointer = this.previousAction == 1 ? (this.pointer += 2) : ++this.pointer;
        this.pcs.firePropertyChange(CAN_UNDO, oldU, this.canUndo());
        this.pcs.firePropertyChange(CAN_REDO, oldR, this.canRedo());
        this.previousAction = 2;
        return this.getCurrent();
    }

    public RndProxyDef backward(RndProxyDef def) {
        if (def == null) {
            return this.backward();
        }
        boolean oldU = this.canUndo();
        boolean oldR = this.canRedo();
        if (!this.history.isEmpty() && this.pointer < this.history.size() - 1) {
            this.trim();
        }
        this.history.add(def);
        if (this.previousAction == 2) {
            --this.pointer;
        }
        RndProxyDef current = this.getCurrent();
        --this.pointer;
        this.pcs.firePropertyChange(CAN_UNDO, oldU, this.canUndo());
        this.pcs.firePropertyChange(CAN_REDO, oldR, this.canRedo());
        this.previousAction = 1;
        return current;
    }

    public RndProxyDef backward() {
        boolean oldU = this.canUndo();
        boolean oldR = this.canRedo();
        if (this.previousAction == 2) {
            --this.pointer;
        }
        RndProxyDef def = this.getCurrent();
        --this.pointer;
        this.pcs.firePropertyChange(CAN_UNDO, oldU, this.canUndo());
        this.pcs.firePropertyChange(CAN_REDO, oldR, this.canRedo());
        this.previousAction = 1;
        return def;
    }

    public boolean canUndo() {
        return !this.history.isEmpty() && this.pointer >= 0;
    }

    public boolean canRedo() {
        return !this.history.isEmpty() && this.pointer < this.history.size() - 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void trim() {
        this.history = this.history.subList(0, this.pointer + 1);
    }

    public String toString() {
        return "RenderingDefinitionHistory [history.size()=" + this.history.size() + ", historyPointer=" + this.pointer + ", previousAction=" + this.previousAction + "]";
    }
}

