/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.MoveToAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.TaskPaneBrowser;
import org.openmicroscopy.shoola.agents.treeviewer.view.ToolBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.JXTaskPaneContainerSingle;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

class TreeViewerWin
extends TopWindow {
    static final String VIEW_MENU = "View";
    static final String EDIT_MENU = "Edit";
    static final String CREATE_NEW_MENU = "Create New";
    static final String RENDERING_SETTINGS_MENU = "Rendering Settings";
    static final String JXTASKPANE_TYPE = "JXTaskPane";
    private static final double WEIGHT = 0.8;
    private static final String TITLE = "Data Manager";
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private JSplitPane splitPane;
    private JScrollPane workingPane;
    private JSplitPane rightPane;
    private JComponent browsersDisplay;
    private List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private ToolBar toolBar;
    private StatusBar statusBar;
    private Rectangle invokerBounds;
    private int displayMode;
    private JScrollPane finderScrollPane;
    private Component leftComponent;
    private Component rightComponent;
    private int dividerLocation;
    private boolean treeVisible;
    private boolean metadataVisible;
    private int dividerRightLocation;
    private JXTaskPane firstPane;
    private JXTaskPane searchPane;
    private JXTaskPaneContainerSingle container;
    private JSplitPane viewerPane;
    private PropertyChangeListener listener;

    private boolean isBrowserVisible(Browser browser) {
        Component[] comps = this.browsersDisplay.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(browser.getUI())) continue;
            return true;
        }
        return false;
    }

    private void layoutBrowsers() {
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        if (this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            this.container = new JXTaskPaneContainerSingle();
            this.container.addPropertyChangeListener(this.controller);
            ArrayList browserNames = Lists.newArrayList((Object[])new String[]{"project", "screen", "file", "tag"});
            ArrayList browserOrder = Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 2});
            int browserIndex = browserOrder.indexOf(TreeViewerAgent.getDefaultHierarchy());
            switch (Integer.signum(browserIndex)) {
                case 1: {
                    browserNames.add(0, (String)browserNames.remove(browserIndex));
                    browserOrder.add(0, (Integer)browserOrder.remove(browserIndex));
                }
                case 0: {
                    for (browserIndex = 0; browserIndex < browserOrder.size(); ++browserIndex) {
                        TaskPaneBrowser pane = new TaskPaneBrowser(browsers.get(browserOrder.get(browserIndex)), (String)browserNames.get(browserIndex));
                        if (browserIndex == 0) {
                            this.firstPane = pane;
                        }
                        this.container.add(pane);
                    }
                    break;
                }
            }
            Browser browser = browsers.get(5);
            this.container.add(new TaskPaneBrowser(browser, "image"));
            if (this.model.isLeader() || this.model.isAdministrator()) {
                browser = browsers.get(6);
                TaskPaneBrowser tpb = new TaskPaneBrowser(browser, "administration");
                this.container.add(tpb);
            }
            AdvancedFinder finder = this.model.getAdvancedFinder();
            finder.addPropertyChangeListener(this.controller);
            this.searchPane = new TaskPaneBrowser(new JScrollPane(finder), "search");
            this.container.add(this.searchPane);
            JScrollPane s = new JScrollPane((Component)((Object)this.container));
            s.setVerticalScrollBarPolicy(21);
            this.browsersDisplay = s;
        } else {
            JTabbedPane tabs = new JTabbedPane(1, 0);
            tabs.setAlignmentX(0.0f);
            Font font = (Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Titles");
            tabs.setFont(font);
            tabs.setForeground(UIUtilities.STEELBLUE);
            Browser browser = browsers.get(0);
            if (browser.isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = browsers.get(3)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = browsers.get(2)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            if ((browser = browsers.get(5)).isDisplayed()) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            this.browsersDisplay = tabs;
        }
    }

    private JMenuBar createMenuBar() {
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        menus.add(this.createFileMenu());
        menus.add(this.createEditMenu());
        JMenu m = this.createViewMenu();
        if (m != null) {
            menus.add(m);
        }
        JMenuBar bar = tb.getTaskBarMenuBar();
        bar.setName("menu bar");
        ArrayList<JMenu> existingMenus = new ArrayList<JMenu>();
        for (int i = 0; i < bar.getMenuCount(); ++i) {
            if (i == 2) continue;
            existingMenus.add(bar.getMenu(i));
        }
        bar.removeAll();
        Iterator k = menus.iterator();
        while (k.hasNext()) {
            bar.add((JMenu)k.next());
        }
        k = existingMenus.iterator();
        while (k.hasNext()) {
            bar.add((JMenu)k.next());
        }
        return bar;
    }

    private JMenu createNewMenu() {
        JMenu menu = new JMenu("New");
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_PROJECT);
        JMenuItem item = new JMenuItem(a);
        menu.add(item);
        item.setText(a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_DATASET);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_SCREEN);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator());
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG_SET);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.CREATE_TOP_TAG);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        return menu;
    }

    private JMenu createViewMenu() {
        if (this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            return null;
        }
        JMenu menu = new JMenu(VIEW_MENU);
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        Browser browser = browsers.get(0);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.HIERARCHY_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = browsers.get(3);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.FILES_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = browsers.get(2);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.TAGS_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = browsers.get(5);
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.IMAGES_EXPLORER));
        menu.add(item);
        return menu;
    }

    private JMenu createFileMenu() {
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        JMenu menu = tb.getMenu(2);
        Component[] comps = menu.getPopupMenu().getComponents();
        menu.removeAll();
        menu.add(this.createNewMenu());
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                menu.add(comps[i]);
            }
        }
        menu.add(new JSeparator(0));
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.BROWSE);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        switch (TreeViewerAgent.runAsPlugin()) {
            case 1: 
            case 3: {
                a = this.controller.getAction(TreeViewerControl.VIEW);
                item = new JMenuItem(a);
                item.setText(a.getActionName());
                JMenu viewMenu = new JMenu(VIEW_MENU);
                viewMenu.setIcon(item.getIcon());
                viewMenu.add(item);
                this.menuItems.add(item);
                a = this.controller.getAction(TreeViewerControl.VIEW_IN_IJ);
                item = new JMenuItem(a);
                item.setText(a.getActionName());
                viewMenu.add(item);
                this.menuItems.add(item);
                menu.add(viewMenu);
                break;
            }
            case 2: {
                a = this.controller.getAction(TreeViewerControl.VIEW);
                item = new JMenuItem(a);
                item.setText(a.getActionName());
                JMenu viewMenu = new JMenu(VIEW_MENU);
                viewMenu.setIcon(item.getIcon());
                viewMenu.add(item);
                this.menuItems.add(item);
                a = this.controller.getAction(TreeViewerControl.VIEW_IN_KNIME);
                item = new JMenuItem(a);
                item.setText(a.getActionName());
                viewMenu.add(item);
                this.menuItems.add(item);
                menu.add(viewMenu);
                break;
            }
            default: {
                a = this.controller.getAction(TreeViewerControl.VIEW);
                item = new JMenuItem(a);
                item.setText(a.getActionName());
                this.menuItems.add(item);
                menu.add(item);
            }
        }
        a = this.controller.getAction(TreeViewerControl.REFRESH_TREE);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.LOG_OFF)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.EXIT)));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu(EDIT_MENU);
        menu.setMnemonic(69);
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.CUT_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.COPY_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.PASTE_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.DELETE_OBJECT)));
        JMenu move = this.createMoveToMenu();
        if (move != null) {
            menu.add(move);
        }
        return menu;
    }

    private JMenu createMoveToMenu() {
        List<MoveToAction> actions = this.controller.getMoveAction();
        if (actions == null || actions.size() <= 1) {
            return null;
        }
        JMenu menu = new JMenu("Move to Group");
        Iterator<MoveToAction> i = actions.iterator();
        while (i.hasNext()) {
            menu.add(new JMenuItem(i.next()));
        }
        return menu;
    }

    private void initComponents() {
        this.layoutBrowsers();
        this.workingPane = new JScrollPane();
        this.workingPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.workingPane.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        this.viewerPane = new JSplitPane();
        this.viewerPane.setOrientation(0);
        this.viewerPane.setOneTouchExpandable(true);
        this.viewerPane.setContinuousLayout(true);
        this.viewerPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("dividerLocation".equals(name)) {
                    if (evt.getSource() == TreeViewerWin.this.rightPane && TreeViewerWin.this.metadataVisible) {
                        TreeViewerWin.this.dividerRightLocation = TreeViewerWin.this.rightPane.getDividerLocation();
                    }
                    TreeViewerWin.this.handleDividerMoved();
                }
            }
        };
    }

    private void handleDividerMoved() {
        MetadataViewer mv;
        JComponent component;
        DataBrowser db = this.model.getDataViewer();
        JViewport viewPort = this.workingPane.getViewport();
        if (db != null) {
            component = db.getBrowser().getUI();
            component.setPreferredSize(viewPort.getExtentSize());
            component.setSize(viewPort.getExtentSize());
            component.validate();
            component.repaint();
            db.layoutDisplay();
        }
        if ((mv = this.model.getMetadataViewer()) != null && this.metadataVisible) {
            component = mv.getEditorUI();
            Dimension d = this.rightPane.getSize();
            Dimension dd = viewPort.getExtentSize();
            Dimension nd = new Dimension(Math.abs(d.width - dd.width), d.height);
            component.setSize(nd);
            component.validate();
            component.repaint();
        }
    }

    private void buildGUI() {
        this.treeVisible = true;
        this.metadataVisible = true;
        this.rightPane = new JSplitPane();
        this.rightPane.setOrientation(1);
        this.rightPane.setOneTouchExpandable(true);
        this.rightPane.setContinuousLayout(true);
        this.rightPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rightPane.setLeftComponent(this.workingPane);
        this.rightPane.setRightComponent(null);
        this.rightPane.setResizeWeight(0.8);
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent(this.browsersDisplay);
        this.splitPane.setRightComponent(this.rightPane);
        this.splitPane.setResizeWeight(0.0);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)this.toolBar, "North");
        c.add((Component)this.splitPane, "Center");
        c.add((Component)this.statusBar, "South");
    }

    TreeViewerWin() {
        super(TITLE);
    }

    void initialize(TreeViewerControl controller, TreeViewerModel model, Rectangle bounds) {
        this.controller = controller;
        this.invokerBounds = bounds;
        this.model = model;
        this.displayMode = 100;
        this.statusBar = new StatusBar(controller);
        this.statusBar.addPropertyChangeListener(controller);
        this.toolBar = new ToolBar(controller, model, this);
        this.initComponents();
        this.setJMenuBar(this.createMenuBar());
        this.buildGUI();
        controller.attachUIListeners(this.browsersDisplay);
        this.createTitle();
        this.setName("tree viewer window");
    }

    void createTitle() {
        String title = this.model.getExperimenterNames() + " connected to ";
        title = title + this.model.getHostname();
        this.setTitle(title);
    }

    void selectFirstPane() {
        if (JXTASKPANE_TYPE.equals(this.getLayoutType()) && this.firstPane != null) {
            this.firstPane.setCollapsed(false);
        }
    }

    void initializeDisplay() {
        if (this.rightComponent == null) {
            this.rightComponent = this.model.getMetadataViewer().getEditorUI();
        }
        if (this.metadataVisible) {
            Component[] components = this.rightPane.getComponents();
            boolean b = false;
            for (int i = 0; i < components.length; ++i) {
                if (components[i] != this.rightComponent) continue;
                b = true;
            }
            if (!b) {
                this.rightPane.setRightComponent(this.rightComponent);
            }
        }
    }

    void selectPane(int browserType) {
        if (JXTASKPANE_TYPE.equals(this.getLayoutType())) {
            List<JXTaskPane> list = this.container.getTaskPanes();
            this.container.removePropertyChangeListener(this.controller);
            for (JXTaskPane pane : list) {
                TaskPaneBrowser p;
                Browser b;
                if (!(pane instanceof TaskPaneBrowser) || (b = (p = (TaskPaneBrowser)pane).getBrowser()) == null || b.getBrowserType() != browserType) continue;
                p.setCollapsed(false);
            }
            this.container.addPropertyChangeListener(this.controller);
        }
    }

    void selectSearchPane() {
        this.searchPane.setCollapsed(false);
    }

    String getLayoutType() {
        String type = (String)TreeViewerAgent.getRegistry().lookup("BrowserLayout");
        if (type == null) {
            type = "";
        }
        return type;
    }

    void closeViewer() {
        this.setVisible(false);
        this.dispose();
    }

    void addBrowser(Browser browser) {
        if (this.browsersDisplay instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)this.browsersDisplay;
            if (!this.isBrowserVisible(browser)) {
                tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
            }
            tabs.removeChangeListener(this.controller.getTabbedListener());
            tabs.setSelectedComponent(browser.getUI());
            tabs.addChangeListener(this.controller.getTabbedListener());
        }
    }

    void removeBrowser(Browser browser) {
        if (this.browsersDisplay instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)this.browsersDisplay;
            if (this.isBrowserVisible(browser)) {
                tabs.remove(browser.getUI());
                Component c = tabs.getSelectedComponent();
                if (c == null) {
                    this.model.setSelectedBrowser(null);
                    return;
                }
                Map<Integer, Browser> browsers = this.model.getBrowsers();
                Iterator<Browser> i = browsers.values().iterator();
                boolean selected = false;
                while (i.hasNext()) {
                    browser = i.next();
                    if (!c.equals(browser.getUI())) continue;
                    this.model.setSelectedBrowser(browser);
                    selected = true;
                    break;
                }
                if (!selected) {
                    this.model.setSelectedBrowser(null);
                }
            }
        }
    }

    void showPopup(int index, Component c, Point p) {
        if (c == null || !c.isShowing()) {
            return;
        }
        if (p == null) {
            p = new Point(0, 0);
        }
        switch (index) {
            case 1: 
            case 2: 
            case 7: 
            case 9: {
                PopupMenu popupMenu = new PopupMenu(this.controller, this.model, index);
                popupMenu.show(c, p.x, p.y);
            }
        }
    }

    void addComponent(JComponent component) {
        if (component == null) {
            return;
        }
        this.rightPane.removePropertyChangeListener(this.listener);
        this.splitPane.removePropertyChangeListener(this.listener);
        JViewport viewPort = this.workingPane.getViewport();
        component.setPreferredSize(viewPort.getExtentSize());
        viewPort.removeAll();
        viewPort.add(component);
        viewPort.validate();
        this.rightPane.addPropertyChangeListener(this.listener);
        this.splitPane.addPropertyChangeListener(this.listener);
    }

    void displayViewer(JComponent viewer, JComponent controls, boolean toAdd, boolean toDetach) {
        JViewport viewPort = this.workingPane.getViewport();
        viewPort.removeAll();
        this.viewerPane.removeAll();
        if (toAdd) {
            if (this.model.isFullScreen()) {
                return;
            }
            this.addComponent(viewer);
            DataBrowser db = this.model.getDataViewer();
            int location = this.splitPane.getDividerLocation();
            this.splitPane.removeAll();
            this.splitPane.setLeftComponent(this.browsersDisplay);
            if (db != null) {
                this.viewerPane.setTopComponent(viewer);
                this.viewerPane.setBottomComponent(db.getUI(false));
                this.viewerPane.setResizeWeight(0.8);
                this.splitPane.setRightComponent(this.viewerPane);
            } else {
                this.splitPane.setRightComponent(this.rightPane);
            }
            this.splitPane.setDividerLocation(location);
        }
    }

    void displayBrowser(DataBrowser db) {
        if (db == null) {
            return;
        }
        if (this.model.isFullScreen()) {
            this.addComponent(db.getUI(this.model.isFullScreen()));
        } else {
            this.viewerPane.removeAll();
            this.viewerPane.setBottomComponent(db.getUI(false));
        }
    }

    void removeAllFromWorkingPane() {
        JViewport viewPort = this.workingPane.getViewport();
        viewPort.removeAll();
        viewPort.validate();
        viewPort.repaint();
    }

    void clearMenus() {
        this.toolBar.clearMenus();
    }

    void showFinder(boolean b) {
        JSplitPane pane = null;
        if (b) {
            pane = new JSplitPane();
            pane.setOrientation(0);
            pane.setResizeWeight(1.0);
            pane.setOneTouchExpandable(true);
            pane.setContinuousLayout(true);
            pane.setTopComponent(this.splitPane);
            pane.setBottomComponent(this.model.getFinder());
        } else {
            pane = this.splitPane;
        }
        Container c = this.getContentPane();
        c.removeAll();
        c.add((Component)this.toolBar, "North");
        c.add((Component)pane, "Center");
        c.add((Component)this.statusBar, "South");
        c.validate();
    }

    void showAdvancedFinder() {
        if (!this.getLayoutType().equals(JXTASKPANE_TYPE)) {
            if (this.displayMode == 101) {
                this.displayMode = 100;
            } else if (this.displayMode == 100) {
                this.displayMode = 101;
            }
            this.splitPane.setDividerLocation(this.splitPane.getDividerLocation());
            if (this.finderScrollPane == null) {
                AdvancedFinder finder = this.model.getAdvancedFinder();
                finder.addPropertyChangeListener(this.controller);
                this.finderScrollPane = new JScrollPane(finder);
            }
            switch (this.displayMode) {
                case 101: {
                    this.splitPane.remove(this.browsersDisplay);
                    this.splitPane.setLeftComponent(this.finderScrollPane);
                    break;
                }
                case 100: {
                    this.splitPane.remove(this.finderScrollPane);
                    this.splitPane.setLeftComponent(this.browsersDisplay);
                }
            }
        } else if (this.displayMode == 101) {
            this.displayMode = 100;
        } else if (this.displayMode == 100) {
            this.displayMode = 101;
        }
    }

    int getDisplayMode() {
        return this.displayMode;
    }

    void showMenu(int menuID, Component c, Point p) {
        switch (menuID) {
            case 0: {
                this.toolBar.showManagementMenu(c, p);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                this.toolBar.showCreateMenu(c, p, menuID);
                break;
            }
            case 5: {
                this.toolBar.showPersonalMenu(c, p);
                break;
            }
            case 10: {
                this.toolBar.showAvailableScriptsMenu(c, p);
            }
        }
    }

    void onStateChanged(boolean b) {
        Map<Integer, Browser> browsers = this.model.getBrowsers();
        if (browsers != null) {
            for (Browser browser : browsers.values()) {
                browser.onComponentStateChange(b);
            }
        }
        if (this.container != null) {
            this.container.setExpandable(b);
        }
        this.browsersDisplay.setEnabled(b);
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    void setStatusIcon(boolean b) {
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.statusBar.setStatusIcon(b);
    }

    void updateMenuItems() {
        for (JMenuItem item : this.menuItems) {
            TreeViewerAction a = (TreeViewerAction)item.getAction();
            item.setText(a.getActionName());
            item.setToolTipText(a.getActionDescription());
        }
        this.toolBar.setPermissions();
    }

    void setInspectorVisibility() {
        if (this.treeVisible) {
            if (this.leftComponent == null) {
                this.leftComponent = this.splitPane.getLeftComponent();
            }
            this.dividerLocation = this.splitPane.getDividerLocation();
            Component[] components = this.splitPane.getComponents();
            if (components != null) {
                boolean b = false;
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != this.leftComponent) continue;
                    b = true;
                }
                if (b && this.leftComponent != null) {
                    this.splitPane.remove(this.leftComponent);
                }
            }
        } else if (this.leftComponent != null) {
            this.splitPane.add(this.leftComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
        this.treeVisible = !this.treeVisible;
    }

    void setMetadataVisibility() {
        if (this.rightComponent == null) {
            this.rightComponent = this.model.getMetadataViewer().getEditorUI();
        }
        if (this.metadataVisible) {
            Component[] components = this.rightPane.getComponents();
            if (components != null && components.length > 0) {
                boolean b = false;
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != this.rightComponent) continue;
                    b = true;
                }
                if (b) {
                    this.rightPane.remove(this.rightComponent);
                }
            }
        } else if (this.rightComponent != null) {
            this.rightPane.add(this.rightComponent);
            if (this.dividerRightLocation > 0) {
                this.rightPane.setDividerLocation(this.dividerRightLocation);
            } else {
                this.rightPane.setResizeWeight(0.8);
            }
        }
        this.metadataVisible = !this.metadataVisible;
    }

    MetadataViewer resetMetadataViewer() {
        MetadataViewer v = this.model.resetMetadataViewer();
        v.addPropertyChangeListener(this.controller);
        if (this.rightComponent != null) {
            this.rightPane.remove(this.rightComponent);
        }
        this.rightComponent = v.getEditorUI();
        if (this.metadataVisible) {
            this.rightPane.add(this.rightComponent);
            if (this.dividerRightLocation > 0) {
                this.rightPane.setDividerLocation(this.dividerRightLocation);
            } else {
                this.rightPane.setResizeWeight(0.8);
            }
        }
        return v;
    }

    void forceShowMetaDataView() {
        this.metadataVisible = true;
        this.resetMetadataViewer();
    }

    void reloadThumbnails(List<Long> ids) {
        this.model.reloadThumbnails(ids);
    }

    void onActivityTerminated(ActivityComponent activity) {
        TinyDialog d = new TinyDialog((Frame)this, activity.getActivityType(), 1);
        d.getContentPane().setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        d.addPropertyChangeListener("closedDialog", this.controller);
        d.pack();
        Point p = new Point(0, 2 * this.statusBar.getPreferredSize().height);
        this.setCloseAfter(true);
        this.showJDialogAsSheet(d, p, 2);
    }

    void refreshRenderer() {
        this.model.refreshRenderer();
    }

    String getObjectMimeType() {
        return this.model.getObjectMimeType();
    }

    ScriptObject getScriptFromName(String name) {
        return this.model.getScriptFromName(name);
    }

    void setScriptsLoadingStatus(boolean loading) {
        this.toolBar.setScriptsLoadingStatus(loading);
    }

    void setPermissions() {
        this.toolBar.setPermissions();
    }

    Browser resetLayout() {
        this.layoutBrowsers();
        this.splitPane.setLeftComponent(this.browsersDisplay);
        Browser result = null;
        if (JXTASKPANE_TYPE.equals(this.getLayoutType())) {
            Browser browser = this.model.getSelectedBrowser();
            List<JXTaskPane> list = this.container.getTaskPanes();
            this.container.removePropertyChangeListener(this.controller);
            if (browser != null) {
                if (browser.getBrowserType() == 6) {
                    if (TreeViewerAgent.isAdministrator()) {
                        for (JXTaskPane pane : list) {
                            TaskPaneBrowser tpb;
                            Browser b;
                            if (!(pane instanceof TaskPaneBrowser) || (b = (tpb = (TaskPaneBrowser)pane).getBrowser()) != browser) continue;
                            tpb.setCollapsed(false);
                        }
                    } else if (this.firstPane != null) {
                        result = ((TaskPaneBrowser)this.firstPane).getBrowser();
                        this.firstPane.setCollapsed(false);
                    }
                } else {
                    for (JXTaskPane pane : list) {
                        TaskPaneBrowser tpb;
                        Browser b;
                        if (!(pane instanceof TaskPaneBrowser) || (b = (tpb = (TaskPaneBrowser)pane).getBrowser()) != browser) continue;
                        tpb.setCollapsed(false);
                    }
                }
            } else if (this.searchPane != null) {
                this.searchPane.setCollapsed(false);
            }
            this.container.addPropertyChangeListener(this.controller);
        }
        this.validate();
        this.repaint();
        return result;
    }

    void onImport() {
        this.toolBar.onImport();
    }

    @Override
    public void setOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(9 * (screenSize.width / 10), 8 * (screenSize.height / 10));
        UIUtilities.incrementRelativeToAndShow(this.invokerBounds, this);
        this.invokerBounds = null;
    }
}

