/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewedByItem
extends JLabel {
    public static final int MAX_ICON_SIZE = 82;
    public static final String VIEWED_BY_PROPERTY = "viewedBy";
    private ExperimenterData experimenter;
    private RndProxyDef rndDef;
    private BufferedImage image;
    private boolean selected;

    public ViewedByItem(ExperimenterData experimenter, RndProxyDef rndDef) {
        this(experimenter, rndDef, false);
    }

    public ViewedByItem(ExperimenterData experimenter, final RndProxyDef rndDef, boolean isOwnerRndDef) {
        this.experimenter = experimenter;
        this.rndDef = rndDef;
        Font f = this.getFont();
        this.setFont(f.deriveFont(f.getStyle(), f.getSize() - 3));
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setIconTextGap(0);
        this.setText(experimenter.getFirstName() + " " + experimenter.getLastName());
        if (isOwnerRndDef) {
            this.setForeground(Color.BLUE);
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("Viewed by: " + this.getText());
        Timestamp time = rndDef.getLastModified();
        if (time != null) {
            l.add("Last modified: " + UIUtilities.formatDefaultDate(time));
        }
        this.setToolTipText(UIUtilities.formatToolTipText(l));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ViewedByItem.this.firePropertyChange(ViewedByItem.VIEWED_BY_PROPERTY, null, rndDef);
            }
        });
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ExperimenterData getExperimenter() {
        return this.experimenter;
    }

    public RndProxyDef getRndDef() {
        return this.rndDef;
    }

    public long getExperimenterID() {
        return this.experimenter.getId();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image == null) {
            return;
        }
        this.setIcon(new ImageIcon(Factory.scaleBufferedImage(image, 82)));
        this.revalidate();
        this.repaint();
    }
}

