/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorHandler;
import org.apache.commons.io.FileUtils;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class StatusLabel
extends JPanel
implements PropertyChangeListener {
    public static final String DEFAULT_TEXT = "Pending...";
    public static final String DUPLICATE = "Already processed, skipping";
    public static final String SCANNING_TEXT = "Scanning...";
    public static final String CANCELLED_TEXT = "Cancelled";
    private static final String OFFLINE_SUCCESS_TEXT = "The file will be imported offline.";
    private static final String OFFLINE_FAIL_TEXT = "Error: The file cannot be imported offline.";
    public static final String FAILED_TEXT = "Failed to upload";
    private static final int WIDTH = 200;
    private static final int MAX = 100;
    private JLabel generalLabel;
    private JProgressBar uploadBar;
    private JProgressBar processingBar;
    private List<JLabel> labels;
    private ImportException exception;
    private Status status;

    private String formatUpload(long value) {
        StringBuffer buffer = new StringBuffer();
        String v = FileUtils.byteCountToDisplaySize((long)value);
        String[] values = v.split(" ");
        if (values.length > 1) {
            String u = values[1];
            if (this.status.getUnits().equals(u)) {
                buffer.append(values[0]);
            } else {
                buffer.append(v);
            }
        } else {
            buffer.append(v);
        }
        buffer.append("/");
        buffer.append(this.status.getFileSize());
        return buffer.toString();
    }

    private void buildUI() {
        this.labels = new ArrayList<JLabel>();
        this.setLayout(new FlowLayout(0));
        this.add(this.generalLabel);
        JLabel label = new JLabel("Upload");
        label.setVisible(false);
        this.labels.add(label);
        this.add(label);
        this.add(this.uploadBar);
        this.add(Box.createHorizontalStrut(5));
        label = new JLabel("Processing");
        label.setVisible(false);
        this.labels.add(label);
        this.add(label);
        this.add(this.processingBar);
        this.setOpaque(false);
    }

    private void initialize() {
        this.generalLabel = new JLabel(DEFAULT_TEXT);
        Font f = this.generalLabel.getFont();
        Font derived = f.deriveFont(f.getStyle(), f.getSize() - 2);
        this.uploadBar = new JProgressBar(0, 100);
        this.uploadBar.setFont(derived);
        this.uploadBar.setStringPainted(true);
        Dimension d = this.uploadBar.getPreferredSize();
        this.uploadBar.setPreferredSize(new Dimension(200, d.height));
        this.processingBar = new JProgressBar(0, Status.STEPS.size());
        this.processingBar.setStringPainted(true);
        this.processingBar.setString(DEFAULT_TEXT);
        this.processingBar.setFont(derived);
        this.uploadBar.setVisible(false);
        this.processingBar.setVisible(false);
    }

    public StatusLabel(Status status) {
        this.status = status;
        status.addPropertyChangeListener(this);
        this.initialize();
        this.buildUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pe) {
        if (pe.getPropertyName().equals("importEvenPassThrough")) {
            ImportEvent event = (ImportEvent)pe.getNewValue();
            SwingUtilities.invokeLater(() -> {
                if (event instanceof ImportCandidates.SCANNING) {
                    if (!this.status.isMarkedAsCancel() && this.exception == null) {
                        this.generalLabel.setText(SCANNING_TEXT);
                    }
                } else if (event instanceof ErrorHandler.MISSING_LIBRARY) {
                    this.exception = new ImportException("Missing library to decode the file.", ((ErrorHandler.MISSING_LIBRARY)event).exception);
                } else if (event instanceof ErrorHandler.UNKNOWN_FORMAT) {
                    this.exception = new ImportException("Unknown format", ((ErrorHandler.UNKNOWN_FORMAT)event).exception);
                } else if (event instanceof ErrorHandler.FILE_EXCEPTION) {
                    ErrorHandler.FILE_EXCEPTION e = (ErrorHandler.FILE_EXCEPTION)event;
                    this.exception = new ImportException(e.exception);
                } else if (event instanceof ErrorHandler.INTERNAL_EXCEPTION) {
                    ErrorHandler.INTERNAL_EXCEPTION e = (ErrorHandler.INTERNAL_EXCEPTION)event;
                    this.exception = new ImportException(e.exception);
                } else if (event instanceof ImportEvent.FILE_UPLOAD_BYTES) {
                    ImportEvent.FILE_UPLOAD_BYTES e = (ImportEvent.FILE_UPLOAD_BYTES)event;
                    long v = this.status.getTotalUploadedSize() + e.uploadedBytes;
                    if (this.status.getSizeUpload() != 0L) {
                        this.uploadBar.setValue((int)(v * 100L / this.status.getSizeUpload()));
                    }
                    StringBuffer buffer = new StringBuffer();
                    if (v != this.status.getSizeUpload()) {
                        buffer.append(this.formatUpload(v));
                    } else {
                        buffer.append(this.status.getFileSize());
                    }
                    buffer.append(" ");
                    if (e.timeLeft != 0L) {
                        String s = UIUtilities.calculateHMSFromMilliseconds(e.timeLeft, true);
                        buffer.append(s);
                        if (CommonsLangUtils.isNotBlank(s)) {
                            buffer.append(" Left");
                        } else {
                            buffer.append("complete");
                        }
                    }
                    this.uploadBar.setString(buffer.toString());
                } else if (event instanceof ImportEvent.FILESET_UPLOAD_START) {
                    Iterator<JLabel> i = this.labels.iterator();
                    while (i.hasNext()) {
                        i.next().setVisible(true);
                    }
                    this.generalLabel.setText("");
                    this.uploadBar.setVisible(true);
                    this.processingBar.setVisible(true);
                } else if (event instanceof ImportEvent.FILESET_UPLOAD_PREPARATION) {
                    this.generalLabel.setText("Preparing upload...");
                } else if (event instanceof ImportEvent.IMPORT_STARTED) {
                    ImportEvent.IMPORT_STARTED iMPORT_STARTED = (ImportEvent.IMPORT_STARTED)event;
                }
                this.processingBar.setValue(this.status.getStep());
                this.processingBar.setString(Status.STEPS.get(this.status.getStep()));
            });
        } else if (pe.getPropertyName().equals("markedAsDuplicate")) {
            SwingUtilities.invokeLater(() -> this.generalLabel.setText(DUPLICATE));
        } else if (pe.getPropertyName().equals("markedAsCancelled")) {
            SwingUtilities.invokeLater(() -> this.generalLabel.setText(CANCELLED_TEXT));
        } else if (pe.getPropertyName().equals("offLine")) {
            Boolean b = (Boolean)pe.getNewValue();
            SwingUtilities.invokeLater(() -> {
                if (b.booleanValue()) {
                    this.generalLabel.setText(OFFLINE_SUCCESS_TEXT);
                } else {
                    this.generalLabel.setText(OFFLINE_FAIL_TEXT);
                }
            });
        } else if (pe.getPropertyName().equals("failed")) {
            SwingUtilities.invokeLater(() -> this.generalLabel.setText(FAILED_TEXT));
            this.exception = new ImportException((Throwable)pe.getNewValue());
        }
    }
}

