/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ExportActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ExportLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class ExportActivity
extends ActivityComponent {
    private static final String CREATION_AS_XML = "Export image as XML";
    private static final String CREATION_AS_OME_TIFF = "Export image as OME-TIFF";
    private static final String DESCRIPTION_CREATED = "Image exported";
    private static final String DESCRIPTION_CANCEL = "Export cancelled";
    private ExportActivityParam parameters;

    private String getFileName() {
        File folder = this.parameters.getFolder();
        String extension = "";
        String path = folder.getAbsolutePath();
        switch (this.parameters.getIndex()) {
            case 0: {
                if (path.endsWith("ome.tif") || path.endsWith("ome.tiff")) break;
                extension = ".ome.tiff";
            }
        }
        if (CommonsLangUtils.isNotBlank(extension)) {
            return path + extension;
        }
        return path;
    }

    public ExportActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, ExportActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize(CREATION_AS_OME_TIFF, parameters.getIcon());
        this.messageLabel.setText(this.getFileName());
        switch (parameters.getIndex()) {
            case 0: {
                this.type.setText(CREATION_AS_OME_TIFF);
            }
        }
    }

    @Override
    protected UserNotifierLoader createLoader() {
        this.loader = new ExportLoader(this.viewer, this.registry, this.ctx, this.parameters.getImage(), new File(this.getFileName()), 0, this.parameters.getTarget(), this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

