/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OMETextField
extends JTextField
implements DocumentListener {
    private Color editedColor;
    private Color defaultForeground;
    private String originalText;

    private void updateForeground() {
        String text = this.getText();
        if (this.editedColor != null && this.originalText != null) {
            if (this.originalText.equals(text)) {
                this.setForeground(this.defaultForeground);
            } else {
                this.setForeground(this.editedColor);
            }
        }
        if (this.originalText == null) {
            this.originalText = text;
            this.defaultForeground = this.getForeground();
        }
    }

    public OMETextField() {
        this((Color)null);
    }

    public OMETextField(Color editedColor) {
        this.setEditedColor(editedColor);
        this.getDocument().addDocumentListener(this);
    }

    public void setEditedColor(Color editedColor) {
        this.editedColor = editedColor;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateForeground();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateForeground();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

