/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.ArrayList;

public class Text
implements PlugIn,
DialogListener {
    private static final String LOC_KEY = "fonts.loc";
    private static final String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold+Italic"};
    private static final String[] justifications = new String[]{"Left", "Center", "Right"};
    private static GenericDialog gd;
    private String font = TextRoi.getFont();
    private int fontSize = TextRoi.getSize();
    private int style = TextRoi.getStyle();
    private int justification = TextRoi.getGlobalJustification();
    private int angle;
    private boolean antialiased = TextRoi.isAntialiased();
    private Color color = Toolbar.getForegroundColor();
    private String colorName;

    public void run(String arg) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.showDialog();
        }
    }

    void showDialog() {
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi = imp != null ? imp.getRoi() : null;
        TextRoi textRoi = roi != null && roi instanceof TextRoi ? (TextRoi)roi : null;
        String fillc = "None";
        TextRoi.setDefaultFillColor(null);
        TextRoi.setDefaultAngle(0.0);
        if (textRoi != null) {
            Font font = textRoi.getCurrentFont();
            this.fontSize = font.getSize();
            this.angle = (int)textRoi.getAngle();
            this.style = font.getStyle();
            this.justification = textRoi.getJustification();
            Color c = textRoi.getStrokeColor();
            if (c != null) {
                this.color = c;
            }
            fillc = Colors.colorToString2(textRoi.getFillColor());
            this.antialiased = textRoi.getAntialiased();
        }
        this.colorName = Colors.colorToString2(this.color);
        gd = new NonBlockingGenericDialog("Fonts");
        gd.addChoice("Font:", this.getFonts(), this.font);
        gd.addChoice("Style:", styles, styles[this.style]);
        gd.addChoice("Just:", justifications, justifications[this.justification]);
        gd.addChoice("Color:", Colors.getColors(this.colorName), this.colorName);
        gd.addChoice("Bkgd:", Colors.getColors("None", !"None".equals(fillc) ? fillc : null), fillc);
        gd.addSlider("Size:", 9.0, 200.0, this.fontSize);
        gd.addSlider("Angle:", -90.0, 90.0, this.angle);
        gd.addCheckbox("Antialiased text", this.antialiased);
        Point loc = Prefs.getLocation(LOC_KEY);
        if (IJ.debugMode) {
            Dimension screen = IJ.getScreenSize();
            IJ.log("Fonts: " + loc + " " + screen);
        }
        if (loc != null) {
            gd.centerDialog(false);
            gd.setLocation(loc);
        }
        gd.addDialogListener(this);
        gd.setOKLabel("Close");
        gd.hideCancelButton();
        gd.showDialog();
        Prefs.saveLocation(LOC_KEY, gd.getLocation());
    }

    String[] getFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        ArrayList<String> names = new ArrayList<String>();
        names.add("SansSerif");
        names.add("Serif");
        names.add("Monospaced");
        for (int i = 0; i < fonts.length; ++i) {
            String f = fonts[i];
            if (f.length() > 20 || f.equals("SansSerif") || f.equals("Serif") || f.equals("Monospaced")) continue;
            names.add(f);
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        ImagePlus imp = WindowManager.getCurrentImage();
        Roi roi = imp != null ? imp.getRoi() : null;
        TextRoi textRoi = roi != null && roi instanceof TextRoi ? (TextRoi)roi : null;
        this.font = gd.getNextChoice();
        this.style = gd.getNextChoiceIndex();
        this.justification = gd.getNextChoiceIndex();
        String colorName2 = gd.getNextChoice();
        String fillc = gd.getNextChoice();
        this.fontSize = (int)gd.getNextNumber();
        this.angle = (int)gd.getNextNumber();
        this.antialiased = gd.getNextBoolean();
        if (this.colorName != null && !colorName2.equals(this.colorName)) {
            Color color = Colors.decode(colorName2, null);
            Toolbar.setForegroundColor(color);
            this.colorName = colorName2;
        }
        TextRoi.setFont(this.font, this.fontSize, this.style, this.antialiased);
        TextRoi.setGlobalJustification(this.justification);
        Color fillColor = Colors.decode(fillc, null);
        TextRoi.setDefaultFillColor(fillColor);
        TextRoi.setDefaultAngle(this.angle);
        if (textRoi != null) {
            textRoi.setAngle(this.angle);
            textRoi.setJustification(this.justification);
            textRoi.setFillColor(fillColor);
            textRoi.setAntialiased(this.antialiased);
        }
        return true;
    }
}

