/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.PlateData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class TabularDataLoader
extends DataBrowserLoader {
    private TableParameters parameters;
    private CallHandle handle;
    private boolean loadAll;

    public TabularDataLoader(DataBrowser viewer, SecurityContext ctx, List<Long> ids, boolean loadAll) {
        super(viewer, ctx);
        if (ids == null || ids.size() <= 0) {
            throw new IllegalArgumentException("No file to retrieve.");
        }
        this.parameters = new TableParameters(ids);
        this.loadAll = loadAll;
    }

    public TabularDataLoader(DataBrowser viewer, SecurityContext ctx, DataObject object, boolean loadAll) {
        super(viewer, ctx);
        if (object == null) {
            throw new IllegalArgumentException("No file to retrieve.");
        }
        if (!(object instanceof PlateData) && !(object instanceof ScreenData)) {
            throw new IllegalArgumentException("Object not supported.");
        }
        this.parameters = new TableParameters(object.getClass(), object.getId());
    }

    @Override
    public void load() {
        long userID = this.getCurrentUser();
        if (this.loadAll) {
            userID = -1L;
        }
        this.handle = this.mhView.loadTabularData(this.ctx, this.parameters, userID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        if (result == null) {
            return;
        }
        this.viewer.setTabularData((List)result);
    }
}

