/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.util;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.view.QuickSearch;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagCellRenderer;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagItem;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;

public class QuickFiltering
extends QuickSearch
implements PropertyChangeListener {
    public static final String TAG_LOADING_PROPERTY = "tagLoading";
    public static final String FILTER_DATA_PROPERTY = "filterData";
    public static final String FILTER_TAGS_PROPERTY = "filterTags";
    public static final String DISPLAY_ALL_NODES_PROPERTY = "displayAllNodes";
    private Collection tags;
    private HistoryDialog tagsDialog;

    private void handleTagInsert() {
        if (this.tags == null) {
            this.firePropertyChange(TAG_LOADING_PROPERTY, (Object)false, (Object)true);
            return;
        }
        this.codeCompletion();
        if (this.tagsDialog == null) {
            return;
        }
        String name = this.getSearchValue();
        List<String> l = SearchUtil.splitTerms(name, ",");
        if (l.size() > 0) {
            if (this.tagsDialog.setSelectedTextValue(l.get(l.size() - 1).trim())) {
                Rectangle r = this.getSelectionArea().getBounds();
                this.tagsDialog.setFocusable(false);
                this.tagsDialog.show(this.getSelectionArea(), 0, r.height);
            } else {
                this.tagsDialog.setVisible(false);
            }
        }
    }

    private void codeCompletion() {
        if (this.tagsDialog != null) {
            return;
        }
        Rectangle r = this.getSelectionArea().getBounds();
        Object[] data = null;
        if (this.tags != null && this.tags.size() > 0) {
            data = new Object[this.tags.size()];
            Iterator j = this.tags.iterator();
            int i = 0;
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                TagItem item = new TagItem(object);
                data[i] = item;
                ++i;
            }
            long id = MetadataViewerAgent.getUserDetails().getId();
            this.tagsDialog = new HistoryDialog(data, r.width);
            this.tagsDialog.setListCellRenderer(new TagCellRenderer(id));
            this.tagsDialog.addPropertyChangeListener("selection", this);
        }
    }

    public QuickFiltering(String text) {
        this.setSingleSelection(true);
        this.setDefaultSearchContext(text);
        this.setSearchEnabled(false);
        this.addPropertyChangeListener(this);
    }

    public void setTags(Collection tags) {
        if (tags == null) {
            return;
        }
        this.tags = tags;
    }

    public Collection getTags() {
        return this.tags;
    }

    public void setSelectedTags(Collection tags) {
        this.clear();
        if (tags == null || tags.size() == 0) {
            this.firePropertyChange(DISPLAY_ALL_NODES_PROPERTY, (Object)false, (Object)true);
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (TagAnnotationData tag : tags) {
            list.add(tag.getTagValue());
        }
        this.setSearchValue(list, false);
        FilterContext context = new FilterContext();
        List<String> l = SearchUtil.splitTerms(this.getSearchValue(), ",");
        if (l != null && l.size() > 0) {
            context.addAnnotationType(TagAnnotationData.class, l);
            this.firePropertyChange(FILTER_TAGS_PROPERTY, null, context);
        }
    }

    @Override
    protected void handleTextInsert() {
        SearchObject node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        switch (node.getIndex()) {
            case 0: {
                this.handleTagInsert();
            }
        }
    }

    @Override
    protected void handleKeyEnter() {
        SearchObject node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        switch (node.getIndex()) {
            case 0: {
                if (this.tagsDialog != null && this.tagsDialog.isVisible()) {
                    Object item = this.tagsDialog.getSelectedTextValue();
                    if (!(item instanceof TagItem)) {
                        return;
                    }
                    DataObject ho = ((TagItem)item).getDataObject();
                    if (!(ho instanceof TagAnnotationData)) break;
                    String v = ((TagAnnotationData)ho).getTagValue();
                    this.setSearchValue(v, true);
                    FilterContext context = new FilterContext();
                    List<String> l = SearchUtil.splitTerms(this.getSearchValue(), ",");
                    if (l == null || l.size() <= 0) break;
                    context.addAnnotationType(TagAnnotationData.class, l);
                    this.firePropertyChange(FILTER_TAGS_PROPERTY, null, context);
                    break;
                }
                this.onNodeSelection();
                break;
            }
            case 1: 
            case 2: {
                this.onNodeSelection();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String name = evt.getPropertyName();
        if ("selection".equals(name)) {
            Object item = evt.getNewValue();
            if (!(item instanceof TagItem)) {
                return;
            }
            DataObject ho = ((TagItem)item).getDataObject();
            if (ho instanceof TagAnnotationData) {
                String v = ((TagAnnotationData)ho).getTagValue();
                this.setSearchValue(v, true);
                FilterContext context = new FilterContext();
                List<String> l = SearchUtil.splitTerms(this.getSearchValue(), ",");
                if (l != null && l.size() > 0) {
                    context.addAnnotationType(TagAnnotationData.class, l);
                    this.firePropertyChange(FILTER_TAGS_PROPERTY, null, context);
                }
            }
        } else if ("vkUpSearch".equals(name)) {
            if (this.tagsDialog != null && this.tagsDialog.isVisible()) {
                this.tagsDialog.setSelectedIndex(false);
            }
        } else if ("vkDownSearch".equals(name)) {
            if (this.tagsDialog != null && this.tagsDialog.isVisible()) {
                this.tagsDialog.setSelectedIndex(true);
            }
        } else if ("quickSearch".equals(name) && (this.tagsDialog == null || !this.tagsDialog.isVisible())) {
            this.firePropertyChange(FILTER_DATA_PROPERTY, evt.getOldValue(), evt.getNewValue());
        }
    }
}

