/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.util.LinkedHashMap;
import ome.model.units.Pressure;
import ome.model.units.Unit;
import ome.units.quantity.Temperature;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.primitives.PercentFraction;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ImagingEnvConverter
extends DataConverter {
    public ImagingEnvConverter() {
        this.tagMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, TagData> convertData(ImagingEnvironment env) {
        if (env != null) {
            try {
                this.tagMap.put("Temperature", this.convertTemperature(env.getTemperature(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Temperature", this.convertTemperature(null, true));
            }
            try {
                this.tagMap.put("Air Pressure", this.convertAirPressure(env.getAirPressure(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Air Pressure", this.convertAirPressure(null, true));
            }
            try {
                this.tagMap.put("Humidity %", this.convertHumidity(env.getHumidity(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Humidity %", this.convertHumidity(null, true));
            }
            try {
                this.tagMap.put("CO2 Percent %", this.convertCo2Percent(env.getCO2Percent(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("CO2 Percent %", this.convertCo2Percent(null, true));
            }
        } else {
            this.tagMap.put("Temperature", this.convertTemperature(null, true));
            this.tagMap.put("Air Pressure", this.convertAirPressure(null, true));
            this.tagMap.put("Humidity %", this.convertHumidity(null, true));
            this.tagMap.put("CO2 Percent %", this.convertCo2Percent(null, true));
        }
        return this.tagMap;
    }

    private TagData convertTemperature(Temperature value, boolean prop) {
        ome.model.units.Temperature val = null;
        if (value != null) {
            val = new ome.model.units.Temperature(value);
        }
        return new TagData("OME:ImagingEnvironment", "Temperature", (Unit)val, ome.model.units.Temperature.class, prop, "TextField");
    }

    private TagData convertAirPressure(ome.units.quantity.Pressure value, boolean prop) {
        Pressure val = null;
        if (value != null) {
            val = new Pressure(value);
        }
        return new TagData("OME:ImagingEnvironment", "Air Pressure", (Unit)val, Pressure.class, prop, "TextField");
    }

    private TagData convertHumidity(PercentFraction value, boolean prop) {
        String val = value != null ? String.valueOf(value.getValue()) : "";
        TagData t = new TagData("OME:ImagingEnvironment", "Humidity %", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPercentFraction(t, "Invalid input. Use float between 0.0 and 1.0!"));
        return t;
    }

    private TagData convertCo2Percent(PercentFraction value, boolean prop) {
        String val = value != null ? String.valueOf(value.getValue()) : "";
        TagData t = new TagData("OME:ImagingEnvironment", "CO2 Percent %", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPercentFraction(t, "Invalid input. Use float between 0.0 and 1.0!"));
        return t;
    }
}

