/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ProjectionBICanvas;

class ProjectionUI
extends JScrollPane {
    private JComponent canvas;
    private BrowserModel model;
    private BrowserUI view;
    private JLayeredPane layeredPane;
    private boolean adjusting;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = new ProjectionBICanvas(this.model, this.view, this);
        this.layeredPane.add((Component)this.canvas, (Object)0);
    }

    private void buildGUI() {
        this.getViewport().setLayout(null);
        this.getViewport().setBackground(this.model.getBackgroundColor());
        this.getViewport().add(this.layeredPane);
    }

    private void center() {
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            xLoc = this.layeredPane.getX();
        }
        if (vBar.isVisible()) {
            yLoc = this.layeredPane.getY();
        }
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
    }

    private boolean scrollbarsVisible() {
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        return hBar.isVisible() || vBar.isVisible();
    }

    ProjectionUI() {
    }

    void initialize(BrowserModel model, BrowserUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    Dimension getViewportSize() {
        return this.getViewport().getSize();
    }

    void zoomImage(boolean resetLocation) {
        int h;
        int w;
        if (this.model.getProjectedImage() == null) {
            double f = this.model.getZoomFactor();
            w = (int)((double)this.model.getMaxX() * f);
            h = (int)((double)this.model.getMaxY() * f);
        } else {
            this.model.createDisplayedProjectedImage();
            BufferedImage img = this.model.getDisplayedProjectedImage();
            if (img == null) {
                double f = this.model.getZoomFactor();
                w = (int)((double)this.model.getMaxX() * f);
                h = (int)((double)this.model.getMaxY() * f);
            } else {
                w = img.getWidth();
                h = img.getHeight();
            }
        }
        this.setComponentsSize(w, h);
        if (resetLocation) {
            this.getViewport().setViewPosition(new Point(-1, -1));
        }
        this.canvas.repaint();
        this.setBounds(this.getBounds());
    }

    void setComponentsSize(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        this.repaint();
    }

    void addComponentToLayer(JComponent c) {
        this.layeredPane.add((Component)c, (Object)1);
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        if (this.model.isBigImage() && (d.width >= r.width || d.height >= r.height)) {
            return;
        }
        if (!this.scrollbarsVisible() && this.adjusting) {
            this.adjusting = false;
        }
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (!hBar.isVisible() || !vBar.isVisible()) {
            this.center();
        }
    }
}

