/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStatsSimple;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AnalysisStatsWrapper {
    public static Map<StatsType, Map> convertStats(Map shapeStats) {
        if (shapeStats == null || shapeStats.size() == 0) {
            return null;
        }
        TreeMap<Integer, Double> channelMin = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelSum = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelMax = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelMean = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
        TreeMap<Integer, ROIShapeStatsSimple> channelData = new TreeMap<Integer, ROIShapeStatsSimple>();
        Iterator channelIterator = shapeStats.keySet().iterator();
        while (channelIterator.hasNext()) {
            int channel = (Integer)channelIterator.next();
            ROIShapeStatsSimple stats = (ROIShapeStatsSimple)shapeStats.get(channel);
            channelSum.put(channel, stats.getSum());
            channelMin.put(channel, stats.getMin());
            channelMax.put(channel, stats.getMax());
            channelMean.put(channel, UIUtilities.roundTwoDecimals(stats.getMean()));
            channelStdDev.put(channel, UIUtilities.roundTwoDecimals(stats.getStandardDeviation()));
            channelData.put(channel, stats);
        }
        HashMap<StatsType, Map> statsMap = new HashMap<StatsType, Map>(StatsType.values().length);
        statsMap.put(StatsType.SUM, channelSum);
        statsMap.put(StatsType.MIN, channelMin);
        statsMap.put(StatsType.MAX, channelMax);
        statsMap.put(StatsType.MEAN, channelMean);
        statsMap.put(StatsType.STDDEV, channelStdDev);
        statsMap.put(StatsType.PIXELDATA, channelData);
        return statsMap;
    }

    public static enum StatsType {
        MIN,
        MAX,
        MEAN,
        STDDEV,
        PIXELDATA,
        SUM;

    }
}

