/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ThumbnailLoader
extends MetadataLoader {
    private ImageData image;
    private Set<Long> userIDs;
    private CallHandle handle;
    private Map<Long, BufferedImage> thumbnails;

    public ThumbnailLoader(MetadataViewer viewer, SecurityContext ctx, ImageData image, Set<Long> userIDs, int loaderID) {
        super(viewer, ctx, loaderID);
        this.image = image;
        this.userIDs = userIDs;
        this.thumbnails = new HashMap<Long, BufferedImage>();
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadThumbnails(this.ctx, this.image, this.userIDs, 96, 96, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            this.thumbnails.put(td.getUserID(), td.getThumbnail());
        }
        if (this.thumbnails.size() == this.userIDs.size()) {
            this.viewer.setThumbnails(this.thumbnails, this.image.getId());
        }
    }

    @Override
    public void handleNullResult() {
    }
}

