/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.WellSampleData;
import omero.gateway.model.XMLAnnotationData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationComponent;
import org.openmicroscopy.shoola.agents.metadata.util.AnalysisResultsItem;
import org.openmicroscopy.shoola.agents.metadata.util.FigureDialog;
import org.openmicroscopy.shoola.agents.util.ui.DowngradeChooser;
import org.openmicroscopy.shoola.agents.util.ui.ScriptMenuItem;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.RefWindow;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.CSVFilter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.HTMLFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.OMETIFFFilter;
import org.openmicroscopy.shoola.util.filter.file.OpenDocumentFilter;
import org.openmicroscopy.shoola.util.filter.file.PDFFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.PowerPointFilter;
import org.openmicroscopy.shoola.util.filter.file.TEXTFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.filter.file.WordFilter;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.filter.file.ZipFilter;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;

class EditorControl
implements ActionListener,
ChangeListener,
PropertyChangeListener,
MouseListener {
    static final String SAVE_PROPERTY = "save";
    static final int ADD_LOCAL_DOCS = 0;
    static final int ADD_UPLOADED_DOCS = 1;
    static final int ADD_TAGS = 2;
    static final int SAVE = 3;
    static final int DOWNLOAD = 4;
    static final int ACQUISITION_METADATA = 5;
    static final int CREATE_MOVIE = 7;
    static final int RENDERER = 8;
    static final int ANALYSE_FLIM = 9;
    static final int REFRESH = 10;
    static final int EXPORT_AS_OMETIFF = 11;
    static final int SPLIT_VIEW_FIGURE = 12;
    static final int SPLIT_VIEW_ROI_FIGURE = 13;
    static final int THUMBNAILS_FIGURE = 14;
    static final int ANALYSE_FRAP = 15;
    static final int MOVIE_FIGURE = 16;
    static final int UPLOAD_SCRIPT = 17;
    static final int RELOAD_SCRIPT = 18;
    static final int REMOVE_TAGS = 19;
    static final int REMOVE_DOCS = 20;
    static final int SAVE_AS = 21;
    static final int VIEW_IMAGE = 22;
    static final int VIEW_IMAGE_IN_IJ = 23;
    static final int SHOW_FILE_PATHS = 24;
    static final int REMOVE_OTHER_ANNOTATIONS = 25;
    static final int SHOW_LOCATION = 26;
    private Editor model;
    private EditorUI view;
    private List<FileFilter> filters;
    private List<FileFilter> exportFilters;
    private FigureDialog figureDialog;

    EditorControl() {
    }

    private void createFileFilters() {
        this.filters = new ArrayList<FileFilter>();
        this.filters.add(new PDFFilter());
        this.filters.add(new CSVFilter());
        this.filters.add(new HTMLFilter());
        this.filters.add(new JPEGFilter());
        this.filters.add(new ExcelFilter());
        this.filters.add(new PowerPointFilter());
        this.filters.add(new WordFilter());
        this.filters.add(new OpenDocumentFilter());
        this.filters.add(new PNGFilter());
        this.filters.add(new XMLFilter());
        this.filters.add(new TIFFFilter());
        this.filters.add(new TEXTFilter());
        this.exportFilters = new ArrayList<FileFilter>();
        this.exportFilters.add(new OMETIFFFilter());
    }

    private void selectFileToAttach() {
        JFrame owner = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(owner, 0, "Choose File", "Select the file to attach.", this.filters, true);
        chooser.setMultiSelectionEnabled(true);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(42));
        chooser.setApproveButtonText("Attach");
        chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(chooser);
    }

    private void viewImage(long imageID) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        ViewImage evt = new ViewImage(this.model.getSecurityContext(), new ViewImageObject(imageID), null);
        evt.setPlugin(MetadataViewerAgent.runAsPlugin());
        bus.post(evt);
    }

    private void viewImage(String imageName) {
    }

    private void download() {
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        int type = 2;
        FileChooser chooser = new FileChooser(f, type, "Download", "Select where to download the file(s).");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(77));
        chooser.setApproveButtonText("Download");
        chooser.setCheckOverride(true);
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                FileChooser src = (FileChooser)evt.getSource();
                if ("approveSelection".equals(name)) {
                    String path = (String)evt.getNewValue();
                    EditorControl.this.model.downloadOriginal(path, src.isOverride());
                }
            }
        });
        chooser.centerDialog();
    }

    void saveAs(final int format) {
        String v = FigureParam.FORMATS.get(format);
        final JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(new ZipFilter());
        FileChooser chooser = new FileChooser(f, 1, "Save As", "Select where to save locally the images as " + v, filters);
        try {
            File file = UIUtilities.getDefaultFolder();
            if (file != null) {
                chooser.setCurrentDirectory(file);
            }
            chooser.setSelectedFile(UIUtilities.generateFileName(file, "Batch_Image_Export", "zip"));
        }
        catch (Exception file) {
            // empty catch block
        }
        chooser.setApproveButtonText("Save");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(118));
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    MessageBox msg;
                    int option;
                    File[] files = (File[])evt.getNewValue();
                    if (files == null || files.length == 0) {
                        return;
                    }
                    File file = files[0];
                    if (file == null) {
                        file = UIUtilities.generateFileName(UIUtilities.getDefaultFolder(), "Batch_Image_Export", "zip");
                    }
                    if (file.exists() && (option = (msg = new MessageBox(f, "File Exists", "Do you want to overwrite the file?")).centerMsgBox()) == 0) {
                        return;
                    }
                    Object src = evt.getSource();
                    if (src instanceof FileChooser) {
                        ((FileChooser)src).setVisible(false);
                        ((FileChooser)src).dispose();
                    }
                    EditorControl.this.model.saveAs(file.getParentFile(), format, UIUtilities.removeFileExtension(file.getName()));
                }
            }
        });
        chooser.centerDialog();
    }

    private void export() {
        DowngradeChooser chooser = new DowngradeChooser(new RefWindow(), 1, "Export", "Select where to export the image as OME-TIFF.", this.exportFilters);
        try {
            chooser.parseData();
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().debug((Object)this, msg);
        }
        String s = UIUtilities.removeFileExtension(this.view.getRefObjectName());
        chooser.setSelectedFileFull(s);
        chooser.setCheckOverride(true);
        chooser.setApproveButtonText("Export");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(73));
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File[] files = (File[])evt.getNewValue();
                    File folder = files[0];
                    if (folder == null) {
                        folder = UIUtilities.getDefaultFolder();
                    }
                    Object src = evt.getSource();
                    Target target = null;
                    if (src instanceof DowngradeChooser) {
                        ((FileChooser)src).setVisible(false);
                        ((FileChooser)src).dispose();
                        target = ((DowngradeChooser)src).getSelectedSchema();
                    }
                    EditorControl.this.model.exportImageAsOMETIFF(folder, target);
                } else if ("helpDowngrade".equals(name)) {
                    Registry reg = MetadataViewerAgent.getRegistry();
                    String url = (String)reg.lookup("HelpDowngrade");
                    reg.getTaskBar().openURL(url);
                }
            }
        });
        chooser.centerDialog();
    }

    void initialize(Editor model, EditorUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = view;
        this.createFileFilters();
    }

    void loadChannelData() {
        this.model.loadChannelData();
    }

    void loadParents() {
        this.model.loadParents();
    }

    void loadImageAcquisitionData() {
        this.model.loadImageAcquisitionData();
    }

    void loadChannelAcquisitionData(ChannelData channel) {
        this.model.loadChannelAcquisitionData(channel);
    }

    void loadInstrumentData() {
        this.model.loadInstrumentData();
    }

    void loadExistingTags() {
        this.model.loadExistingTags();
    }

    boolean isSingleMode() {
        return this.view.isSingleMode();
    }

    FigureDialog createFigureDialog(String name, PixelsData pixels, int index) {
        if (this.figureDialog != null) {
            return this.figureDialog;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (FigureDialog.needPixels(index) && pixels == null) {
            un.notifyInfo("Figure", "The image is not valid, cannot create the figure.");
            return null;
        }
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        this.figureDialog = new FigureDialog(f, name, pixels, index, this.view.getRefObject().getClass());
        this.figureDialog.addPropertyChangeListener(this);
        return this.figureDialog;
    }

    FigureDialog getFigureDialog() {
        return this.figureDialog;
    }

    void loadFileset() {
        this.model.loadFileset();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane;
        if (e.getSource() instanceof JTabbedPane && this.view.checkIfTabEnabled((pane = (JTabbedPane)e.getSource()).getSelectedIndex()) && pane.getSelectedIndex() == 2) {
            this.model.loadRenderingControl(0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("saveData".equals(name)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.view.saveData(b);
        } else if ("clearSaveData".equals(name) || "adminUpdated".equals(name)) {
            this.view.clearData();
        } else if ("onDataSave".equals(name) && evt.getNewValue() == this.view.getRefObject()) {
            this.view.clearData();
        } else if ("collapsed".equals(name)) {
            this.view.handleTaskPaneCollapsed((JXTaskPane)evt.getSource());
        } else if ("approveSelection".equals(name)) {
            File[] files = (File[])evt.getNewValue();
            this.view.attachFiles(files);
        } else if ("removeAnnotation".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                DocComponent doc = (DocComponent)object;
                Object data = doc.getData();
                if (data instanceof FileAnnotationData) {
                    this.model.removeFileAnnotations(Collections.singletonList((FileAnnotationData)data));
                } else if (data instanceof TagAnnotationData || data instanceof TermAnnotationData || data instanceof XMLAnnotationData || data instanceof LongAnnotationData || data instanceof DoubleAnnotationData || data instanceof BooleanAnnotationData) {
                    this.view.removeObject((DataObject)data);
                }
            } else if (object instanceof TextualAnnotationComponent) {
                TextualAnnotationComponent doc = (TextualAnnotationComponent)object;
                this.view.removeObject(doc.getData());
            }
        } else if ("editTag".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                DataObject d = (DataObject)((DocComponent)object).getData();
                OmeroMetadataService svc = MetadataViewerAgent.getRegistry().getMetadataService();
                long id = MetadataViewerAgent.getUserDetails().getId();
                try {
                    svc.saveData(this.model.getSecurityContext(), Arrays.asList(d), null, null, id);
                }
                catch (Exception e) {
                    Logger l = MetadataViewerAgent.getRegistry().getLogger();
                    LogMessage msg = new LogMessage();
                    msg.print("Saving object");
                    msg.print((Throwable)e);
                    l.error((Object)this, msg);
                }
            }
        } else if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            switch (object.getIndex()) {
                case 2: {
                    long id = object.getId();
                    if (id < 0L) {
                        this.viewImage(object.getName());
                        break;
                    }
                    this.viewImage(id);
                }
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.view.handleObjectsSelection(type, (Collection)entry.getValue());
            }
        } else if ("cancelSelection".equals(name)) {
            this.view.setStatus(false);
        } else if ("settingsApplied".equals(name)) {
            this.model.loadRenderingControl(1);
            this.view.onSettingsApplied(true);
        } else if ("activityOptions".equals(name)) {
            List l = (List)evt.getNewValue();
            this.view.activityOptions((Component)l.get(0), (Point)l.get(1), (Integer)l.get(2));
        } else if ("createFigure".equals(name)) {
            this.view.createFigure(evt.getNewValue());
        } else if ("closeFigure".equals(name)) {
            this.figureDialog = null;
        } else if ("closeRenderer".equals(name)) {
            this.view.discardRenderer(evt.getNewValue());
        } else if ("relatedNodes".equals(name)) {
            this.view.onRelatedNodesSet();
        } else if (!"runSelectedScript".equals(name)) {
            if ("downloadSelectedScript".equals(name)) {
                ScriptObject script;
                Object value = evt.getNewValue();
                if (value instanceof ScriptObject) {
                    this.view.manageScript((ScriptObject)value, 101);
                } else if (value instanceof String && (script = this.model.getScriptFromName((String)value)) != null) {
                    this.view.manageScript(script, 101);
                }
            } else if ("viewSelectedScript".equals(name)) {
                ScriptObject script;
                Object value = evt.getNewValue();
                if (value instanceof ScriptObject) {
                    this.view.manageScript((ScriptObject)value, 102);
                } else if (value instanceof String && (script = this.model.getScriptFromName((String)value)) != null) {
                    this.view.manageScript(script, 102);
                }
            } else if ("analysisResultsDelete".equals(name)) {
                AnalysisResultsItem item = (AnalysisResultsItem)evt.getNewValue();
                List<FileAnnotationData> list = item.getAttachments();
                this.view.fireAnnotationsDeletion(list);
            } else if ("analysisResultsView".equals(name)) {
                AnalysisResultsItem item = (AnalysisResultsItem)evt.getNewValue();
                if (this.view.getRndIndex() == 0) {
                    this.model.displayAnalysisResults(item);
                } else {
                    this.model.displayAnalysisResults(item);
                }
            } else if ("analysisResultsCancel".equals(name)) {
                AnalysisResultsItem item = (AnalysisResultsItem)evt.getNewValue();
                this.view.cancelAnalysisResultsLoading(item);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ScriptMenuItem) {
            ScriptMenuItem item = (ScriptMenuItem)e.getSource();
            if (item.isScriptWithUI()) {
                switch (item.getIndex()) {
                    case 2: {
                        this.model.createFigure(2);
                        break;
                    }
                    case 0: {
                        this.model.createFigure(1);
                        break;
                    }
                    case 1: {
                        this.model.createFigure(3);
                        break;
                    }
                    case 3: {
                        this.model.createFigure(0);
                        break;
                    }
                    case 4: {
                        this.view.makeMovie(-1, null);
                    }
                }
            } else {
                ScriptObject object = item.getScript();
                if (!object.isParametersLoaded()) {
                    this.model.loadScript(object.getScriptID());
                } else {
                    this.model.setScript(object);
                }
            }
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.selectFileToAttach();
                break;
            }
            case 1: {
                this.model.loadExistingAttachments();
                break;
            }
            case 3: {
                this.view.saveData(true);
                break;
            }
            case 4: {
                this.download();
                break;
            }
            case 2: {
                this.loadExistingTags();
                break;
            }
            case 7: {
                this.view.makeMovie(-1, null);
                break;
            }
            case 8: {
                this.model.loadRenderingControl(0);
                break;
            }
            case 10: {
                this.model.refresh();
                break;
            }
            case 11: {
                this.export();
                break;
            }
            case 12: {
                this.model.createFigure(0);
                break;
            }
            case 13: {
                this.model.createFigure(1);
                break;
            }
            case 14: {
                this.model.createFigure(3);
                break;
            }
            case 16: {
                this.model.createFigure(2);
                break;
            }
            case 17: {
                this.view.uploadScript();
                break;
            }
            case 18: {
                this.view.reloadScript();
                break;
            }
            case 22: {
                RndProxyDef def;
                Object refObject = this.view.getRefObject();
                ImageData img = null;
                if (refObject instanceof ImageData) {
                    img = (ImageData)refObject;
                } else if (refObject instanceof WellSampleData) {
                    img = ((WellSampleData)refObject).getImage();
                }
                if (img == null) break;
                ViewImageObject vio = new ViewImageObject(img);
                if (this.model.getRenderer() != null && (def = this.model.getRenderer().getSelectedDef()) != null) {
                    vio.setSelectedRndDef(def.getDataID());
                }
                MetadataViewerAgent.getRegistry().getEventBus().post(new ViewImage(this.model.getSecurityContext(), vio, null));
                break;
            }
            case 23: {
                Object object = this.view.getRefObject();
                ImageData image = null;
                if (object instanceof ImageData) {
                    image = (ImageData)object;
                } else if (object instanceof WellSampleData) {
                    image = ((WellSampleData)object).getImage();
                }
                if (image == null) break;
                ViewInPluginEvent event = new ViewInPluginEvent(this.model.getSecurityContext(), (DataObject)object, 1);
                MetadataViewerAgent.getRegistry().getEventBus().post(event);
                break;
            }
            case 24: {
                if (this.view.getFileset() != null) {
                    this.view.displayFileset();
                    break;
                }
                this.loadFileset();
                break;
            }
            case 26: {
                this.view.displayLocation();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JButton src = (JButton)e.getSource();
        if (!src.isEnabled()) {
            return;
        }
        int index = Integer.parseInt(src.getActionCommand());
        Point p = e.getPoint();
        switch (index) {
            case 19: {
                this.view.removeTags(src, p);
                break;
            }
            case 20: {
                this.view.removeAttachedFiles(src, p);
                break;
            }
            case 25: {
                this.view.removeOtherAnnotations(src, p);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    public void reloadROICount() {
    }
}

