/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WrapLayout;

public class TagsTaskPaneUI
extends AnnotationTaskPaneUI {
    private List<DocComponent> tagsDocList;
    private JButton addTagsButton;
    private JButton removeTagsButton;
    private List<TagAnnotationData> toRemove = new ArrayList<TagAnnotationData>();
    private List<TagAnnotationData> toAdd = new ArrayList<TagAnnotationData>();

    TagsTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.setLayout(new WrapLayout(0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.tagsDocList = new ArrayList<DocComponent>();
    }

    @Override
    void clearDisplay() {
        this.removeAll();
        this.tagsDocList.clear();
    }

    private void layoutTags(Collection list) {
        DocComponent doc;
        this.removeAll();
        this.tagsDocList.clear();
        this.filter(list);
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            switch (this.filter) {
                case SHOW_ALL: {
                    while (i.hasNext()) {
                        doc = new DocComponent(i.next(), this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        this.add(doc);
                    }
                    break;
                }
                case ADDED_BY_ME: {
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        if (!this.model.isLinkOwner(data)) continue;
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        this.add(doc);
                    }
                    break;
                }
                case ADDED_BY_OTHERS: {
                    while (i.hasNext()) {
                        DataObject data = (DataObject)i.next();
                        if (!this.model.isAnnotatedByOther(data)) continue;
                        doc = new DocComponent(data, this.model);
                        doc.addPropertyChangeListener(this.controller);
                        this.tagsDocList.add(doc);
                        this.add(doc);
                    }
                    break;
                }
            }
        }
        if (this.tagsDocList.size() == 0) {
            doc = new DocComponent(null, this.model);
            this.tagsDocList.add(doc);
            this.add(doc);
        }
    }

    void filter(Collection collection) {
        HashSet<Long> ids = new HashSet<Long>();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            long id = ((DataObject)it.next()).getId();
            if (ids.contains(id)) {
                it.remove();
                continue;
            }
            ids.add(id);
        }
    }

    @Override
    void refreshUI() {
        this.clearDisplay();
        this.toAdd.clear();
        this.toRemove.clear();
        Collection<TagAnnotationData> l = !this.model.isMultiSelection() ? this.model.getTags() : this.model.getAllTags();
        this.layoutTags(l);
        this.addTagsButton.setEnabled(this.model.canAddAnnotationLink());
        this.removeTagsButton.setEnabled(this.model.canAddAnnotationLink());
    }

    List<TagAnnotationData> removeTags() {
        ArrayList<TagAnnotationData> list = new ArrayList<TagAnnotationData>();
        if (this.tagsDocList.size() == 0) {
            return list;
        }
        ArrayList<TagAnnotationData> toKeep = new ArrayList<TagAnnotationData>();
        for (DocComponent doc : this.tagsDocList) {
            Object object = doc.getData();
            if (doc.canUnlink()) {
                TagAnnotationData data;
                if (!(object instanceof TagAnnotationData) || (data = (TagAnnotationData)object).getId() <= 0L) continue;
                list.add(data);
                continue;
            }
            toKeep.add((TagAnnotationData)object);
        }
        this.handleObjectsSelection(TagAnnotationData.class, toKeep, false);
        return list;
    }

    void handleObjectsSelection(Class<?> type, Collection objects, boolean fire) {
        this.toAdd.clear();
        this.toRemove.clear();
        HashSet<Long> selectedIds = new HashSet<Long>();
        for (Object obj : objects) {
            if (!(obj instanceof TagAnnotationData)) continue;
            selectedIds.add(((TagAnnotationData)obj).getId());
        }
        HashSet<Long> originalIds = new HashSet<Long>();
        Collection<TagAnnotationData> originalTags = this.model.getAllTags();
        for (TagAnnotationData originalTag : originalTags) {
            if (!selectedIds.contains(originalTag.getId())) {
                this.toRemove.add(originalTag);
            }
            originalIds.add(originalTag.getId());
        }
        for (TagAnnotationData obj : objects) {
            TagAnnotationData tag;
            if (!(obj instanceof TagAnnotationData) || originalIds.contains((tag = obj).getId())) continue;
            this.toAdd.add(tag);
        }
        this.layoutTags(objects);
    }

    @Override
    List<JButton> getToolbarButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        this.addTagsButton = new JButton(icons.getIcon(56));
        UIUtilities.unifiedButtonLookAndFeel(this.addTagsButton);
        this.addTagsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addTagsButton.setToolTipText("Add tags");
        this.addTagsButton.addActionListener(this.controller);
        this.addTagsButton.setActionCommand("2");
        buttons.add(this.addTagsButton);
        this.removeTagsButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.removeTagsButton);
        this.removeTagsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.removeTagsButton.setToolTipText("Remove tags");
        this.removeTagsButton.addMouseListener(this.controller);
        this.removeTagsButton.setActionCommand("19");
        buttons.add(this.removeTagsButton);
        return buttons;
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        return new ArrayList<AnnotationData>(this.toAdd);
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        return new ArrayList<Object>(this.toRemove);
    }

    List<TagAnnotationData> getCurrentSelection() {
        ArrayList<TagAnnotationData> result = new ArrayList<TagAnnotationData>();
        for (DocComponent c : this.tagsDocList) {
            result.add((TagAnnotationData)c.getData());
        }
        return result;
    }

    boolean hasTagsToUnlink() {
        if (this.tagsDocList.size() == 0) {
            return false;
        }
        for (DocComponent doc : this.tagsDocList) {
            Object object = doc.getData();
            if (!doc.canUnlink() || !(object instanceof TagAnnotationData)) continue;
            return true;
        }
        return false;
    }

    @Override
    void onRelatedNodesSet() {
        this.addTagsButton.setEnabled(this.model.canAddAnnotationLink());
        this.removeTagsButton.setEnabled(this.model.canDeleteAnnotationLink());
    }

    @Override
    int getUnfilteredAnnotationCount() {
        if (this.model.isMultiSelection()) {
            return this.model.getAllTags().size();
        }
        return this.model.getTags().size();
    }
}

