/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CreateObjectWithChildren
extends TreeViewerAction {
    public static final int DATASET = 1;
    private static final String NAME_DATASET = "New Dataset...";
    private static final String DESCRIPTION_DATASET = "Create a new Dataset and add the selected orphaned images to it.";
    private int index;

    private void checkType(int value) {
        IconManager im = IconManager.getInstance();
        switch (value) {
            case 1: {
                this.name = NAME_DATASET;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
                this.putValue("SmallIcon", im.getIcon(5));
                break;
            }
        }
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (browser.getBrowserType() != 6) {
                    this.setEnabled(TreeViewerAgent.canCreate());
                    break;
                }
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        TreeImageDisplay[] selection = browser.getSelectedDisplays();
        int count = 0;
        switch (this.index) {
            case 1: {
                if (ho instanceof ImageData) {
                    for (int i = 0; i < selection.length; ++i) {
                        if (!this.model.canAnnotate(selection[i].getUserObject())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selection.length);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(false);
            }
        }
    }

    public CreateObjectWithChildren(TreeViewer model, int index) {
        super(model);
        this.index = index;
        this.checkType(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DatasetData d = new DatasetData();
        EditorDialog dialog = new EditorDialog(this.model.getUI(), (DataObject)d, false);
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("createNoParent".equals(name) || "create".equals(name)) {
                    DataObject object = (DataObject)evt.getNewValue();
                    CreateObjectWithChildren.this.model.createDataObjectWithChildren(object);
                }
            }
        });
        UIUtilities.centerAndShow(dialog);
    }
}

