/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.util.DeletableTableNode;

class DeletableTableRenderer
extends DefaultTreeCellRenderer {
    private static final Icon IMAGE_ICON;
    private static final Icon DATASET_ICON;
    private static final Icon PROJECT_ICON;
    private static final Icon SCREEN_ICON;
    private static final Icon PLATE_ICON;
    private static final Icon FILE_ICON;
    private IconManager icons;

    DeletableTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            this.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
        }
        if (!(value instanceof DeletableTableNode)) {
            return this;
        }
        DeletableTableNode node = (DeletableTableNode)((Object)value);
        String type = node.getType();
        if ("Image".equals(type)) {
            this.setIcon(IMAGE_ICON);
        } else if ("Dataset".equals(type)) {
            this.setIcon(DATASET_ICON);
        } else if ("Project".equals(type)) {
            this.setIcon(PROJECT_ICON);
        } else if ("Plate".equals(type)) {
            this.setIcon(PLATE_ICON);
        } else if ("Screen".equals(type)) {
            this.setIcon(SCREEN_ICON);
        } else if ("File".equals(type)) {
            this.setIcon(FILE_ICON);
        }
        this.setText(type);
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        IMAGE_ICON = icons.getIcon(6);
        DATASET_ICON = icons.getIcon(5);
        PROJECT_ICON = icons.getIcon(4);
        SCREEN_ICON = icons.getIcon(75);
        PLATE_ICON = icons.getIcon(77);
        FILE_ICON = icons.getIcon(81);
    }
}

