/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.dnd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.ActivationDataFlavor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.dnd.ObjectToTransfer;
import org.openmicroscopy.shoola.agents.util.dnd.TransferableNode;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class DnDTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    public static final String DRAGGED_PROPERTY = "dragged";
    static DataFlavor[] supportedFlavors;
    static DataFlavor localFlavor;
    private static Color DEFAULT_COLOR;
    private DragSource dragSource;
    private TreeNode dropTargetNode;
    private BufferedImage imgGhost;
    private boolean administrator;
    private long userID;
    private Cursor cursor;
    private Cursor defaultCursor;
    private boolean dropAllowed;
    private int dropLocation;
    private Point lastPosition;
    private Rectangle outer;
    private Rectangle inner;
    private Timer timer;
    private int hysteresis = 10;
    private static final int AUTOSCROLL_INSET = 10;
    private List<TreeImageDisplay> toTransfer = new ArrayList<TreeImageDisplay>();

    private void handleMouseOver(TreeImageDisplay node, Transferable transferable) {
        TreeImageDisplay parent = node;
        if (node.isLeaf() && node instanceof TreeImageNode) {
            parent = (TreeImageDisplay)node.getParent();
        }
        Object ot = parent.getUserObject();
        try {
            ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>();
            nodes.addAll(this.toTransfer);
            if (nodes.size() == 0) {
                return;
            }
            TreeImageDisplay first = (TreeImageDisplay)nodes.get(0);
            Object child = first.getUserObject();
            if (ot instanceof GroupData && child instanceof ExperimenterData && !this.administrator) {
                this.setCursor(this.createCursor());
                this.dropAllowed = false;
                return;
            }
            ArrayList<TreeImageDisplay> list = new ArrayList<TreeImageDisplay>();
            Iterator i = nodes.iterator();
            Object os = null;
            int childCount = 0;
            while (i.hasNext()) {
                TreeImageDisplay n = (TreeImageDisplay)i.next();
                os = n.getUserObject();
                if (parent.contains(n)) {
                    ++childCount;
                    continue;
                }
                if (!EditorUtil.isTransferable(ot, os, this.userID)) continue;
                list.add(n);
            }
            if (childCount == nodes.size() || list.size() == 0 || list.size() == 1 && parent == list.get(0)) {
                this.setCursor(this.createCursor());
                this.dropAllowed = false;
            }
        }
        catch (Exception e) {
            this.dropAllowed = false;
        }
    }

    private Cursor getCursor(int action) {
        return this.defaultCursor;
    }

    private Cursor createCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        IconManager icons = IconManager.getInstance();
        Image image = icons.getIcon(153).getImage();
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.cursor = tk.createCustomCursor(image, new Point(0, 0), "img");
        return this.cursor;
    }

    private void createGhostImage(Point p) {
        Rectangle r;
        TreePath path;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        Rectangle rect = new Rectangle();
        rect.x = Integer.MAX_VALUE;
        rect.y = Integer.MIN_VALUE;
        int[] values = new int[paths.length];
        int y = 0;
        for (int i = 0; i < paths.length; ++i) {
            values[i] = y;
            path = paths[i];
            r = this.getPathBounds(path);
            if (rect.width < r.width) {
                rect.width = r.width;
            }
            rect.height += r.height;
            rect.x = Math.min(rect.x, r.x);
            rect.y = Math.max(rect.y, r.y);
            y += r.height;
        }
        this.imgGhost = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), 3);
        Graphics2D g2 = this.imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        Icon icon = null;
        int offset = -1;
        for (int i = 0; i < paths.length; ++i) {
            path = paths[i];
            r = this.getPathBounds(path);
            JLabel label = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
            icon = label.getIcon();
            if (icon != null) {
                icon.paintIcon(label, g2, 0, values[i]);
            }
            int v = icon == null ? 0 : icon.getIconWidth();
            g2.setColor(label.getForeground());
            g2.setFont(label.getFont());
            FontMetrics fm = g2.getFontMetrics();
            g2.drawString(label.getText(), v += label.getIconTextGap(), values[i] + fm.getAscent() + 1);
            if (offset >= 0) continue;
            offset = icon == null ? 0 : icon.getIconWidth();
            offset += label.getIconTextGap();
        }
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(offset, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, DEFAULT_COLOR));
        g2.fillRect(offset, 0, this.getWidth(), this.imgGhost.getHeight());
        g2.dispose();
    }

    public DnDTree(long userID, boolean administrator) {
        this.setName("project tree");
        this.defaultCursor = this.getCursor();
        this.dropLocation = -1;
        this.reset(userID, administrator);
        this.setDragEnabled(true);
        this.dropTargetNode = null;
        this.dragSource = new DragSource();
        DropTarget target = new DropTarget(this, this);
        target.setDefaultActions(3);
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DnDTree.this.setCursor(DnDTree.this.defaultCursor);
            }
        });
        this.outer = new Rectangle();
        this.inner = new Rectangle();
        Toolkit t = Toolkit.getDefaultToolkit();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DnDTree.this.updateRegion();
                Point componentPosition = new Point(DnDTree.this.lastPosition);
                SwingUtilities.convertPointFromScreen(componentPosition, DnDTree.this);
                if (DnDTree.this.outer.contains(componentPosition) && !DnDTree.this.inner.contains(componentPosition)) {
                    DnDTree.this.autoscroll(componentPosition);
                }
            }
        };
        Integer prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
        this.timer = new Timer(prop == null ? 100 : prop, al);
        prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
        this.timer.setInitialDelay(prop == null ? 100 : prop);
        prop = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
        if (prop != null) {
            this.hysteresis = prop;
        }
    }

    private void autoscroll(Point position) {
        int dx;
        Rectangle r;
        int dy;
        DnDTree s = this;
        if (position.y < this.inner.y) {
            dy = s.getScrollableUnitIncrement(this.outer, 1, -1);
            r = new Rectangle(this.inner.x, this.outer.y - dy, this.inner.width, dy);
            this.scrollRectToVisible(r);
        } else if (position.y > this.inner.y + this.inner.height) {
            dy = s.getScrollableUnitIncrement(this.outer, 1, 1);
            r = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, dy);
            this.scrollRectToVisible(r);
        }
        if (position.x < this.inner.x) {
            dx = s.getScrollableUnitIncrement(this.outer, 0, -1);
            r = new Rectangle(this.outer.x - dx, this.inner.y, dx, this.inner.height);
            this.scrollRectToVisible(r);
        } else if (position.x > this.inner.x + this.inner.width) {
            dx = s.getScrollableUnitIncrement(this.outer, 0, 1);
            r = new Rectangle(this.outer.x + this.outer.width, this.inner.y, dx, this.inner.height);
            this.scrollRectToVisible(r);
        }
    }

    private void updateRegion() {
        Rectangle visible = this.getVisibleRect();
        this.outer.setBounds(visible.x, visible.y, visible.width, visible.height);
        Insets i = new Insets(0, 0, 0, 0);
        if (this instanceof Scrollable) {
            int minSize = 20;
            if (visible.width >= minSize) {
                i.right = 10;
                i.left = 10;
            }
            if (visible.height >= minSize) {
                i.bottom = 10;
                i.top = 10;
            }
        }
        this.inner.setBounds(visible.x + i.left, visible.y + i.top, visible.width - (i.left + i.right), visible.height - (i.top + i.bottom));
    }

    public void reset(long userID, boolean administrator) {
        this.userID = userID;
        this.administrator = administrator;
    }

    public void reset() {
        this.dropTargetNode = null;
    }

    public TreeNode getDropTargetNode() {
        return this.dropTargetNode;
    }

    public int getRowDropLocation() {
        return this.dropLocation;
    }

    public boolean isDropAllowed() {
        return this.dropAllowed;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point dragPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dragPoint.x, dragPoint.y);
        this.dropTargetNode = path == null ? null : (TreeNode)path.getLastPathComponent();
        this.repaint();
        Point p = dtde.getLocation();
        SwingUtilities.convertPointToScreen(p, this);
        if (this.lastPosition != null) {
            if (Math.abs(p.x - this.lastPosition.x) > this.hysteresis || Math.abs(p.y - this.lastPosition.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
        this.lastPosition = p;
        this.setCursor(this.getCursor(dtde.getDropAction()));
        this.dropAllowed = true;
        if (path == null) {
            this.dropTargetNode = null;
        } else {
            this.dropTargetNode = (TreeNode)path.getLastPathComponent();
            Transferable trans = dtde.getTransferable();
            if (trans != null && this.dropTargetNode instanceof TreeImageDisplay) {
                this.handleMouseOver((TreeImageDisplay)this.dropTargetNode, trans);
            }
        }
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.timer.stop();
        Point dropPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dropPoint.x, dropPoint.y);
        this.dropLocation = this.getRowForPath(path);
        this.setCursor(this.defaultCursor);
        try {
            if (!this.dropAllowed) {
                dtde.rejectDrop();
                this.repaint();
                this.toTransfer.clear();
                return;
            }
        }
        catch (Exception e) {
            this.toTransfer.clear();
            return;
        }
        boolean dropped = false;
        try {
            dtde.acceptDrop(2);
            ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>();
            nodes.addAll(this.toTransfer);
            if (nodes.size() == 0) {
                dropped = true;
                dtde.dropComplete(dropped);
                this.repaint();
                return;
            }
            TreeImageDisplay parent = null;
            DefaultMutableTreeNode dropNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (dropNode instanceof TreeImageDisplay) {
                parent = (TreeImageDisplay)dropNode;
            }
            if (dropNode.isLeaf() && dropNode instanceof TreeImageNode) {
                parent = (TreeImageDisplay)dropNode.getParent();
            }
            int action = 2;
            ObjectToTransfer transfer = new ObjectToTransfer(parent, nodes, action);
            this.firePropertyChange(DRAGGED_PROPERTY, null, transfer);
            this.toTransfer.clear();
            dropped = true;
        }
        catch (Exception e) {
            try {
                dtde.rejectDrop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }
        dtde.dropComplete(dropped);
        this.repaint();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point p = e.getDragOrigin();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return;
        }
        TreeNode draggedNode = (TreeNode)path.getLastPathComponent();
        if (draggedNode == null) {
            return;
        }
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                TreeNode n = (TreeNode)paths[i].getLastPathComponent();
                if (!(n instanceof TreeImageDisplay)) continue;
                nodes.add((TreeImageDisplay)n);
            }
        }
        if (nodes.size() == 0) {
            return;
        }
        this.createGhostImage(p);
        this.toTransfer.addAll(nodes);
        TransferableNode trans = new TransferableNode("");
        try {
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (DragSource.isDragImageSupported()) {
                e.startDrag(this.getCursor(e.getDragAction()), this.imgGhost, new Point(5, 5), trans, this);
            } else {
                e.startDrag(this.getCursor(e.getDragAction()), trans, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this.setCursor(this.defaultCursor);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(this.getCursor(dsde.getDropAction()));
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.timer.stop();
    }

    static {
        DEFAULT_COLOR = new Color(255, 255, 255, 0);
        try {
            localFlavor = new ActivationDataFlavor(String.class, "Dummy Flavor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (localFlavor != null) {
            supportedFlavors = new DataFlavor[1];
            DnDTree.supportedFlavors[0] = localFlavor;
        }
    }
}

