/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.env.data.util.Target;
import org.openmicroscopy.shoola.env.data.util.TransformsParser;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class DowngradeChooser
extends FileChooser {
    public static final String HELP_DOWNGRADE_PROPERTY = "helpDowngrade";
    private List<Target> targets;
    private JComboBox box;
    private JButton helpButton;
    private TransformsParser parser;

    public DowngradeChooser(JFrame owner, int dialogType, String title, String message, List<FileFilter> filters) {
        super(owner, dialogType, title, message, filters);
    }

    public void parseData() throws Exception {
        this.helpButton = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.helpButton);
        this.helpButton.setIcon(IconManager.getInstance().getIcon(76));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DowngradeChooser.this.firePropertyChange(DowngradeChooser.HELP_DOWNGRADE_PROPERTY, false, true);
            }
        });
        this.parser = new TransformsParser();
        this.parser.parse();
        this.targets = this.parser.getTargets();
        Collections.reverse(this.targets);
        Iterator<Target> i = this.targets.iterator();
        Object[] values = new Object[this.targets.size() + 1];
        values[0] = this.parser.getCurrentSchema() + " (current)";
        int index = 1;
        while (i.hasNext()) {
            values[index] = i.next();
            ++index;
        }
        this.box = new JComboBox<Object>(values);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(new JLabel("Version:"));
        p.add(this.box);
        p.add(this.helpButton);
        this.addComponentToControls(p);
    }

    public Target getSelectedSchema() {
        if (this.box == null) {
            return null;
        }
        Object ho = this.box.getSelectedItem();
        if (ho instanceof Target) {
            return (Target)ho;
        }
        return null;
    }
}

