/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.PluginInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginEntry
extends Entry {
    private static final String PLUGIN_TAG = "plugin";
    private static final String INFO_TAG = "info";
    private static final String DEPENDENCIES_TAG = "dependencies";
    private static final String DIRECTORY_TAG = "directory";
    private static final String NAME_TAG = "name";
    private static final String ID_TAG = "id";
    private static final String CONJUNCTION_TAG = "conjunction";
    private List<PluginInfo> values = new ArrayList<PluginInfo>();

    private void extractPluginTag(Node tag, Map<String, String> values) throws ConfigException {
        String tagName = tag.getNodeName();
        if (!tag.hasChildNodes()) {
            return;
        }
        String tagValue = tag.getFirstChild().getNodeValue();
        if (DEPENDENCIES_TAG.equals(tagName) || ID_TAG.equals(tagName) || INFO_TAG.equals(tagName) || NAME_TAG.equals(tagName) || DIRECTORY_TAG.equals(tagName) || CONJUNCTION_TAG.equals(tagName)) {
            values.put(tagName, tagValue);
            return;
        }
        throw new ConfigException("Unrecognized tag within the plugin tag: " + tagName);
    }

    private Map<String, String> extractValues(Node plugin) throws DOMException, ConfigException {
        if (!PLUGIN_TAG.equals(plugin.getNodeName())) {
            throw new ConfigException("Unrecognized tag within the plugins tag: " + plugin.getNodeName());
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        if (plugin.hasChildNodes()) {
            NodeList children = plugin.getChildNodes();
            int n = children.getLength();
            while (0 < n) {
                Node child;
                if ((child = children.item(--n)).getNodeType() != 1) continue;
                this.extractPluginTag(child, tags);
            }
        }
        return tags;
    }

    PluginEntry() {
    }

    @Override
    Object getValue() {
        return this.values;
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        try {
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                int n = children.getLength();
                while (0 < n) {
                    Node child;
                    if ((child = children.item(--n)).getNodeType() != 1) continue;
                    Map<String, String> childTags = this.extractValues(child);
                    PluginInfo info = new PluginInfo(childTags.get(ID_TAG), childTags.get(DEPENDENCIES_TAG), childTags.get(DIRECTORY_TAG));
                    info.setName(childTags.get(NAME_TAG));
                    info.setInfo(childTags.get(INFO_TAG));
                    info.setConjunction(childTags.get(CONJUNCTION_TAG));
                    this.values.add(info);
                }
            }
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse Plugin entry.", dex);
        }
    }
}

