/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import omero.api.ServiceFactoryPrx;
import omero.client;
import omero.model.Session;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroSessionService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;

public class OmeroSessionServiceImpl
implements OmeroSessionService {
    public static int ImportSessionTimeout = 604800;
    private final Registry context;
    private String host;
    private int port;
    private String username;
    private String password;

    private static Map<String, String> buildRequestContext(String host, int port, String username, String password, boolean secure) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("omero.host", host);
        props.put("omero.port", String.valueOf(port));
        if (!secure) {
            props.put("Ice.Default.Router", "OMERO.Glacier2/router:tcp -p @omero.port@ -h @omero.host@");
        }
        props.put("omero.user", String.valueOf(username));
        props.put("omero.pass", String.valueOf(password));
        return props;
    }

    private static String group(Session existingSession) {
        return existingSession.getDetails().getGroup().getName().getValue();
    }

    private static long timeToIdle(int timeoutInSeconds) {
        return (long)timeoutInSeconds * 1000L;
    }

    public OmeroSessionServiceImpl(Registry context) {
        Objects.requireNonNull(context, "context");
        this.context = context;
        this.init();
    }

    private void init() {
        AdminService svc = this.context.getAdminService();
        this.host = svc.getServerName();
        this.port = svc.getPort();
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        this.username = uc.getUser().getUsername();
        this.password = uc.getUser().getPassword();
    }

    private client newClient() {
        Map<String, String> props = OmeroSessionServiceImpl.buildRequestContext(this.host, this.port, this.username, this.password, true);
        return new client(props);
    }

    @Override
    public String create(int timeout) throws Exception {
        client c = this.newClient();
        ServiceFactoryPrx serviceFactory = c.createSession();
        serviceFactory.setSecurityPassword(this.password);
        Session initialSession = serviceFactory.getSessionService().getSession(c.getSessionId());
        Session newSession = serviceFactory.getSessionService().createUserSession(0L, OmeroSessionServiceImpl.timeToIdle(timeout), OmeroSessionServiceImpl.group(initialSession));
        c.killSession();
        return newSession.getUuid().getValue();
    }

    @Override
    public String createOfflineImportSession() throws Exception {
        return this.create(ImportSessionTimeout);
    }
}

