/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model.appdata;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.appdata.ApplicationDataExtractor;
import org.openmicroscopy.shoola.env.data.util.Parser;
import org.openmicroscopy.shoola.util.image.io.IconReader;

public class MacApplicationDataExtractor
implements ApplicationDataExtractor {
    private static final String LOCATION_MAC = "/Applications";

    private Icon convert(String path) {
        if (path == null) {
            return null;
        }
        if (!((String)path).endsWith("icns")) {
            path = (String)path + ".icns";
        }
        IconReader reader = new IconReader((String)path);
        BufferedImage img = null;
        try {
            img = reader.decode(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    @Override
    public String getDefaultAppDirectory() {
        return LOCATION_MAC;
    }

    @Override
    public ApplicationData extractAppData(File file) throws Exception {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        Map<String, Object> m = Parser.parseInfoPList(file.getAbsolutePath());
        String executablePath = (String)m.get("executablePath");
        Icon icon = this.convert((String)m.get("executableIcon"));
        String applicationName = (String)m.get("executableName");
        ApplicationData data = new ApplicationData(icon, applicationName, executablePath);
        return data;
    }

    @Override
    public String[] getDefaultOpenCommandFor(URL location) {
        return new String[]{"open", location.toString()};
    }
}

